package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** DaemonEndpoint contains information about a single Daemon endpoint. */
final case class DaemonEndpoint(
  Port : Int
) {

  /** Returns a new data with Port set to new value */
  def withPort(value: Int) : DaemonEndpoint = copy(Port = value)
  /** transforms Port to result of function */
  def mapPort(f: Int => Int) : DaemonEndpoint = copy(Port = f(Port))
}

object DaemonEndpoint {

    implicit val encoder : Encoder[io.k8s.api.core.v1.DaemonEndpoint] = new Encoder[io.k8s.api.core.v1.DaemonEndpoint] {
        def apply[T : Builder](o: io.k8s.api.core.v1.DaemonEndpoint) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("Port", o.Port)
            .build
        }
    }

    implicit val decoder: Decoder[DaemonEndpoint] = new Decoder[DaemonEndpoint] {
      def apply[T : Reader](t: T): Either[String, DaemonEndpoint] = for {
          obj <- ObjectReader(t)
          Port <- obj.read[Int]("Port")
      } yield DaemonEndpoint (
          Port = Port
        )
    }
}

