package io.k8s.api.authentication.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** TokenReview attempts to authenticate a token to a known user. Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver. */
final case class TokenReview(
  spec : io.k8s.api.authentication.v1.TokenReviewSpec,
  status : Option[io.k8s.api.authentication.v1.TokenReviewStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authentication.k8s.io", "TokenReview", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.authentication.v1.TokenReviewSpec) : TokenReview = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.authentication.v1.TokenReviewSpec => io.k8s.api.authentication.v1.TokenReviewSpec) : TokenReview = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.authentication.v1.TokenReviewStatus) : TokenReview = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.authentication.v1.TokenReviewStatus => io.k8s.api.authentication.v1.TokenReviewStatus) : TokenReview = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : TokenReview = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : TokenReview = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = TokenReview.encoder.apply(this)
}

object TokenReview {

    implicit val encoder : Encoder[io.k8s.api.authentication.v1.TokenReview] = new Encoder[io.k8s.api.authentication.v1.TokenReview] {
        def apply[T : Builder](o: io.k8s.api.authentication.v1.TokenReview) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("status", o.status)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[TokenReview] = new Decoder[TokenReview] {
      def apply[T : Reader](t: T): Either[String, TokenReview] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.authentication.v1.TokenReviewSpec]("spec")
          status <- obj.readOpt[io.k8s.api.authentication.v1.TokenReviewStatus]("status")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield TokenReview (
          spec = spec,
          status = status,
          metadata = metadata
        )
    }
}

