package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet. */
final case class DaemonSetUpdateStrategy(
  rollingUpdate : Option[io.k8s.api.apps.v1.RollingUpdateDaemonSet] = None,
  `type` : Option[String] = None
) {

  /** Returns a new data with rollingUpdate set to new value */
  def withRollingUpdate(value: io.k8s.api.apps.v1.RollingUpdateDaemonSet) : DaemonSetUpdateStrategy = copy(rollingUpdate = Some(value))
  /** if rollingUpdate has a value, transforms to the result of function*/
  def mapRollingUpdate(f: io.k8s.api.apps.v1.RollingUpdateDaemonSet => io.k8s.api.apps.v1.RollingUpdateDaemonSet) : DaemonSetUpdateStrategy = copy(rollingUpdate = rollingUpdate.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : DaemonSetUpdateStrategy = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : DaemonSetUpdateStrategy = copy(`type` = `type`.map(f))
}

object DaemonSetUpdateStrategy {

    implicit val encoder : Encoder[io.k8s.api.apps.v1.DaemonSetUpdateStrategy] = new Encoder[io.k8s.api.apps.v1.DaemonSetUpdateStrategy] {
        def apply[T : Builder](o: io.k8s.api.apps.v1.DaemonSetUpdateStrategy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("rollingUpdate", o.rollingUpdate)
            .write("type", o.`type`)
            .build
        }
    }

    implicit val decoder: Decoder[DaemonSetUpdateStrategy] = new Decoder[DaemonSetUpdateStrategy] {
      def apply[T : Reader](t: T): Either[String, DaemonSetUpdateStrategy] = for {
          obj <- ObjectReader(t)
          rollingUpdate <- obj.readOpt[io.k8s.api.apps.v1.RollingUpdateDaemonSet]("rollingUpdate")
          `type` <- obj.readOpt[String]("type")
      } yield DaemonSetUpdateStrategy (
          rollingUpdate = rollingUpdate,
          `type` = `type`
        )
    }
}

