/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client;

import cats.effect.kernel.GenConcurrent;
import cats.implicits$;
import cats.syntax.EitherOps$;
import dev.hnaderi.k8s.client.Http4sKubernetesClient$;
import dev.hnaderi.k8s.client.HttpClient;
import dev.hnaderi.k8s.client.StreamingClient;
import dev.hnaderi.k8s.utils.Builder;
import dev.hnaderi.k8s.utils.Decoder;
import dev.hnaderi.k8s.utils.Encoder;
import dev.hnaderi.k8s.utils.Reader;
import dev.hnaderi.k8s.utils.package;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.EntityDecoder;
import org.http4s.EntityEncoder;
import org.http4s.Header;
import org.http4s.InvalidMessageBodyFailure$;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.QueryParamEncoder$;
import org.http4s.QueryParamKeyLike$;
import org.http4s.Request;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.http4s.client.dsl.Http4sClientDsl;
import org.http4s.client.dsl.MethodOps$;
import org.http4s.headers.Content$minusType$;
import org.typelevel.jawn.Facade;
import org.typelevel.jawn.fs2.Absorbable$;
import org.typelevel.jawn.fs2.package$;
import scala.;
import scala.$less$colon$less$;
import scala.DummyImplicit$;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.NotGiven$;

public final class Http4sKubernetesClient<F, T>
implements HttpClient<F>,
StreamingClient<?>,
Product,
Serializable {
    private final String baseUrl;
    private final Client client;
    private final GenConcurrent<F, Throwable> evidence$1;
    private final EntityEncoder<F, T> enc;
    private final EntityDecoder<F, T> dec;
    private final Builder<T> builder;
    private final Reader<T> reader;
    private final Http4sClientDsl<F> dsl;
    private Facade.SimpleFacade jawnFacade$lzy1;
    private boolean jawnFacadebitmap$1;

    public static <F, T> Http4sKubernetesClient<F, T> apply(String string, Client<F> client, GenConcurrent<F, Throwable> genConcurrent, EntityEncoder<F, T> entityEncoder, EntityDecoder<F, T> entityDecoder, Builder<T> builder, Reader<T> reader) {
        return Http4sKubernetesClient$.MODULE$.apply(string, client, genConcurrent, entityEncoder, entityDecoder, builder, reader);
    }

    public static <F, T> Http4sKubernetesClient<F, T> unapply(Http4sKubernetesClient<F, T> http4sKubernetesClient) {
        return Http4sKubernetesClient$.MODULE$.unapply(http4sKubernetesClient);
    }

    public Http4sKubernetesClient(String baseUrl, Client<F> client, GenConcurrent<F, Throwable> evidence$1, EntityEncoder<F, T> enc, EntityDecoder<F, T> dec, Builder<T> builder, Reader<T> reader) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.evidence$1 = evidence$1;
        this.enc = enc;
        this.dec = dec;
        this.builder = builder;
        this.reader = reader;
        this.dsl = new Http4sClientDsl<F>(){};
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Http4sKubernetesClient)) return false;
        Http4sKubernetesClient http4sKubernetesClient = (Http4sKubernetesClient)object;
        String string = this.baseUrl();
        String string2 = http4sKubernetesClient.baseUrl();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Client<F> client = this.client();
        Client<F> client2 = http4sKubernetesClient.client();
        if (client == null) {
            if (client2 == null) return true;
            return false;
        } else {
            if (!client.equals(client2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Http4sKubernetesClient;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Http4sKubernetesClient";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "baseUrl";
        }
        if (1 == n2) {
            return "client";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public Client<F> client() {
        return this.client;
    }

    private Facade.SimpleFacade<T> jawnFacade() {
        if (!this.jawnFacadebitmap$1) {
            this.jawnFacade$lzy1 = dev.hnaderi.k8s.jawn.package$.MODULE$.jawnFacade(this.builder);
            this.jawnFacadebitmap$1 = true;
        }
        return this.jawnFacade$lzy1;
    }

    private <A> EntityEncoder<F, A> encoder(Encoder<A> evidence$2) {
        return this.enc.contramap((Function1 & Serializable)_$3 -> {
            Object object = dev.hnaderi.k8s.utils.package$.MODULE$.EncoderOps(_$3);
            return package.EncoderOps$.MODULE$.encodeTo$extension(object, evidence$2, this.builder);
        }).withContentType(Content$minusType$.MODULE$.apply(MediaType$.MODULE$.application().merge$minuspatch$plusjson()));
    }

    private <A> EntityDecoder<F, A> decoder(Decoder<A> evidence$3) {
        return this.dec.flatMapR((Function1 & Serializable)t -> {
            Object object = dev.hnaderi.k8s.utils.package$.MODULE$.DecoderOps(t);
            Either either = implicits$.MODULE$.catsSyntaxEither(package.DecoderOps$.MODULE$.decodeTo$extension(object, evidence$3, this.reader));
            Either either2 = implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$4 -> InvalidMessageBodyFailure$.MODULE$.apply(_$4, InvalidMessageBodyFailure$.MODULE$.$lessinit$greater$default$2())));
            return EitherOps$.MODULE$.toEitherT$extension(either2, this.evidence$1);
        }, this.evidence$1);
    }

    private F urlFrom(String str, Seq<Tuple2<String, String>> params) {
        return (F)implicits$.MODULE$.toFunctorOps(cats.effect.package$.MODULE$.Concurrent().apply(this.evidence$1, DummyImplicit$.MODULE$.dummyImplicit()).fromEither(Uri$.MODULE$.fromString(new StringBuilder(0).append(this.baseUrl()).append(str).toString())), this.evidence$1).map((Function1 & Serializable)_$5 -> (Uri)_$5.withQueryParams(params.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), QueryParamEncoder$.MODULE$.stringQueryParamEncoder(), QueryParamKeyLike$.MODULE$.stringKey()));
    }

    public <O> F get(String url, Seq<Tuple2<String, String>> params, Decoder<O> evidence$4) {
        return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.urlFrom(url, params), this.evidence$1).map((Function1 & Serializable)add -> {
            Method method = this.dsl.http4sClientSyntaxMethod(Method$.MODULE$.GET());
            Request req = MethodOps$.MODULE$.apply$extension(method, add, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]));
            return Tuple2$.MODULE$.apply(add, (Object)req);
        }), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Uri add = (Uri)tuple2._1();
                Request req = (Request)tuple2._2();
                return implicits$.MODULE$.toFunctorOps(this.client().expect(req, this.decoder(evidence$4)), this.evidence$1).map((Function1 & Serializable)res -> res);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <I, O> F post(String url, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$5, Decoder<O> evidence$6) {
        return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.urlFrom(url, params), this.evidence$1).map((Function1 & Serializable)add -> {
            Method method = this.dsl.http4sClientSyntaxMethod(Method$.MODULE$.POST());
            Request req = MethodOps$.MODULE$.apply$extension(method, body, add, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), this.encoder(evidence$5));
            return Tuple2$.MODULE$.apply(add, (Object)req);
        }), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Uri add = (Uri)tuple2._1();
                Request req = (Request)tuple2._2();
                return implicits$.MODULE$.toFunctorOps(this.client().expect(req, this.decoder(evidence$6)), this.evidence$1).map((Function1 & Serializable)res -> res);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <I, O> F put(String url, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$7, Decoder<O> evidence$8) {
        return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.urlFrom(url, params), this.evidence$1).map((Function1 & Serializable)add -> {
            Method method = this.dsl.http4sClientSyntaxMethod(Method$.MODULE$.PUT());
            Request req = MethodOps$.MODULE$.apply$extension(method, body, add, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), this.encoder(evidence$7));
            return Tuple2$.MODULE$.apply(add, (Object)req);
        }), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Uri add = (Uri)tuple2._1();
                Request req = (Request)tuple2._2();
                return implicits$.MODULE$.toFunctorOps(this.client().expect(req, this.decoder(evidence$8)), this.evidence$1).map((Function1 & Serializable)res -> res);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <I, O> F patch(String url, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$9, Decoder<O> evidence$10) {
        return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.urlFrom(url, params), this.evidence$1).map((Function1 & Serializable)add -> {
            Method method = this.dsl.http4sClientSyntaxMethod(Method$.MODULE$.PATCH());
            Request req = MethodOps$.MODULE$.apply$extension(method, body, add, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), this.encoder(evidence$9));
            return Tuple2$.MODULE$.apply(add, (Object)req);
        }), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Uri add = (Uri)tuple2._1();
                Request req = (Request)tuple2._2();
                return implicits$.MODULE$.toFunctorOps(this.client().expect(req, this.decoder(evidence$10)), this.evidence$1).map((Function1 & Serializable)res -> res);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <O> F delete(String url, Seq<Tuple2<String, String>> params, Decoder<O> evidence$11) {
        return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.urlFrom(url, params), this.evidence$1).map((Function1 & Serializable)add -> {
            Method method = this.dsl.http4sClientSyntaxMethod(Method$.MODULE$.DELETE());
            Request req = MethodOps$.MODULE$.apply$extension(method, add, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]));
            return Tuple2$.MODULE$.apply(add, (Object)req);
        }), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Uri add = (Uri)tuple2._1();
                Request req = (Request)tuple2._2();
                return implicits$.MODULE$.toFunctorOps(this.client().expect(req, this.decoder(evidence$11)), this.evidence$1).map((Function1 & Serializable)res -> res);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <O> Stream<F, O> connect(String url, Seq<Tuple2<String, String>> params, Decoder<O> evidence$12) {
        return Stream$.MODULE$.eval(implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(this.urlFrom(url, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), this.evidence$1).map((Function1 & Serializable)_$6 -> (Uri)_$6.withQueryParam((Object)"watch", QueryParamKeyLike$.MODULE$.stringKey())), this.evidence$1).map((Function1 & Serializable)_$7 -> {
            Method method = this.dsl.http4sClientSyntaxMethod(Method$.MODULE$.GET());
            return MethodOps$.MODULE$.apply$extension(method, _$7, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]));
        })).flatMap((Function1 & Serializable)req -> this.client().stream(req), NotGiven$.MODULE$.value()).flatMap((Function1 & Serializable)_$8 -> package$.MODULE$.JsonStreamSyntax(_$8.body().chunks()).parseJsonStream(this.evidence$1, Absorbable$.MODULE$.ByteChunkAbsorbable(), this.jawnFacade()), NotGiven$.MODULE$.value()).flatMap((Function1 & Serializable)s -> {
            Object object = dev.hnaderi.k8s.utils.package$.MODULE$.DecoderOps(s);
            return (Stream)package.DecoderOps$.MODULE$.decodeTo$extension(object, evidence$12, this.reader).fold((Function1 & Serializable)err -> Stream$.MODULE$.raiseError((Throwable)new Exception(new StringBuilder(1).append((String)err).append("\n").append(s).toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.evidence$1)), (Function1 & Serializable)_$9 -> Stream$.MODULE$.emit(_$9));
        }, NotGiven$.MODULE$.value());
    }

    public <F, T> Http4sKubernetesClient<F, T> copy(String baseUrl, Client<F> client, GenConcurrent<F, Throwable> evidence$1, EntityEncoder<F, T> enc, EntityDecoder<F, T> dec, Builder<T> builder, Reader<T> reader) {
        return new Http4sKubernetesClient<F, T>(baseUrl, client, evidence$1, enc, dec, builder, reader);
    }

    public <F, T> String copy$default$1() {
        return this.baseUrl();
    }

    public <F, T> Client<F> copy$default$2() {
        return this.client();
    }

    public String _1() {
        return this.baseUrl();
    }

    public Client<F> _2() {
        return this.client();
    }
}

