package cool.scx.data.jdbc.type_handler.time;

import cool.scx.data.jdbc.type_handler.TypeHandler;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Instant;


public class InstantTypeHandler implements TypeHandler<Instant> {

    @Override
    public void setObject(PreparedStatement ps, int i, Instant parameter) throws SQLException {
        ps.setObject(i, parameter);
    }

    @Override
    public Instant getObject(ResultSet rs, int index) throws SQLException {
        try {
            return rs.getObject(index, Instant.class);
        } catch (SQLFeatureNotSupportedException e) {
            var str = rs.getString(index);
            return str == null ? null : Instant.parse(str);
        }
    }

}
