package cool.scx.data.jdbc;

import cool.scx.data.jdbc.dialect.Dialect;
import cool.scx.data.jdbc.sql.SQLRunner;

import javax.sql.DataSource;

import static cool.scx.data.jdbc.dialect.DialectSelector.findDialect;

public class JDBCContext {

    private final DataSource dataSource;
    private final Dialect dialect;
    private final SQLRunner sqlRunner;

    public JDBCContext(DataSource dataSource) {
        this.dataSource = dataSource;
        this.dialect = findDialect(dataSource);
        this.sqlRunner = new SQLRunner(this);
    }

    public SQLRunner sqlRunner() {
        return sqlRunner;
    }

    public Dialect dialect() {
        return this.dialect;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

}
