/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLOps;
import com.querydsl.sql.SQLSerializer;
import com.querydsl.sql.SQLTemplates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Table;

public final class NativeSQLSerializer
extends SQLSerializer {
    private final ListMultimap<Expression<?>, String> aliases = ArrayListMultimap.create();
    private final boolean wrapEntityProjections;

    public NativeSQLSerializer(Configuration configuration) {
        this(configuration, false);
    }

    public NativeSQLSerializer(Configuration configuration, boolean wrapEntityProjections) {
        super(configuration);
        this.wrapEntityProjections = wrapEntityProjections;
    }

    protected void appendAsColumnName(Path<?> path, boolean precededByDot) {
        if (path.getAnnotatedElement().isAnnotationPresent(Column.class)) {
            Column column = path.getAnnotatedElement().getAnnotation(Column.class);
            if (!column.name().isEmpty()) {
                this.append(this.getTemplates().quoteIdentifier(column.name(), precededByDot));
            } else {
                super.appendAsColumnName(path, precededByDot);
            }
        } else {
            super.appendAsColumnName(path, precededByDot);
        }
    }

    protected void handleJoinTarget(JoinExpression je) {
        SQLTemplates templates = this.getTemplates();
        Class type = je.getTarget().getType();
        if (type.isAnnotationPresent(Table.class) && templates.isSupportsAlias()) {
            boolean precededByDot;
            Table table = type.getAnnotation(Table.class);
            if (!table.schema().isEmpty() && templates.isPrintSchema()) {
                this.appendSchemaName(table.schema());
                this.append(".");
                precededByDot = true;
            } else {
                precededByDot = false;
            }
            this.appendTableName(table.name(), precededByDot);
            this.append(templates.getTableAlias());
        }
        super.handleJoinTarget(je);
    }

    private boolean isAlias(Expression<?> expr) {
        return expr instanceof Operation && ((Operation)expr).getOperator() == Ops.ALIAS;
    }

    public ListMultimap<Expression<?>, String> getAliases() {
        return this.aliases;
    }

    private boolean isAllExpression(Expression<?> expr) {
        if (expr instanceof Operation) {
            return ((Operation)expr).getOperator() == SQLOps.ALL;
        }
        if (expr instanceof TemplateExpression) {
            return ((TemplateExpression)expr).getTemplate().toString().equals("*");
        }
        return false;
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow) {
        boolean modified = false;
        HashSet<String> used = new HashSet<String>();
        Expression projection = metadata.getProjection();
        if (projection instanceof Path) {
            Path path = (Path)projection;
            if (!used.add(path.getMetadata().getName())) {
                String alias = "col_1";
                this.aliases.put((Object)projection, (Object)alias);
                projection = ExpressionUtils.as((Expression)projection, (String)alias);
                modified = true;
            } else if (path.getAnnotatedElement().isAnnotationPresent(Column.class)) {
                this.aliases.put((Object)path, (Object)path.getAnnotatedElement().getAnnotation(Column.class).name());
            } else {
                this.aliases.put((Object)path, (Object)ColumnMetadata.getName((Path)path));
            }
        } else if (projection instanceof FactoryExpression) {
            FactoryExpression factoryExpr = (FactoryExpression)projection;
            ArrayList fargs = Lists.newArrayList((Iterable)factoryExpr.getArgs());
            for (int j = 0; j < fargs.size(); ++j) {
                if (fargs.get(j) instanceof Path) {
                    Path path = (Path)fargs.get(j);
                    String columnName = path.getAnnotatedElement().isAnnotationPresent(Column.class) ? path.getAnnotatedElement().getAnnotation(Column.class).name() : ColumnMetadata.getName((Path)path);
                    if (!used.add(columnName)) {
                        String alias = "col_" + (j + 1);
                        this.aliases.put((Object)path, (Object)alias);
                        fargs.set(j, ExpressionUtils.as((Expression)((Expression)fargs.get(j)), (String)alias));
                        continue;
                    }
                    this.aliases.put((Object)path, (Object)columnName);
                    continue;
                }
                if (this.isAlias((Expression)fargs.get(j))) {
                    Operation operation = (Operation)fargs.get(j);
                    this.aliases.put((Object)operation, (Object)operation.getArg(1).toString());
                    continue;
                }
                if (this.isAllExpression((Expression)fargs.get(j))) continue;
                String alias = "col_" + (j + 1);
                this.aliases.put(fargs.get(j), (Object)alias);
                fargs.set(j, ExpressionUtils.as((Expression)((Expression)fargs.get(j)), (String)alias));
            }
            projection = Projections.tuple((ImmutableList)ImmutableList.copyOf((Collection)fargs));
            modified = true;
        } else if (this.isAlias(projection)) {
            Operation operation = (Operation)projection;
            this.aliases.put((Object)operation, (Object)operation.getArg(1).toString());
        } else if (!this.isAllExpression(projection)) {
            String alias = "col_1";
            this.aliases.put((Object)projection, (Object)alias);
            projection = ExpressionUtils.as((Expression)projection, (String)alias);
            modified = true;
        }
        if (modified) {
            metadata = metadata.clone();
            metadata.setProjection(projection);
        }
        super.serialize(metadata, forCountRow);
    }

    public void visitConstant(Object constant) {
        if (constant instanceof Collection) {
            this.append("(");
            boolean first = true;
            for (Object element : (Collection)constant) {
                if (!first) {
                    this.append(", ");
                }
                this.visitConstant(element);
                first = false;
            }
            this.append(")");
        } else if (!this.getConstantToLabel().containsKey(constant)) {
            String constLabel = String.valueOf(this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(constant, constLabel);
            this.append("?" + constLabel);
        } else {
            this.append("?" + (String)this.getConstantToLabel().get(constant));
        }
    }

    protected void visitOperation(Class<?> type, Operator operator, List<? extends Expression<?>> args) {
        if (operator == SQLOps.ALL && !RelationalPath.class.isInstance(args.get(0)) && this.wrapEntityProjections) {
            this.append("{");
            super.visitOperation(type, operator, args);
            this.append("}");
        } else {
            super.visitOperation(type, operator, args);
        }
    }
}

