/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

import com.bigdata.util.InnerCause;
import java.io.IOException;
import junit.framework.TestCase;

public class TestInnerCause
extends TestCase {
    public TestInnerCause() {
    }

    public TestInnerCause(String arg0) {
        super(arg0);
    }

    protected Throwable getInnerCause(Throwable t, Class<? extends Throwable> cls) {
        return InnerCause.getInnerCause((Throwable)t, cls);
    }

    public void test_getInnerCause_correctRejection() {
        try {
            this.getInnerCause(null, null);
            TestInnerCause.fail((String)("Expecting: " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Ignoring expected exception: " + ex);
        }
        try {
            this.getInnerCause(null, RuntimeException.class);
            TestInnerCause.fail((String)("Expecting: " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Ignoring expected exception: " + ex);
        }
        try {
            this.getInnerCause(new RuntimeException(), null);
            TestInnerCause.fail((String)("Expecting: " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Ignoring expected exception: " + ex);
        }
    }

    public void test_getInnerCause01_find_exact() {
        RuntimeException t = new RuntimeException();
        TestInnerCause.assertTrue((t == this.getInnerCause(t, RuntimeException.class) ? 1 : 0) != 0);
    }

    public void test_getInnerCause01_find_subclass() {
        IOException t = new IOException();
        TestInnerCause.assertTrue((t == this.getInnerCause(t, Exception.class) ? 1 : 0) != 0);
    }

    public void test_getInnerCause01_reject_superclass() {
        Exception t = new Exception();
        TestInnerCause.assertNull((Object)this.getInnerCause(t, IOException.class));
    }

    public void test_getInnerCause01_reject_otherType() {
        Throwable t = new Throwable();
        TestInnerCause.assertNull((Object)this.getInnerCause(t, Exception.class));
    }

    public void test_getInnerCause02_find_exact() {
        Exception cause = new Exception();
        Throwable t = new Throwable(cause);
        TestInnerCause.assertTrue((cause == this.getInnerCause(t, Exception.class) ? 1 : 0) != 0);
    }

    public void test_getInnerCause02_find_subclass() {
        IOException cause = new IOException();
        Throwable t = new Throwable(cause);
        TestInnerCause.assertTrue((cause == this.getInnerCause(t, Exception.class) ? 1 : 0) != 0);
    }

    public void test_getInnerCause02_reject_superclass() {
        Exception cause = new Exception();
        RuntimeException t = new RuntimeException(cause);
        TestInnerCause.assertNull((Object)this.getInnerCause(t, IOException.class));
    }

    public void test_getInnerCause03_reject_otherType() {
        RuntimeException cause = new RuntimeException();
        Exception t = new Exception(cause);
        TestInnerCause.assertNull((Object)this.getInnerCause(t, IOException.class));
    }
}

