/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io.buffer;

import com.aoindustries.io.Encoder;
import com.aoindustries.io.EncoderWriter;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.LoggingWriter;
import com.aoindustries.util.AtomicSequence;
import com.aoindustries.util.Sequence;
import com.aoindustries.util.WrappedException;
import java.io.IOException;
import java.io.Writer;

public class LoggingResult
implements BufferResult {
    private static final Sequence idSeq = new AtomicSequence(0L);
    final long id = idSeq.getNextSequenceValue();
    private final BufferResult wrapped;
    private final Writer log;

    protected LoggingResult(BufferResult wrapped, Writer log) throws IOException {
        this.wrapped = wrapped;
        this.log = log;
    }

    public long getId() {
        return this.id;
    }

    private void log(Encoder encoder) throws IOException {
        if (encoder == null) {
            this.log.write("null");
        } else {
            String className = encoder.getClass().getName();
            if ("com.aoindustries.encoding.JavaScriptInXhtmlAttributeEncoder".equals(className)) {
                this.log.write("javaScriptInXhtmlAttributeEncoder");
            } else if ("com.aoindustries.encoding.JavaScriptInXhtmlEncoder".equals(className)) {
                this.log.write("javaScriptInXhtmlEncoder");
            } else if ("com.aoindustries.encoding.TextInXhtmlAttributeEncoder".equals(className)) {
                this.log.write("textInXhtmlAttributeEncoder");
            } else {
                this.log.write(className);
            }
        }
    }

    private void log(Writer writer) throws IOException {
        if (writer == null) {
            this.log.write("null");
        } else if (writer instanceof LoggingWriter) {
            LoggingWriter loggingWriter = (LoggingWriter)writer;
            this.log.write("writer[");
            this.log.write(Long.toString(loggingWriter.getId()));
            this.log.write(93);
        } else if (writer instanceof EncoderWriter) {
            EncoderWriter encoderWriter = (EncoderWriter)writer;
            this.log.write("new EncoderWriter(");
            this.log(encoderWriter.getEncoder());
            this.log.write(", ");
            this.log(encoderWriter.getOut());
            this.log.write(41);
        } else {
            String classname = writer.getClass().getName();
            if (classname.equals("org.apache.jasper.runtime.BodyContentImpl")) {
                this.log.write("bodyContent");
            } else if (classname.equals("org.apache.jasper.runtime.JspWriterImpl")) {
                this.log.write("jspWriter");
            } else {
                this.log.write(classname);
            }
        }
    }

    @Override
    public long getLength() throws IOException {
        this.log.write("result[");
        this.log.write(Long.toString(this.id));
        this.log.write("].getLength();\n");
        this.log.flush();
        return this.wrapped.getLength();
    }

    public boolean isFastToString() {
        return this.wrapped.isFastToString();
    }

    public String toString() {
        try {
            this.log.write("result[");
            this.log.write(Long.toString(this.id));
            this.log.write("].toString();\n");
            this.log.flush();
        }
        catch (IOException e) {
            throw new WrappedException((Throwable)e);
        }
        return this.wrapped.toString();
    }

    public void writeTo(Writer out) throws IOException {
        this.log.write("result[");
        this.log.write(Long.toString(this.id));
        this.log.write("].writeTo(");
        this.log(out);
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.writeTo(out);
    }

    public void writeTo(Writer out, long off, long len) throws IOException {
        this.log.write("result[");
        this.log.write(Long.toString(this.id));
        this.log.write("].writeTo(");
        this.log(out);
        this.log.write(", ");
        this.log.write(Long.toString(off));
        this.log.write(", ");
        this.log.write(Long.toString(len));
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.writeTo(out, off, len);
    }

    public void writeTo(Encoder encoder, Writer out) throws IOException {
        this.log.write("result[");
        this.log.write(Long.toString(this.id));
        this.log.write("].writeTo(");
        this.log(encoder);
        this.log.write(", ");
        this.log(out);
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.writeTo(encoder, out);
    }

    public void writeTo(Encoder encoder, Writer out, long off, long len) throws IOException {
        this.log.write("result[");
        this.log.write(Long.toString(this.id));
        this.log.write("].writeTo(");
        this.log(encoder);
        this.log.write(", ");
        this.log(out);
        this.log.write(", ");
        this.log.write(Long.toString(off));
        this.log.write(", ");
        this.log.write(Long.toString(len));
        this.log.write(");\n");
        this.log.flush();
        this.wrapped.writeTo(encoder, out, off, len);
    }

    @Override
    public LoggingResult trim() throws IOException {
        LoggingResult result = new LoggingResult(this.wrapped.trim(), this.log);
        this.log.write("result[");
        this.log.write(Long.toString(result.id));
        this.log.write("] = result[");
        this.log.write(Long.toString(this.id));
        this.log.write("].trim();\n");
        this.log.flush();
        return result;
    }
}

