/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io.buffer;

import com.aoindustries.io.AoCharArrayWriter;
import com.aoindustries.io.buffer.BufferResult;
import com.aoindustries.io.buffer.BufferWriter;
import com.aoindustries.io.buffer.CharArrayBufferResult;
import com.aoindustries.io.buffer.EmptyResult;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.logging.Logger;

public class CharArrayBufferWriter
extends BufferWriter {
    private static final Logger logger = Logger.getLogger(CharArrayBufferWriter.class.getName());
    private long length = 0L;
    private final AoCharArrayWriter buffer;
    private boolean isClosed = false;
    private BufferResult result;

    public CharArrayBufferWriter(int initialSize) {
        this.buffer = new AoCharArrayWriter(initialSize);
    }

    @Override
    public void write(int c) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.buffer.write(c);
        ++this.length;
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.buffer.write(cbuf);
        this.length += (long)cbuf.length;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.buffer.write(cbuf, off, len);
        this.length += (long)len;
    }

    @Override
    public void write(String str) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.buffer.write(str);
        this.length += (long)str.length();
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.buffer.write(str, off, len);
        this.length += (long)len;
    }

    @Override
    public CharArrayBufferWriter append(CharSequence csq) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.buffer.append(csq);
        this.length += (long)csq.length();
        return this;
    }

    @Override
    public CharArrayBufferWriter append(CharSequence csq, int start, int end) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.buffer.append(csq, start, end);
        this.length += (long)(end - start);
        return this;
    }

    @Override
    public CharArrayBufferWriter append(char c) throws IOException {
        if (this.isClosed) {
            throw new ClosedChannelException();
        }
        this.buffer.append(c);
        ++this.length;
        return this;
    }

    @Override
    public void flush() {
        this.buffer.flush();
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
        this.isClosed = true;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return "CharArrayBufferWriter(length=" + this.length + ")";
    }

    @Override
    public BufferResult getResult() throws IllegalStateException {
        if (!this.isClosed) {
            throw new IllegalStateException();
        }
        if (this.result == null) {
            assert (this.length == (long)this.buffer.size());
            this.result = this.length == 0L ? EmptyResult.getInstance() : new CharArrayBufferResult(this.buffer, 0, this.buffer.size());
        }
        return this.result;
    }
}

