/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.ControlStatus;
import com.amazonaws.services.securityhub.model.ParameterConfiguration;
import com.amazonaws.services.securityhub.model.SeverityRating;
import com.amazonaws.services.securityhub.model.UpdateStatus;
import com.amazonaws.services.securityhub.model.transform.SecurityControlMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SecurityControl
implements Serializable,
Cloneable,
StructuredPojo {
    private String securityControlId;
    private String securityControlArn;
    private String title;
    private String description;
    private String remediationUrl;
    private String severityRating;
    private String securityControlStatus;
    private String updateStatus;
    private Map<String, ParameterConfiguration> parameters;
    private String lastUpdateReason;

    public void setSecurityControlId(String securityControlId) {
        this.securityControlId = securityControlId;
    }

    public String getSecurityControlId() {
        return this.securityControlId;
    }

    public SecurityControl withSecurityControlId(String securityControlId) {
        this.setSecurityControlId(securityControlId);
        return this;
    }

    public void setSecurityControlArn(String securityControlArn) {
        this.securityControlArn = securityControlArn;
    }

    public String getSecurityControlArn() {
        return this.securityControlArn;
    }

    public SecurityControl withSecurityControlArn(String securityControlArn) {
        this.setSecurityControlArn(securityControlArn);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public SecurityControl withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public SecurityControl withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setRemediationUrl(String remediationUrl) {
        this.remediationUrl = remediationUrl;
    }

    public String getRemediationUrl() {
        return this.remediationUrl;
    }

    public SecurityControl withRemediationUrl(String remediationUrl) {
        this.setRemediationUrl(remediationUrl);
        return this;
    }

    public void setSeverityRating(String severityRating) {
        this.severityRating = severityRating;
    }

    public String getSeverityRating() {
        return this.severityRating;
    }

    public SecurityControl withSeverityRating(String severityRating) {
        this.setSeverityRating(severityRating);
        return this;
    }

    public SecurityControl withSeverityRating(SeverityRating severityRating) {
        this.severityRating = severityRating.toString();
        return this;
    }

    public void setSecurityControlStatus(String securityControlStatus) {
        this.securityControlStatus = securityControlStatus;
    }

    public String getSecurityControlStatus() {
        return this.securityControlStatus;
    }

    public SecurityControl withSecurityControlStatus(String securityControlStatus) {
        this.setSecurityControlStatus(securityControlStatus);
        return this;
    }

    public SecurityControl withSecurityControlStatus(ControlStatus securityControlStatus) {
        this.securityControlStatus = securityControlStatus.toString();
        return this;
    }

    public void setUpdateStatus(String updateStatus) {
        this.updateStatus = updateStatus;
    }

    public String getUpdateStatus() {
        return this.updateStatus;
    }

    public SecurityControl withUpdateStatus(String updateStatus) {
        this.setUpdateStatus(updateStatus);
        return this;
    }

    public SecurityControl withUpdateStatus(UpdateStatus updateStatus) {
        this.updateStatus = updateStatus.toString();
        return this;
    }

    public Map<String, ParameterConfiguration> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, ParameterConfiguration> parameters) {
        this.parameters = parameters;
    }

    public SecurityControl withParameters(Map<String, ParameterConfiguration> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public SecurityControl addParametersEntry(String key, ParameterConfiguration value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, ParameterConfiguration>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public SecurityControl clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setLastUpdateReason(String lastUpdateReason) {
        this.lastUpdateReason = lastUpdateReason;
    }

    public String getLastUpdateReason() {
        return this.lastUpdateReason;
    }

    public SecurityControl withLastUpdateReason(String lastUpdateReason) {
        this.setLastUpdateReason(lastUpdateReason);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityControlId() != null) {
            sb.append("SecurityControlId: ").append(this.getSecurityControlId()).append(",");
        }
        if (this.getSecurityControlArn() != null) {
            sb.append("SecurityControlArn: ").append(this.getSecurityControlArn()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRemediationUrl() != null) {
            sb.append("RemediationUrl: ").append(this.getRemediationUrl()).append(",");
        }
        if (this.getSeverityRating() != null) {
            sb.append("SeverityRating: ").append(this.getSeverityRating()).append(",");
        }
        if (this.getSecurityControlStatus() != null) {
            sb.append("SecurityControlStatus: ").append(this.getSecurityControlStatus()).append(",");
        }
        if (this.getUpdateStatus() != null) {
            sb.append("UpdateStatus: ").append(this.getUpdateStatus()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getLastUpdateReason() != null) {
            sb.append("LastUpdateReason: ").append(this.getLastUpdateReason());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityControl)) {
            return false;
        }
        SecurityControl other = (SecurityControl)obj;
        if (other.getSecurityControlId() == null ^ this.getSecurityControlId() == null) {
            return false;
        }
        if (other.getSecurityControlId() != null && !other.getSecurityControlId().equals(this.getSecurityControlId())) {
            return false;
        }
        if (other.getSecurityControlArn() == null ^ this.getSecurityControlArn() == null) {
            return false;
        }
        if (other.getSecurityControlArn() != null && !other.getSecurityControlArn().equals(this.getSecurityControlArn())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRemediationUrl() == null ^ this.getRemediationUrl() == null) {
            return false;
        }
        if (other.getRemediationUrl() != null && !other.getRemediationUrl().equals(this.getRemediationUrl())) {
            return false;
        }
        if (other.getSeverityRating() == null ^ this.getSeverityRating() == null) {
            return false;
        }
        if (other.getSeverityRating() != null && !other.getSeverityRating().equals(this.getSeverityRating())) {
            return false;
        }
        if (other.getSecurityControlStatus() == null ^ this.getSecurityControlStatus() == null) {
            return false;
        }
        if (other.getSecurityControlStatus() != null && !other.getSecurityControlStatus().equals(this.getSecurityControlStatus())) {
            return false;
        }
        if (other.getUpdateStatus() == null ^ this.getUpdateStatus() == null) {
            return false;
        }
        if (other.getUpdateStatus() != null && !other.getUpdateStatus().equals(this.getUpdateStatus())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getLastUpdateReason() == null ^ this.getLastUpdateReason() == null) {
            return false;
        }
        return other.getLastUpdateReason() == null || other.getLastUpdateReason().equals(this.getLastUpdateReason());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityControlId() == null ? 0 : this.getSecurityControlId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityControlArn() == null ? 0 : this.getSecurityControlArn().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRemediationUrl() == null ? 0 : this.getRemediationUrl().hashCode());
        hashCode = 31 * hashCode + (this.getSeverityRating() == null ? 0 : this.getSeverityRating().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityControlStatus() == null ? 0 : this.getSecurityControlStatus().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateStatus() == null ? 0 : this.getUpdateStatus().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateReason() == null ? 0 : this.getLastUpdateReason().hashCode());
        return hashCode;
    }

    public SecurityControl clone() {
        try {
            return (SecurityControl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityControlMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

