/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.autoscaling.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.autoscaling.model.*;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/**
 * PutWarmPoolRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutWarmPoolRequestMarshaller implements Marshaller<Request<PutWarmPoolRequest>, PutWarmPoolRequest> {

    public Request<PutWarmPoolRequest> marshall(PutWarmPoolRequest putWarmPoolRequest) {

        if (putWarmPoolRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutWarmPoolRequest> request = new DefaultRequest<PutWarmPoolRequest>(putWarmPoolRequest, "AmazonAutoScaling");
        request.addParameter("Action", "PutWarmPool");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putWarmPoolRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(putWarmPoolRequest.getAutoScalingGroupName()));
        }

        if (putWarmPoolRequest.getMaxGroupPreparedCapacity() != null) {
            request.addParameter("MaxGroupPreparedCapacity", StringUtils.fromInteger(putWarmPoolRequest.getMaxGroupPreparedCapacity()));
        }

        if (putWarmPoolRequest.getMinSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger(putWarmPoolRequest.getMinSize()));
        }

        if (putWarmPoolRequest.getPoolState() != null) {
            request.addParameter("PoolState", StringUtils.fromString(putWarmPoolRequest.getPoolState()));
        }

        {
            InstanceReusePolicy instanceReusePolicy = putWarmPoolRequest.getInstanceReusePolicy();
            if (instanceReusePolicy != null) {

                if (instanceReusePolicy.getReuseOnScaleIn() != null) {
                    request.addParameter("InstanceReusePolicy.ReuseOnScaleIn", StringUtils.fromBoolean(instanceReusePolicy.getReuseOnScaleIn()));
                }
            }
        }

        return request;
    }

}
