/** Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT. */
package com.algolia.client.model.search

import kotlinx.serialization.*
import kotlinx.serialization.json.*

/**
 * Synonym object.
 *
 * @param objectID Unique identifier of a synonym object.
 * @param type
 * @param synonyms Words or phrases considered equivalent.
 * @param input Word or phrase to appear in query strings (for [`onewaysynonym`s](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/in-depth/one-way-synonyms/)).
 * @param word Word or phrase to appear in query strings (for [`altcorrection1` and `altcorrection2`](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/in-depth/synonyms-alternative-corrections/)).
 * @param corrections Words to be matched in records.
 * @param placeholder [Placeholder token](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/in-depth/synonyms-placeholders/) to be put inside records.
 * @param replacements Query words that will match the [placeholder token](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/in-depth/synonyms-placeholders/).
 */
@Serializable
public data class SynonymHit(

  /** Unique identifier of a synonym object. */
  @SerialName(value = "objectID") val objectID: String,

  @SerialName(value = "type") val type: SynonymType,

  /** Words or phrases considered equivalent. */
  @SerialName(value = "synonyms") val synonyms: List<String>? = null,

  /** Word or phrase to appear in query strings (for [`onewaysynonym`s](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/in-depth/one-way-synonyms/)). */
  @SerialName(value = "input") val input: String? = null,

  /** Word or phrase to appear in query strings (for [`altcorrection1` and `altcorrection2`](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/in-depth/synonyms-alternative-corrections/)). */
  @SerialName(value = "word") val word: String? = null,

  /** Words to be matched in records. */
  @SerialName(value = "corrections") val corrections: List<String>? = null,

  /** [Placeholder token](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/in-depth/synonyms-placeholders/) to be put inside records.  */
  @SerialName(value = "placeholder") val placeholder: String? = null,

  /** Query words that will match the [placeholder token](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/adding-synonyms/in-depth/synonyms-placeholders/). */
  @SerialName(value = "replacements") val replacements: List<String>? = null,
)
