/** Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT. */
package com.algolia.client.model.search

import kotlinx.serialization.*
import kotlinx.serialization.json.*

/**
 * FetchedIndex
 *
 * @param name Index name.
 * @param createdAt Index creation date. An empty string means that the index has no records.
 * @param updatedAt Date and time when the object was updated, in RFC 3339 format.
 * @param entries Number of records contained in the index.
 * @param dataSize Number of bytes of the index in minified format.
 * @param fileSize Number of bytes of the index binary file.
 * @param lastBuildTimeS Last build time.
 * @param numberOfPendingTasks Number of pending indexing operations. This value is deprecated and should not be used.
 * @param pendingTask A boolean which says whether the index has pending tasks. This value is deprecated and should not be used.
 * @param primary Only present if the index is a replica. Contains the name of the related primary index.
 * @param replicas Only present if the index is a primary index with replicas. Contains the names of all linked replicas.
 * @param virtual Only present if the index is a [virtual replica](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/how-to/sort-an-index-alphabetically/#virtual-replicas).
 */
@Serializable
public data class FetchedIndex(

  /** Index name. */
  @SerialName(value = "name") val name: String,

  /** Index creation date. An empty string means that the index has no records. */
  @SerialName(value = "createdAt") val createdAt: String,

  /** Date and time when the object was updated, in RFC 3339 format. */
  @SerialName(value = "updatedAt") val updatedAt: String,

  /** Number of records contained in the index. */
  @SerialName(value = "entries") val entries: Int,

  /** Number of bytes of the index in minified format. */
  @SerialName(value = "dataSize") val dataSize: Int,

  /** Number of bytes of the index binary file. */
  @SerialName(value = "fileSize") val fileSize: Int,

  /** Last build time. */
  @SerialName(value = "lastBuildTimeS") val lastBuildTimeS: Int,

  /** Number of pending indexing operations. This value is deprecated and should not be used. */
  @SerialName(value = "numberOfPendingTasks") val numberOfPendingTasks: Int,

  /** A boolean which says whether the index has pending tasks. This value is deprecated and should not be used. */
  @SerialName(value = "pendingTask") val pendingTask: Boolean,

  /** Only present if the index is a replica. Contains the name of the related primary index. */
  @SerialName(value = "primary") val primary: String? = null,

  /** Only present if the index is a primary index with replicas. Contains the names of all linked replicas. */
  @SerialName(value = "replicas") val replicas: List<String>? = null,

  /** Only present if the index is a [virtual replica](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/how-to/sort-an-index-alphabetically/#virtual-replicas). */
  @SerialName(value = "virtual") val virtual: Boolean? = null,
)
