/** Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT. */
package com.algolia.client.model.querysuggestions

import kotlinx.serialization.*
import kotlinx.serialization.json.*

/**
 * Configuration of an Algolia index for Query Suggestions.
 *
 * @param indexName Name of the Algolia index (case-sensitive) to use as source for query suggestions.
 * @param replicas If true, Query Suggestions uses all replica indices to find popular searches. If false, only the primary index is used.
 * @param analyticsTags
 * @param facets
 * @param minHits Minimum number of hits required to be included as a suggestion.  A search query must at least generate `minHits` search results to be included in the Query Suggestions index.
 * @param minLetters Minimum letters required to be included as a suggestion.  A search query must be at least `minLetters` long to be included in the Query Suggestions index.
 * @param generate
 * @param `external`
 */
@Serializable
public data class SourceIndex(

  /** Name of the Algolia index (case-sensitive) to use as source for query suggestions. */
  @SerialName(value = "indexName") val indexName: String,

  /** If true, Query Suggestions uses all replica indices to find popular searches. If false, only the primary index is used.  */
  @SerialName(value = "replicas") val replicas: Boolean? = null,

  @SerialName(value = "analyticsTags") val analyticsTags: List<String>? = null,

  @SerialName(value = "facets") val facets: List<Facet>? = null,

  /** Minimum number of hits required to be included as a suggestion.  A search query must at least generate `minHits` search results to be included in the Query Suggestions index.  */
  @SerialName(value = "minHits") val minHits: Int? = null,

  /** Minimum letters required to be included as a suggestion.  A search query must be at least `minLetters` long to be included in the Query Suggestions index.  */
  @SerialName(value = "minLetters") val minLetters: Int? = null,

  @SerialName(value = "generate") val generate: List<List<String>>? = null,

  @SerialName(value = "external") val `external`: List<String>? = null,
)
