/** Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT. */
package com.algolia.client.model.ingestion

import com.algolia.client.exception.AlgoliaClientException
import com.algolia.client.extensions.internal.*
import kotlinx.serialization.*
import kotlinx.serialization.builtins.*
import kotlinx.serialization.descriptors.*
import kotlinx.serialization.encoding.*
import kotlinx.serialization.json.*
import kotlin.jvm.JvmInline

/**
 * Configuration of the task, depending on its type.
 *
 * Implementations:
 * - [DockerStreamsInput]
 * - [ShopifyInput]
 * - [StreamingInput]
 */
@Serializable(TaskInputSerializer::class)
public sealed interface TaskInput {
  @Serializable
  @JvmInline
  public value class StreamingInputValue(public val value: StreamingInput) : TaskInput

  @Serializable
  @JvmInline
  public value class DockerStreamsInputValue(public val value: DockerStreamsInput) : TaskInput

  @Serializable
  @JvmInline
  public value class ShopifyInputValue(public val value: ShopifyInput) : TaskInput

  public companion object {

    public fun of(value: StreamingInput): TaskInput {
      return StreamingInputValue(value)
    }
    public fun of(value: DockerStreamsInput): TaskInput {
      return DockerStreamsInputValue(value)
    }
    public fun of(value: ShopifyInput): TaskInput {
      return ShopifyInputValue(value)
    }
  }
}

internal class TaskInputSerializer : JsonContentPolymorphicSerializer<TaskInput>(TaskInput::class) {
  override fun selectDeserializer(element: JsonElement): DeserializationStrategy<TaskInput> {
    return when {
      element is JsonObject && element.containsKey("mapping") -> StreamingInput.serializer()
      element is JsonObject && element.containsKey("streams") -> DockerStreamsInput.serializer()
      element is JsonObject -> ShopifyInput.serializer()
      else -> throw AlgoliaClientException("Failed to deserialize json element: $element")
    }
  }
}
