/** Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT. */
package com.algolia.client.model.ingestion

import com.algolia.client.exception.AlgoliaClientException
import com.algolia.client.extensions.internal.*
import kotlinx.serialization.*
import kotlinx.serialization.builtins.*
import kotlinx.serialization.descriptors.*
import kotlinx.serialization.encoding.*
import kotlinx.serialization.json.*
import kotlin.jvm.JvmInline

/**
 * AuthInput
 *
 * Implementations:
 * - [AuthAPIKey]
 * - [AuthAlgolia]
 * - [AuthAlgoliaInsights]
 * - [AuthBasic]
 * - [AuthGoogleServiceAccount]
 * - [AuthOAuth]
 */
@Serializable(AuthInputSerializer::class)
public sealed interface AuthInput {
  @Serializable
  @JvmInline
  public value class AuthOAuthValue(public val value: AuthOAuth) : AuthInput

  @Serializable
  @JvmInline
  public value class AuthGoogleServiceAccountValue(public val value: AuthGoogleServiceAccount) : AuthInput

  @Serializable
  @JvmInline
  public value class AuthBasicValue(public val value: AuthBasic) : AuthInput

  @Serializable
  @JvmInline
  public value class AuthAPIKeyValue(public val value: AuthAPIKey) : AuthInput

  @Serializable
  @JvmInline
  public value class AuthAlgoliaValue(public val value: AuthAlgolia) : AuthInput

  @Serializable
  @JvmInline
  public value class AuthAlgoliaInsightsValue(public val value: AuthAlgoliaInsights) : AuthInput

  public companion object {

    public fun of(value: AuthOAuth): AuthInput {
      return AuthOAuthValue(value)
    }
    public fun of(value: AuthGoogleServiceAccount): AuthInput {
      return AuthGoogleServiceAccountValue(value)
    }
    public fun of(value: AuthBasic): AuthInput {
      return AuthBasicValue(value)
    }
    public fun of(value: AuthAPIKey): AuthInput {
      return AuthAPIKeyValue(value)
    }
    public fun of(value: AuthAlgolia): AuthInput {
      return AuthAlgoliaValue(value)
    }
    public fun of(value: AuthAlgoliaInsights): AuthInput {
      return AuthAlgoliaInsightsValue(value)
    }
  }
}

internal class AuthInputSerializer : JsonContentPolymorphicSerializer<AuthInput>(AuthInput::class) {
  override fun selectDeserializer(element: JsonElement): DeserializationStrategy<AuthInput> {
    return when {
      element is JsonObject && element.containsKey("url") && element.containsKey("client_id") && element.containsKey("client_secret") -> AuthOAuth.serializer()
      element is JsonObject && element.containsKey("clientEmail") && element.containsKey("privateKey") -> AuthGoogleServiceAccount.serializer()
      element is JsonObject && element.containsKey("username") && element.containsKey("password") -> AuthBasic.serializer()
      element is JsonObject && element.containsKey("key") -> AuthAPIKey.serializer()
      element is JsonObject -> AuthAlgolia.serializer()
      element is JsonObject -> AuthAlgoliaInsights.serializer()
      else -> throw AlgoliaClientException("Failed to deserialize json element: $element")
    }
  }
}
