/** Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT. */
package com.algolia.client.model.analytics

import kotlinx.serialization.*
import kotlinx.serialization.json.*

/**
 * TopSearchWithRevenueAnalytics
 *
 * @param search Search query.
 * @param count Number of searches.
 * @param clickThroughRate Click-through rate, calculated as number of tracked searches with at least one click event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.
 * @param averageClickPosition Average position of a clicked search result in the list of search results. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.
 * @param clickPositions List of positions in the search results and clicks associated with this search.
 * @param conversionRate Conversion rate, calculated as number of tracked searches with at least one conversion event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.
 * @param trackedSearchCount Number of tracked searches. Tracked searches are search requests where the `clickAnalytics` parameter is true.
 * @param clickCount Number of clicks associated with this search.
 * @param conversionCount Number of conversions from this search.
 * @param nbHits Number of results (hits).
 * @param currencies Revenue associated with this search, broken-down by currencies.
 * @param addToCartRate Add-to-cart rate, calculated as number of tracked searches with at least one add-to-cart event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.
 * @param addToCartCount Number of add-to-cart events from this search.
 * @param purchaseRate Purchase rate, calculated as number of tracked searches with at least one purchase event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.
 * @param purchaseCount Number of purchase events from this search.
 */
@Serializable
public data class TopSearchWithRevenueAnalytics(

  /** Search query. */
  @SerialName(value = "search") val search: String,

  /** Number of searches. */
  @SerialName(value = "count") val count: Int,

  /** Click-through rate, calculated as number of tracked searches with at least one click event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.  */
  @SerialName(value = "clickThroughRate") val clickThroughRate: Double,

  /** Average position of a clicked search result in the list of search results. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.  */
  @SerialName(value = "averageClickPosition") val averageClickPosition: Double,

  /** List of positions in the search results and clicks associated with this search. */
  @SerialName(value = "clickPositions") val clickPositions: List<ClickPosition>,

  /** Conversion rate, calculated as number of tracked searches with at least one conversion event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.  */
  @SerialName(value = "conversionRate") val conversionRate: Double,

  /** Number of tracked searches. Tracked searches are search requests where the `clickAnalytics` parameter is true. */
  @SerialName(value = "trackedSearchCount") val trackedSearchCount: Int,

  /** Number of clicks associated with this search. */
  @SerialName(value = "clickCount") val clickCount: Int,

  /** Number of conversions from this search. */
  @SerialName(value = "conversionCount") val conversionCount: Int,

  /** Number of results (hits). */
  @SerialName(value = "nbHits") val nbHits: Int,

  /** Revenue associated with this search, broken-down by currencies. */
  @SerialName(value = "currencies") val currencies: Map<kotlin.String, CurrencyCode>,

  /** Add-to-cart rate, calculated as number of tracked searches with at least one add-to-cart event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.  */
  @SerialName(value = "addToCartRate") val addToCartRate: Double,

  /** Number of add-to-cart events from this search. */
  @SerialName(value = "addToCartCount") val addToCartCount: Int,

  /** Purchase rate, calculated as number of tracked searches with at least one purchase event divided by the number of tracked searches. If null, Algolia didn't receive any search requests with `clickAnalytics` set to true.  */
  @SerialName(value = "purchaseRate") val purchaseRate: Double,

  /** Number of purchase events from this search. */
  @SerialName(value = "purchaseCount") val purchaseCount: Int,
)
