/** Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT. */
package com.algolia.client.api

import com.algolia.client.configuration.*
import com.algolia.client.exception.*
import com.algolia.client.extensions.internal.*
import com.algolia.client.model.search.*
import com.algolia.client.transport.*
import com.algolia.client.transport.internal.*
import kotlinx.serialization.json.*

public class SearchClient(
  override val appId: String,
  override var apiKey: String,
  override val options: ClientOptions = ClientOptions(),
) : ApiClient {

  init {
    require(appId.isNotBlank()) { "`appId` is missing." }
    require(apiKey.isNotBlank()) { "`apiKey` is missing." }
  }

  override val requester: Requester = requesterOf(clientName = "Search", appId = appId, apiKey = apiKey, options = options) {
    listOf(
      Host("$appId-dsn.algolia.net", CallType.Read),
      Host("$appId.algolia.net", CallType.Write),
    ) + mutableListOf(
      Host("$appId-1.algolianet.com"),
      Host("$appId-2.algolianet.com"),
      Host("$appId-3.algolianet.com"),
    ).apply { shuffle() }
  }

  /**
   * Creates a new API key with specific permissions and restrictions.
   *
   * Required API Key ACLs:
   *   - admin
   * @param apiKey
   * @param requestOptions additional request configuration.
   */
  public suspend fun addApiKey(apiKey: ApiKey, requestOptions: RequestOptions? = null): AddApiKeyResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "keys"),
      body = apiKey,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * If a record with the specified object ID exists, the existing record is replaced. Otherwise, a new record is added to the index.  To update _some_ attributes of an existing record, use the [`partial` operation](#tag/Records/operation/partialUpdateObject) instead. To add, update, or replace multiple records, use the [`batch` operation](#tag/Records/operation/batch).
   *
   * Required API Key ACLs:
   *   - addObject
   * @param indexName Name of the index on which to perform the operation.
   * @param objectID Unique record identifier.
   * @param body The record, a schemaless object with attributes that are useful in the context of search and discovery.
   * @param requestOptions additional request configuration.
   */
  public suspend fun addOrUpdateObject(indexName: String, objectID: String, body: JsonObject, requestOptions: RequestOptions? = null): UpdatedAtWithObjectIdResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `addOrUpdateObject`." }
    require(objectID.isNotBlank()) { "Parameter `objectID` is required when calling `addOrUpdateObject`." }
    require(body.isNotEmpty()) { "Parameter `body` is required when calling `addOrUpdateObject`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("1", "indexes", "$indexName", "$objectID"),
      body = body,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Adds a source to the list of allowed sources.
   *
   * Required API Key ACLs:
   *   - admin
   * @param source Source to add.
   * @param requestOptions additional request configuration.
   */
  public suspend fun appendSource(source: Source, requestOptions: RequestOptions? = null): CreatedAtResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "security", "sources", "append"),
      body = source,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Assigns or moves a user ID to a cluster.  The time it takes to move a user is proportional to the amount of data linked to the user ID.
   *
   * Required API Key ACLs:
   *   - admin
   * @param xAlgoliaUserID Unique identifier of the user who makes the search request.
   * @param assignUserIdParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun assignUserId(xAlgoliaUserID: String, assignUserIdParams: AssignUserIdParams, requestOptions: RequestOptions? = null): CreatedAtResponse {
    require(xAlgoliaUserID.isNotBlank()) { "Parameter `xAlgoliaUserID` is required when calling `assignUserId`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "clusters", "mapping"),
      headers = buildMap {
        put("X-Algolia-User-ID", xAlgoliaUserID)
      },
      body = assignUserIdParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Adds, updates, or deletes records in one index with a single API request.  Batching index updates reduces latency and increases data integrity.  - Actions are applied in the order they're specified. - Actions are equivalent to the individual API requests of the same name.
   * @param indexName Name of the index on which to perform the operation.
   * @param batchWriteParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun batch(indexName: String, batchWriteParams: BatchWriteParams, requestOptions: RequestOptions? = null): BatchResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `batch`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "batch"),
      body = batchWriteParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Assigns multiple user IDs to a cluster.  **You can't move users with this operation**.
   *
   * Required API Key ACLs:
   *   - admin
   * @param xAlgoliaUserID Unique identifier of the user who makes the search request.
   * @param batchAssignUserIdsParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun batchAssignUserIds(xAlgoliaUserID: String, batchAssignUserIdsParams: BatchAssignUserIdsParams, requestOptions: RequestOptions? = null): CreatedAtResponse {
    require(xAlgoliaUserID.isNotBlank()) { "Parameter `xAlgoliaUserID` is required when calling `batchAssignUserIds`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "clusters", "mapping", "batch"),
      headers = buildMap {
        put("X-Algolia-User-ID", xAlgoliaUserID)
      },
      body = batchAssignUserIdsParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Adds or deletes multiple entries from your plurals, segmentation, or stop word dictionaries.
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param dictionaryName Dictionary type in which to search.
   * @param batchDictionaryEntriesParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun batchDictionaryEntries(dictionaryName: DictionaryType, batchDictionaryEntriesParams: BatchDictionaryEntriesParams, requestOptions: RequestOptions? = null): UpdatedAtResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "dictionaries", "$dictionaryName", "batch"),
      body = batchDictionaryEntriesParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves records from an index, up to 1,000 per request.  While searching retrieves _hits_ (records augmented with attributes for highlighting and ranking details), browsing _just_ returns matching records. This can be useful if you want to export your indices.  - The Analytics API doesn't collect data when using `browse`. - Records are ranked by attributes and custom ranking. - There's no ranking for: typo-tolerance, number of matched words, proximity, geo distance.  Browse requests automatically apply these settings:  - `advancedSyntax`: `false` - `attributesToHighlight`: `[]` - `attributesToSnippet`: `[]` - `distinct`: `false` - `enablePersonalization`: `false` - `enableRules`: `false` - `facets`: `[]` - `getRankingInfo`: `false` - `ignorePlurals`: `false` - `optionalFilters`: `[]` - `typoTolerance`: `true` or `false` (`min` and `strict` is evaluated to `true`)  If you send these parameters with your browse requests, they'll be ignored.
   *
   * Required API Key ACLs:
   *   - browse
   * @param indexName Name of the index on which to perform the operation.
   * @param browseParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun browse(indexName: String, browseParams: BrowseParams? = null, requestOptions: RequestOptions? = null): BrowseResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `browse`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "browse"),
      body = browseParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes only the records from an index while keeping settings, synonyms, and rules.
   *
   * Required API Key ACLs:
   *   - deleteIndex
   * @param indexName Name of the index on which to perform the operation.
   * @param requestOptions additional request configuration.
   */
  public suspend fun clearObjects(indexName: String, requestOptions: RequestOptions? = null): UpdatedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `clearObjects`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "clear"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes all rules from the index.
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param indexName Name of the index on which to perform the operation.
   * @param forwardToReplicas Whether changes are applied to replica indices.
   * @param requestOptions additional request configuration.
   */
  public suspend fun clearRules(indexName: String, forwardToReplicas: Boolean? = null, requestOptions: RequestOptions? = null): UpdatedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `clearRules`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "rules", "clear"),
      query = buildMap {
        forwardToReplicas?.let { put("forwardToReplicas", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes all synonyms from the index.
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param indexName Name of the index on which to perform the operation.
   * @param forwardToReplicas Whether changes are applied to replica indices.
   * @param requestOptions additional request configuration.
   */
  public suspend fun clearSynonyms(indexName: String, forwardToReplicas: Boolean? = null, requestOptions: RequestOptions? = null): UpdatedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `clearSynonyms`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "synonyms", "clear"),
      query = buildMap {
        forwardToReplicas?.let { put("forwardToReplicas", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   * @param path Path of the endpoint, anything after \"/1\" must be specified.
   * @param parameters Query parameters to apply to the current query.
   * @param requestOptions additional request configuration.
   */
  public suspend fun customDelete(path: String, parameters: Map<kotlin.String, Any>? = null, requestOptions: RequestOptions? = null): JsonObject {
    require(path.isNotBlank()) { "Parameter `path` is required when calling `customDelete`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = "/{path}".replace("{path}", path),
      query = buildMap {
        parameters?.let { putAll(it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   * @param path Path of the endpoint, anything after \"/1\" must be specified.
   * @param parameters Query parameters to apply to the current query.
   * @param requestOptions additional request configuration.
   */
  public suspend fun customGet(path: String, parameters: Map<kotlin.String, Any>? = null, requestOptions: RequestOptions? = null): JsonObject {
    require(path.isNotBlank()) { "Parameter `path` is required when calling `customGet`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = "/{path}".replace("{path}", path),
      query = buildMap {
        parameters?.let { putAll(it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   * @param path Path of the endpoint, anything after \"/1\" must be specified.
   * @param parameters Query parameters to apply to the current query.
   * @param body Parameters to send with the custom request.
   * @param requestOptions additional request configuration.
   */
  public suspend fun customPost(path: String, parameters: Map<kotlin.String, Any>? = null, body: JsonObject? = null, requestOptions: RequestOptions? = null): JsonObject {
    require(path.isNotBlank()) { "Parameter `path` is required when calling `customPost`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = "/{path}".replace("{path}", path),
      query = buildMap {
        parameters?.let { putAll(it) }
      },
      body = body,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   * @param path Path of the endpoint, anything after \"/1\" must be specified.
   * @param parameters Query parameters to apply to the current query.
   * @param body Parameters to send with the custom request.
   * @param requestOptions additional request configuration.
   */
  public suspend fun customPut(path: String, parameters: Map<kotlin.String, Any>? = null, body: JsonObject? = null, requestOptions: RequestOptions? = null): JsonObject {
    require(path.isNotBlank()) { "Parameter `path` is required when calling `customPut`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = "/{path}".replace("{path}", path),
      query = buildMap {
        parameters?.let { putAll(it) }
      },
      body = body,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes the API key.
   *
   * Required API Key ACLs:
   *   - admin
   * @param key API key.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteApiKey(key: String, requestOptions: RequestOptions? = null): DeleteApiKeyResponse {
    require(key.isNotBlank()) { "Parameter `key` is required when calling `deleteApiKey`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "keys", "$key"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * This operation doesn't accept empty queries or filters.  It's more efficient to get a list of object IDs with the [`browse` operation](#tag/Search/operation/browse), and then delete the records using the [`batch` operation](#tag/Records/operation/batch).
   *
   * Required API Key ACLs:
   *   - deleteIndex
   * @param indexName Name of the index on which to perform the operation.
   * @param deleteByParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteBy(indexName: String, deleteByParams: DeleteByParams, requestOptions: RequestOptions? = null): DeletedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `deleteBy`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "deleteByQuery"),
      body = deleteByParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes an index and all its settings.  - Deleting an index doesn't delete its analytics data. - If you try to delete a non-existing index, the operation is ignored without warning. - If the index you want to delete has replica indices, the replicas become independent indices. - If the index you want to delete is a replica index, you must first unlink it from its primary index before you can delete it.   For more information, see [Delete replica indices](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/how-to/deleting-replicas/).
   *
   * Required API Key ACLs:
   *   - deleteIndex
   * @param indexName Name of the index on which to perform the operation.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteIndex(indexName: String, requestOptions: RequestOptions? = null): DeletedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `deleteIndex`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "indexes", "$indexName"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes a record by its object ID.  To delete more than one record, use the [`batch` operation](#tag/Records/operation/batch). To delete records matching a query, use the [`deleteByQuery` operation](#tag/Records/operation/deleteBy).
   *
   * Required API Key ACLs:
   *   - deleteObject
   * @param indexName Name of the index on which to perform the operation.
   * @param objectID Unique record identifier.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteObject(indexName: String, objectID: String, requestOptions: RequestOptions? = null): DeletedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `deleteObject`." }
    require(objectID.isNotBlank()) { "Parameter `objectID` is required when calling `deleteObject`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "indexes", "$indexName", "$objectID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes a rule by its ID. To find the object ID for rules, use the [`search` operation](#tag/Rules/operation/searchRules).
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param indexName Name of the index on which to perform the operation.
   * @param objectID Unique identifier of a rule object.
   * @param forwardToReplicas Whether changes are applied to replica indices.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteRule(indexName: String, objectID: String, forwardToReplicas: Boolean? = null, requestOptions: RequestOptions? = null): UpdatedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `deleteRule`." }
    require(objectID.isNotBlank()) { "Parameter `objectID` is required when calling `deleteRule`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "indexes", "$indexName", "rules", "$objectID"),
      query = buildMap {
        forwardToReplicas?.let { put("forwardToReplicas", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes a source from the list of allowed sources.
   *
   * Required API Key ACLs:
   *   - admin
   * @param source IP address range of the source.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteSource(source: String, requestOptions: RequestOptions? = null): DeleteSourceResponse {
    require(source.isNotBlank()) { "Parameter `source` is required when calling `deleteSource`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "security", "sources", "$source"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes a synonym by its ID. To find the object IDs of your synonyms, use the [`search` operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param indexName Name of the index on which to perform the operation.
   * @param objectID Unique identifier of a synonym object.
   * @param forwardToReplicas Whether changes are applied to replica indices.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteSynonym(indexName: String, objectID: String, forwardToReplicas: Boolean? = null, requestOptions: RequestOptions? = null): DeletedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `deleteSynonym`." }
    require(objectID.isNotBlank()) { "Parameter `objectID` is required when calling `deleteSynonym`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "indexes", "$indexName", "synonyms", "$objectID"),
      query = buildMap {
        forwardToReplicas?.let { put("forwardToReplicas", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Gets the permissions and restrictions of an API key.  When authenticating with the admin API key, you can request information for any of your application's keys. When authenticating with other API keys, you can only retrieve information for that key, with the description replaced by `<redacted>`.
   * @param key API key.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getApiKey(key: String, requestOptions: RequestOptions? = null): GetApiKeyResponse {
    require(key.isNotBlank()) { "Parameter `key` is required when calling `getApiKey`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "keys", "$key"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Checks the status of a given application task.
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param taskID Unique task identifier.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getAppTask(taskID: Long, requestOptions: RequestOptions? = null): GetTaskResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "task", "$taskID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Lists supported languages with their supported dictionary types and number of custom entries.
   *
   * Required API Key ACLs:
   *   - settings
   * @param requestOptions additional request configuration.
   */
  public suspend fun getDictionaryLanguages(requestOptions: RequestOptions? = null): Map<kotlin.String, Languages> {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "dictionaries", "*", "languages"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves the languages for which standard dictionary entries are turned off.
   *
   * Required API Key ACLs:
   *   - settings
   * @param requestOptions additional request configuration.
   */
  public suspend fun getDictionarySettings(requestOptions: RequestOptions? = null): GetDictionarySettingsResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "dictionaries", "*", "settings"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * The request must be authenticated by an API key with the [`logs` ACL](https://www.algolia.com/doc/guides/security/api-keys/#access-control-list-acl).  - Logs are held for the last seven days. - Up to 1,000 API requests per server are logged. - This request counts towards your [operations quota](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-) but doesn't appear in the logs itself.
   *
   * Required API Key ACLs:
   *   - logs
   * @param offset First log entry to retrieve. The most recent entries are listed first. (default to 0)
   * @param length Maximum number of entries to retrieve. (default to 10)
   * @param indexName Index for which to retrieve log entries. By default, log entries are retrieved for all indices.
   * @param type Type of log entries to retrieve. By default, all log entries are retrieved.  (default to all)
   * @param requestOptions additional request configuration.
   */
  public suspend fun getLogs(offset: Int? = null, length: Int? = null, indexName: String? = null, type: LogType? = null, requestOptions: RequestOptions? = null): GetLogsResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "logs"),
      query = buildMap {
        offset?.let { put("offset", it) }
        length?.let { put("length", it) }
        indexName?.let { put("indexName", it) }
        type?.let { put("type", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves one record by its object ID.  To retrieve more than one record, use the [`objects` operation](#tag/Records/operation/getObjects).
   *
   * Required API Key ACLs:
   *   - search
   * @param indexName Name of the index on which to perform the operation.
   * @param objectID Unique record identifier.
   * @param attributesToRetrieve Attributes to include with the records in the response. This is useful to reduce the size of the API response. By default, all retrievable attributes are returned.  `objectID` is always retrieved.  Attributes included in `unretrievableAttributes` won't be retrieved unless the request is authenticated with the admin API key.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getObject(indexName: String, objectID: String, attributesToRetrieve: List<String>? = null, requestOptions: RequestOptions? = null): JsonObject {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `getObject`." }
    require(objectID.isNotBlank()) { "Parameter `objectID` is required when calling `getObject`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "indexes", "$indexName", "$objectID"),
      query = buildMap {
        attributesToRetrieve?.let { put("attributesToRetrieve", it.joinToString(",")) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves one or more records, potentially from different indices.  Records are returned in the same order as the requests.
   *
   * Required API Key ACLs:
   *   - search
   * @param getObjectsParams Request object.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getObjects(getObjectsParams: GetObjectsParams, requestOptions: RequestOptions? = null): GetObjectsResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "*", "objects"),
      isRead = true,
      body = getObjectsParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a rule by its ID. To find the object ID of rules, use the [`search` operation](#tag/Rules/operation/searchRules).
   *
   * Required API Key ACLs:
   *   - settings
   * @param indexName Name of the index on which to perform the operation.
   * @param objectID Unique identifier of a rule object.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getRule(indexName: String, objectID: String, requestOptions: RequestOptions? = null): Rule {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `getRule`." }
    require(objectID.isNotBlank()) { "Parameter `objectID` is required when calling `getRule`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "indexes", "$indexName", "rules", "$objectID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves an object with non-null index settings.
   *
   * Required API Key ACLs:
   *   - search
   * @param indexName Name of the index on which to perform the operation.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getSettings(indexName: String, requestOptions: RequestOptions? = null): SettingsResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `getSettings`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "indexes", "$indexName", "settings"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves all allowed IP addresses with access to your application.
   *
   * Required API Key ACLs:
   *   - admin
   * @param requestOptions additional request configuration.
   */
  public suspend fun getSources(requestOptions: RequestOptions? = null): List<Source> {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "security", "sources"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a syonym by its ID. To find the object IDs for your synonyms, use the [`search` operation](#tag/Synonyms/operation/searchSynonyms).
   *
   * Required API Key ACLs:
   *   - settings
   * @param indexName Name of the index on which to perform the operation.
   * @param objectID Unique identifier of a synonym object.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getSynonym(indexName: String, objectID: String, requestOptions: RequestOptions? = null): SynonymHit {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `getSynonym`." }
    require(objectID.isNotBlank()) { "Parameter `objectID` is required when calling `getSynonym`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "indexes", "$indexName", "synonyms", "$objectID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Checks the status of a given task.  Indexing tasks are asynchronous. When you add, update, or delete records or indices, a task is created on a queue and completed depending on the load on the server.  The indexing tasks' responses include a task ID that you can use to check the status.
   *
   * Required API Key ACLs:
   *   - addObject
   * @param indexName Name of the index on which to perform the operation.
   * @param taskID Unique task identifier.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getTask(indexName: String, taskID: Long, requestOptions: RequestOptions? = null): GetTaskResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `getTask`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "indexes", "$indexName", "task", "$taskID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Get the IDs of the 10 users with the highest number of records per cluster.  Since it can take a few seconds to get the data from the different clusters, the response isn't real-time.
   *
   * Required API Key ACLs:
   *   - admin
   * @param requestOptions additional request configuration.
   */
  public suspend fun getTopUserIds(requestOptions: RequestOptions? = null): GetTopUserIdsResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "clusters", "mapping", "top"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Returns the user ID data stored in the mapping.  Since it can take a few seconds to get the data from the different clusters, the response isn't real-time.
   *
   * Required API Key ACLs:
   *   - admin
   * @param userID Unique identifier of the user who makes the search request.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getUserId(userID: String, requestOptions: RequestOptions? = null): UserId {
    require(userID.isNotBlank()) { "Parameter `userID` is required when calling `getUserId`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "clusters", "mapping", "$userID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * To determine when the time-consuming process of creating a large batch of users or migrating users from one cluster to another is complete, this operation retrieves the status of the process.
   *
   * Required API Key ACLs:
   *   - admin
   * @param getClusters Whether to include the cluster's pending mapping state in the response.
   * @param requestOptions additional request configuration.
   */
  public suspend fun hasPendingMappings(getClusters: Boolean? = null, requestOptions: RequestOptions? = null): HasPendingMappingsResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "clusters", "mapping", "pending"),
      query = buildMap {
        getClusters?.let { put("getClusters", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Lists all API keys associated with your Algolia application, including their permissions and restrictions.
   *
   * Required API Key ACLs:
   *   - admin
   * @param requestOptions additional request configuration.
   */
  public suspend fun listApiKeys(requestOptions: RequestOptions? = null): ListApiKeysResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "keys"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Lists the available clusters in a multi-cluster setup.
   *
   * Required API Key ACLs:
   *   - admin
   * @param requestOptions additional request configuration.
   */
  public suspend fun listClusters(requestOptions: RequestOptions? = null): ListClustersResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "clusters"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Lists all indices in the current Algolia application.  The request follows any index restrictions of the API key you use to make the request.
   *
   * Required API Key ACLs:
   *   - listIndexes
   * @param page Requested page of the API response. If `null`, the API response is not paginated.
   * @param hitsPerPage Number of hits per page. (default to 100)
   * @param requestOptions additional request configuration.
   */
  public suspend fun listIndices(page: Int? = null, hitsPerPage: Int? = null, requestOptions: RequestOptions? = null): ListIndicesResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "indexes"),
      query = buildMap {
        page?.let { put("page", it) }
        hitsPerPage?.let { put("hitsPerPage", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Lists the userIDs assigned to a multi-cluster application.  Since it can take a few seconds to get the data from the different clusters, the response isn't real-time.
   *
   * Required API Key ACLs:
   *   - admin
   * @param page Requested page of the API response. If `null`, the API response is not paginated.
   * @param hitsPerPage Number of hits per page. (default to 100)
   * @param requestOptions additional request configuration.
   */
  public suspend fun listUserIds(page: Int? = null, hitsPerPage: Int? = null, requestOptions: RequestOptions? = null): ListUserIdsResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "clusters", "mapping"),
      query = buildMap {
        page?.let { put("page", it) }
        hitsPerPage?.let { put("hitsPerPage", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Adds, updates, or deletes records in multiple indices with a single API request.  - Actions are applied in the order they are specified. - Actions are equivalent to the individual API requests of the same name.
   * @param batchParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun multipleBatch(batchParams: BatchParams, requestOptions: RequestOptions? = null): MultipleBatchResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "*", "batch"),
      body = batchParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Copies or moves (renames) an index within the same Algolia application.  - Existing destination indices are overwritten, except for their analytics data. - If the destination index doesn't exist yet, it'll be created.  **Copy**  - Copying a source index that doesn't exist creates a new index with 0 records and default settings. - The API keys of the source index are merged with the existing keys in the destination index. - You can't copy the `enableReRanking`, `mode`, and `replicas` settings. - You can't copy to a destination index that already has replicas. - Be aware of the [size limits](https://www.algolia.com/doc/guides/scaling/algolia-service-limits/#application-record-and-index-limits). - Related guide: [Copy indices](https://www.algolia.com/doc/guides/sending-and-managing-data/manage-indices-and-apps/manage-indices/how-to/copy-indices/)  **Move**  - Moving a source index that doesn't exist is ignored without returning an error. - When moving an index, the analytics data keep their original name and a new set of analytics data is started for the new name.   To access the original analytics in the dashboard, create an index with the original name. - If the destination index has replicas, moving will overwrite the existing index and copy the data to the replica indices. - Related guide: [Move indices](https://www.algolia.com/doc/guides/sending-and-managing-data/manage-indices-and-apps/manage-indices/how-to/move-indices/).
   *
   * Required API Key ACLs:
   *   - addObject
   * @param indexName Name of the index on which to perform the operation.
   * @param operationIndexParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun operationIndex(indexName: String, operationIndexParams: OperationIndexParams, requestOptions: RequestOptions? = null): UpdatedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `operationIndex`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "operation"),
      body = operationIndexParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Adds new attributes to a record, or update existing ones.  - If a record with the specified object ID doesn't exist,   a new record is added to the index **if** `createIfNotExists` is true. - If the index doesn't exist yet, this method creates a new index. - You can use any first-level attribute but not nested attributes.   If you specify a nested attribute, the engine treats it as a replacement for its first-level ancestor.  To update an attribute without pushing the entire record, you can use these built-in operations. These operations can be helpful if you don't have access to your initial data.  - Increment: increment a numeric attribute - Decrement: decrement a numeric attribute - Add: append a number or string element to an array attribute - Remove: remove all matching number or string elements from an array attribute made of numbers or strings - AddUnique: add a number or string element to an array attribute made of numbers or strings only if it's not already present - IncrementFrom: increment a numeric integer attribute only if the provided value matches the current value, and otherwise ignore the whole object update. For example, if you pass an IncrementFrom value of 2 for the version attribute, but the current value of the attribute is 1, the engine ignores the update. If the object doesn't exist, the engine only creates it if you pass an IncrementFrom value of 0. - IncrementSet: increment a numeric integer attribute only if the provided value is greater than the current value, and otherwise ignore the whole object update. For example, if you pass an IncrementSet value of 2 for the version attribute, and the current value of the attribute is 1, the engine updates the object. If the object doesn't exist yet, the engine only creates it if you pass an IncrementSet value that's greater than 0.  You can specify an operation by providing an object with the attribute to update as the key and its value being an object with the following properties:  - _operation: the operation to apply on the attribute - value: the right-hand side argument to the operation, for example, increment or decrement step, value to add or remove.
   *
   * Required API Key ACLs:
   *   - addObject
   * @param indexName Name of the index on which to perform the operation.
   * @param objectID Unique record identifier.
   * @param attributesToUpdate Attributes with their values.
   * @param createIfNotExists Whether to create a new record if it doesn't exist. (default to true)
   * @param requestOptions additional request configuration.
   */
  public suspend fun partialUpdateObject(indexName: String, objectID: String, attributesToUpdate: JsonObject, createIfNotExists: Boolean? = null, requestOptions: RequestOptions? = null): UpdatedAtWithObjectIdResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `partialUpdateObject`." }
    require(objectID.isNotBlank()) { "Parameter `objectID` is required when calling `partialUpdateObject`." }
    require(attributesToUpdate.isNotEmpty()) { "Parameter `attributesToUpdate` is required when calling `partialUpdateObject`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "$objectID", "partial"),
      query = buildMap {
        createIfNotExists?.let { put("createIfNotExists", it) }
      },
      body = attributesToUpdate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes a user ID and its associated data from the clusters.
   *
   * Required API Key ACLs:
   *   - admin
   * @param userID Unique identifier of the user who makes the search request.
   * @param requestOptions additional request configuration.
   */
  public suspend fun removeUserId(userID: String, requestOptions: RequestOptions? = null): RemoveUserIdResponse {
    require(userID.isNotBlank()) { "Parameter `userID` is required when calling `removeUserId`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "clusters", "mapping", "$userID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Replaces the list of allowed sources.
   *
   * Required API Key ACLs:
   *   - admin
   * @param source Allowed sources.
   * @param requestOptions additional request configuration.
   */
  public suspend fun replaceSources(source: List<Source>, requestOptions: RequestOptions? = null): ReplaceSourceResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("1", "security", "sources"),
      body = source,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Restores a deleted API key.  Restoring resets the `validity` attribute to `0`.  Algolia stores up to 1,000 API keys per application. If you create more, the oldest API keys are deleted and can't be restored.
   *
   * Required API Key ACLs:
   *   - admin
   * @param key API key.
   * @param requestOptions additional request configuration.
   */
  public suspend fun restoreApiKey(key: String, requestOptions: RequestOptions? = null): AddApiKeyResponse {
    require(key.isNotBlank()) { "Parameter `key` is required when calling `restoreApiKey`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "keys", "$key", "restore"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Adds a record to an index or replace it.  - If the record doesn't have an object ID, a new record with an auto-generated object ID is added to your index. - If a record with the specified object ID exists, the existing record is replaced. - If a record with the specified object ID doesn't exist, a new record is added to your index. - If you add a record to an index that doesn't exist yet, a new index is created.  To update _some_ attributes of a record, use the [`partial` operation](#tag/Records/operation/partialUpdateObject). To add, update, or replace multiple records, use the [`batch` operation](#tag/Records/operation/batch).
   *
   * Required API Key ACLs:
   *   - addObject
   * @param indexName Name of the index on which to perform the operation.
   * @param body The record, a schemaless object with attributes that are useful in the context of search and discovery.
   * @param requestOptions additional request configuration.
   */
  public suspend fun saveObject(indexName: String, body: JsonObject, requestOptions: RequestOptions? = null): SaveObjectResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `saveObject`." }
    require(body.isNotEmpty()) { "Parameter `body` is required when calling `saveObject`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName"),
      body = body,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * If a rule with the specified object ID doesn't exist, it's created. Otherwise, the existing rule is replaced.  To create or update more than one rule, use the [`batch` operation](#tag/Rules/operation/saveRules).
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param indexName Name of the index on which to perform the operation.
   * @param objectID Unique identifier of a rule object.
   * @param rule
   * @param forwardToReplicas Whether changes are applied to replica indices.
   * @param requestOptions additional request configuration.
   */
  public suspend fun saveRule(indexName: String, objectID: String, rule: Rule, forwardToReplicas: Boolean? = null, requestOptions: RequestOptions? = null): UpdatedRuleResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `saveRule`." }
    require(objectID.isNotBlank()) { "Parameter `objectID` is required when calling `saveRule`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("1", "indexes", "$indexName", "rules", "$objectID"),
      query = buildMap {
        forwardToReplicas?.let { put("forwardToReplicas", it) }
      },
      body = rule,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Create or update multiple rules.  If a rule with the specified object ID doesn't exist, Algolia creates a new one. Otherwise, existing rules are replaced.
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param indexName Name of the index on which to perform the operation.
   * @param rules
   * @param forwardToReplicas Whether changes are applied to replica indices.
   * @param clearExistingRules Whether existing rules should be deleted before adding this batch.
   * @param requestOptions additional request configuration.
   */
  public suspend fun saveRules(indexName: String, rules: List<Rule>, forwardToReplicas: Boolean? = null, clearExistingRules: Boolean? = null, requestOptions: RequestOptions? = null): UpdatedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `saveRules`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "rules", "batch"),
      query = buildMap {
        forwardToReplicas?.let { put("forwardToReplicas", it) }
        clearExistingRules?.let { put("clearExistingRules", it) }
      },
      body = rules,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * If a synonym with the specified object ID doesn't exist, Algolia adds a new one. Otherwise, the existing synonym is replaced. To add multiple synonyms in a single API request, use the [`batch` operation](#tag/Synonyms/operation/saveSynonyms).
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param indexName Name of the index on which to perform the operation.
   * @param objectID Unique identifier of a synonym object.
   * @param synonymHit
   * @param forwardToReplicas Whether changes are applied to replica indices.
   * @param requestOptions additional request configuration.
   */
  public suspend fun saveSynonym(indexName: String, objectID: String, synonymHit: SynonymHit, forwardToReplicas: Boolean? = null, requestOptions: RequestOptions? = null): SaveSynonymResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `saveSynonym`." }
    require(objectID.isNotBlank()) { "Parameter `objectID` is required when calling `saveSynonym`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("1", "indexes", "$indexName", "synonyms", "$objectID"),
      query = buildMap {
        forwardToReplicas?.let { put("forwardToReplicas", it) }
      },
      body = synonymHit,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * If a synonym with the `objectID` doesn't exist, Algolia adds a new one. Otherwise, existing synonyms are replaced.
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param indexName Name of the index on which to perform the operation.
   * @param synonymHit
   * @param forwardToReplicas Whether changes are applied to replica indices.
   * @param replaceExistingSynonyms Whether to replace all synonyms in the index with the ones sent with this request.
   * @param requestOptions additional request configuration.
   */
  public suspend fun saveSynonyms(indexName: String, synonymHit: List<SynonymHit>, forwardToReplicas: Boolean? = null, replaceExistingSynonyms: Boolean? = null, requestOptions: RequestOptions? = null): UpdatedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `saveSynonyms`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "synonyms", "batch"),
      query = buildMap {
        forwardToReplicas?.let { put("forwardToReplicas", it) }
        replaceExistingSynonyms?.let { put("replaceExistingSynonyms", it) }
      },
      body = synonymHit,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Sends multiple search request to one or more indices.  This can be useful in these cases:  - Different indices for different purposes, such as, one index for products, another one for marketing content. - Multiple searches to the same index—for example, with different filters.
   *
   * Required API Key ACLs:
   *   - search
   * @param searchMethodParams Muli-search request body. Results are returned in the same order as the requests.
   * @param requestOptions additional request configuration.
   */
  public suspend fun search(searchMethodParams: SearchMethodParams, requestOptions: RequestOptions? = null): SearchResponses {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "*", "queries"),
      isRead = true,
      body = searchMethodParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches for standard and custom dictionary entries.
   *
   * Required API Key ACLs:
   *   - settings
   * @param dictionaryName Dictionary type in which to search.
   * @param searchDictionaryEntriesParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchDictionaryEntries(dictionaryName: DictionaryType, searchDictionaryEntriesParams: SearchDictionaryEntriesParams, requestOptions: RequestOptions? = null): SearchDictionaryEntriesResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "dictionaries", "$dictionaryName", "search"),
      isRead = true,
      body = searchDictionaryEntriesParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches for values of a specified facet attribute.  - By default, facet values are sorted by decreasing count.   You can adjust this with the `sortFacetValueBy` parameter. - Searching for facet values doesn't work if you have **more than 65 searchable facets and searchable attributes combined**.
   *
   * Required API Key ACLs:
   *   - search
   * @param indexName Name of the index on which to perform the operation.
   * @param facetName Facet attribute in which to search for values.  This attribute must be included in the `attributesForFaceting` index setting with the `searchable()` modifier.
   * @param searchForFacetValuesRequest
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchForFacetValues(indexName: String, facetName: String, searchForFacetValuesRequest: SearchForFacetValuesRequest? = null, requestOptions: RequestOptions? = null): SearchForFacetValuesResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `searchForFacetValues`." }
    require(facetName.isNotBlank()) { "Parameter `facetName` is required when calling `searchForFacetValues`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "facets", "$facetName", "query"),
      isRead = true,
      body = searchForFacetValuesRequest,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches for rules in your index.
   *
   * Required API Key ACLs:
   *   - settings
   * @param indexName Name of the index on which to perform the operation.
   * @param searchRulesParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchRules(indexName: String, searchRulesParams: SearchRulesParams? = null, requestOptions: RequestOptions? = null): SearchRulesResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `searchRules`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "rules", "search"),
      isRead = true,
      body = searchRulesParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches a single index and return matching search results (_hits_).  This method lets you retrieve up to 1,000 hits. If you need more, use the [`browse` operation](#tag/Search/operation/browse) or increase the `paginatedLimitedTo` index setting.
   *
   * Required API Key ACLs:
   *   - search
   * @param indexName Name of the index on which to perform the operation.
   * @param searchParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchSingleIndex(indexName: String, searchParams: SearchParams? = null, requestOptions: RequestOptions? = null): SearchResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `searchSingleIndex`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "query"),
      isRead = true,
      body = searchParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches for synonyms in your index.
   *
   * Required API Key ACLs:
   *   - settings
   * @param indexName Name of the index on which to perform the operation.
   * @param searchSynonymsParams Body of the `searchSynonyms` operation.
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchSynonyms(indexName: String, searchSynonymsParams: SearchSynonymsParams? = null, requestOptions: RequestOptions? = null): SearchSynonymsResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `searchSynonyms`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "indexes", "$indexName", "synonyms", "search"),
      isRead = true,
      body = searchSynonymsParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Since it can take a few seconds to get the data from the different clusters, the response isn't real-time.  To ensure rapid updates, the user IDs index isn't built at the same time as the mapping. Instead, it's built every 12 hours, at the same time as the update of user ID usage. For example, if you add or move a user ID, the search will show an old value until the next time the mapping is rebuilt (every 12 hours).
   *
   * Required API Key ACLs:
   *   - admin
   * @param searchUserIdsParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchUserIds(searchUserIdsParams: SearchUserIdsParams, requestOptions: RequestOptions? = null): SearchUserIdsResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "clusters", "mapping", "search"),
      isRead = true,
      body = searchUserIdsParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Turns standard stop word dictionary entries on or off for a given language.
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param dictionarySettingsParams
   * @param requestOptions additional request configuration.
   */
  public suspend fun setDictionarySettings(dictionarySettingsParams: DictionarySettingsParams, requestOptions: RequestOptions? = null): UpdatedAtResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("1", "dictionaries", "*", "settings"),
      body = dictionarySettingsParams,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Update the specified index settings.  Index settings that you don't specify are left unchanged. Specify `null` to reset a setting to its default value.  For best performance, update the index settings before you add new records to your index.
   *
   * Required API Key ACLs:
   *   - editSettings
   * @param indexName Name of the index on which to perform the operation.
   * @param indexSettings
   * @param forwardToReplicas Whether changes are applied to replica indices.
   * @param requestOptions additional request configuration.
   */
  public suspend fun setSettings(indexName: String, indexSettings: IndexSettings, forwardToReplicas: Boolean? = null, requestOptions: RequestOptions? = null): UpdatedAtResponse {
    require(indexName.isNotBlank()) { "Parameter `indexName` is required when calling `setSettings`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("1", "indexes", "$indexName", "settings"),
      query = buildMap {
        forwardToReplicas?.let { put("forwardToReplicas", it) }
      },
      body = indexSettings,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Replaces the permissions of an existing API key.  Any unspecified attribute resets that attribute to its default value.
   *
   * Required API Key ACLs:
   *   - admin
   * @param key API key.
   * @param apiKey
   * @param requestOptions additional request configuration.
   */
  public suspend fun updateApiKey(key: String, apiKey: ApiKey, requestOptions: RequestOptions? = null): UpdateApiKeyResponse {
    require(key.isNotBlank()) { "Parameter `key` is required when calling `updateApiKey`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("1", "keys", "$key"),
      body = apiKey,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }
}
