/** Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT. */
package com.algolia.client.api

import com.algolia.client.configuration.*
import com.algolia.client.exception.*
import com.algolia.client.extensions.internal.*
import com.algolia.client.model.ingestion.*
import com.algolia.client.transport.*
import com.algolia.client.transport.internal.*
import kotlinx.serialization.json.*

public class IngestionClient(
  override val appId: String,
  override var apiKey: String,
  public val region: String,
  override val options: ClientOptions = ClientOptions(),
) : ApiClient {

  init {
    require(appId.isNotBlank()) { "`appId` is missing." }
    require(apiKey.isNotBlank()) { "`apiKey` is missing." }
  }

  override val requester: Requester = requesterOf(clientName = "Ingestion", appId = appId, apiKey = apiKey, options = options) {
    val allowedRegions = listOf("eu", "us")
    require(region in allowedRegions) { "`region` is required and must be one of the following: ${allowedRegions.joinToString()}" }
    val url = "data.$region.algolia.com"
    listOf(Host(url))
  }

  /**
   * Creates a new authentication resource.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param authenticationCreate
   * @param requestOptions additional request configuration.
   */
  public suspend fun createAuthentication(authenticationCreate: AuthenticationCreate, requestOptions: RequestOptions? = null): AuthenticationCreateResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "authentications"),
      body = authenticationCreate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Creates a new destination.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param destinationCreate
   * @param requestOptions additional request configuration.
   */
  public suspend fun createDestination(destinationCreate: DestinationCreate, requestOptions: RequestOptions? = null): DestinationCreateResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "destinations"),
      body = destinationCreate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Creates a new source.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param sourceCreate
   * @param requestOptions additional request configuration.
   */
  public suspend fun createSource(sourceCreate: SourceCreate, requestOptions: RequestOptions? = null): SourceCreateResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "sources"),
      body = sourceCreate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Creates a new task.
   * @param taskCreate Request body for creating a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun createTask(taskCreate: TaskCreate, requestOptions: RequestOptions? = null): TaskCreateResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("2", "tasks"),
      body = taskCreate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Creates a new task using the v1 endpoint, please use `createTask` instead.
   * @param taskCreate Request body for creating a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun createTaskV1(taskCreate: TaskCreateV1, requestOptions: RequestOptions? = null): TaskCreateResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "tasks"),
      body = taskCreate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Creates a new transformation.
   * @param transformationCreate Request body for creating a transformation.
   * @param requestOptions additional request configuration.
   */
  public suspend fun createTransformation(transformationCreate: TransformationCreate, requestOptions: RequestOptions? = null): TransformationCreateResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "transformations"),
      body = transformationCreate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   * @param path Path of the endpoint, anything after \"/1\" must be specified.
   * @param parameters Query parameters to apply to the current query.
   * @param requestOptions additional request configuration.
   */
  public suspend fun customDelete(path: String, parameters: Map<kotlin.String, Any>? = null, requestOptions: RequestOptions? = null): JsonObject {
    require(path.isNotBlank()) { "Parameter `path` is required when calling `customDelete`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = "/{path}".replace("{path}", path),
      query = buildMap {
        parameters?.let { putAll(it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   * @param path Path of the endpoint, anything after \"/1\" must be specified.
   * @param parameters Query parameters to apply to the current query.
   * @param requestOptions additional request configuration.
   */
  public suspend fun customGet(path: String, parameters: Map<kotlin.String, Any>? = null, requestOptions: RequestOptions? = null): JsonObject {
    require(path.isNotBlank()) { "Parameter `path` is required when calling `customGet`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = "/{path}".replace("{path}", path),
      query = buildMap {
        parameters?.let { putAll(it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   * @param path Path of the endpoint, anything after \"/1\" must be specified.
   * @param parameters Query parameters to apply to the current query.
   * @param body Parameters to send with the custom request.
   * @param requestOptions additional request configuration.
   */
  public suspend fun customPost(path: String, parameters: Map<kotlin.String, Any>? = null, body: JsonObject? = null, requestOptions: RequestOptions? = null): JsonObject {
    require(path.isNotBlank()) { "Parameter `path` is required when calling `customPost`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = "/{path}".replace("{path}", path),
      query = buildMap {
        parameters?.let { putAll(it) }
      },
      body = body,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   * @param path Path of the endpoint, anything after \"/1\" must be specified.
   * @param parameters Query parameters to apply to the current query.
   * @param body Parameters to send with the custom request.
   * @param requestOptions additional request configuration.
   */
  public suspend fun customPut(path: String, parameters: Map<kotlin.String, Any>? = null, body: JsonObject? = null, requestOptions: RequestOptions? = null): JsonObject {
    require(path.isNotBlank()) { "Parameter `path` is required when calling `customPut`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = "/{path}".replace("{path}", path),
      query = buildMap {
        parameters?.let { putAll(it) }
      },
      body = body,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes an authentication resource. You can't delete authentication resources that are used by a source or a destination.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param authenticationID Unique identifier of an authentication resource.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteAuthentication(authenticationID: String, requestOptions: RequestOptions? = null): DeleteResponse {
    require(authenticationID.isNotBlank()) { "Parameter `authenticationID` is required when calling `deleteAuthentication`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "authentications", "$authenticationID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes a destination by its ID. You can't delete destinations that are referenced in tasks.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param destinationID Unique identifier of a destination.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteDestination(destinationID: String, requestOptions: RequestOptions? = null): DeleteResponse {
    require(destinationID.isNotBlank()) { "Parameter `destinationID` is required when calling `deleteDestination`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "destinations", "$destinationID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes a source by its ID. You can't delete sources that are referenced in tasks.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param sourceID Unique identifier of a source.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteSource(sourceID: String, requestOptions: RequestOptions? = null): DeleteResponse {
    require(sourceID.isNotBlank()) { "Parameter `sourceID` is required when calling `deleteSource`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "sources", "$sourceID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes a task by its ID.
   * @param taskID Unique identifier of a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteTask(taskID: String, requestOptions: RequestOptions? = null): DeleteResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `deleteTask`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("2", "tasks", "$taskID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes a task by its ID using the v1 endpoint, please use `deleteTask` instead.
   * @param taskID Unique identifier of a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteTaskV1(taskID: String, requestOptions: RequestOptions? = null): DeleteResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `deleteTaskV1`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "tasks", "$taskID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Deletes a transformation by its ID.
   * @param transformationID Unique identifier of a transformation.
   * @param requestOptions additional request configuration.
   */
  public suspend fun deleteTransformation(transformationID: String, requestOptions: RequestOptions? = null): DeleteResponse {
    require(transformationID.isNotBlank()) { "Parameter `transformationID` is required when calling `deleteTransformation`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.DELETE,
      path = listOf("1", "transformations", "$transformationID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Disables a task.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskID Unique identifier of a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun disableTask(taskID: String, requestOptions: RequestOptions? = null): TaskUpdateResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `disableTask`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("2", "tasks", "$taskID", "disable"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Disables a task using the v1 endpoint, please use `disableTask` instead.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskID Unique identifier of a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun disableTaskV1(taskID: String, requestOptions: RequestOptions? = null): TaskUpdateResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `disableTaskV1`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("1", "tasks", "$taskID", "disable"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Enables a task.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskID Unique identifier of a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun enableTask(taskID: String, requestOptions: RequestOptions? = null): TaskUpdateResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `enableTask`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("2", "tasks", "$taskID", "enable"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Enables a task using the v1 endpoint, please use `enableTask` instead.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskID Unique identifier of a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun enableTaskV1(taskID: String, requestOptions: RequestOptions? = null): TaskUpdateResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `enableTaskV1`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("1", "tasks", "$taskID", "enable"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves an authentication resource by its ID.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param authenticationID Unique identifier of an authentication resource.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getAuthentication(authenticationID: String, requestOptions: RequestOptions? = null): Authentication {
    require(authenticationID.isNotBlank()) { "Parameter `authenticationID` is required when calling `getAuthentication`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "authentications", "$authenticationID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a destination by its ID.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param destinationID Unique identifier of a destination.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getDestination(destinationID: String, requestOptions: RequestOptions? = null): Destination {
    require(destinationID.isNotBlank()) { "Parameter `destinationID` is required when calling `getDestination`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "destinations", "$destinationID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a single task run event by its ID.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param runID Unique identifier of a task run.
   * @param eventID Unique identifier of an event.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getEvent(runID: String, eventID: String, requestOptions: RequestOptions? = null): Event {
    require(runID.isNotBlank()) { "Parameter `runID` is required when calling `getEvent`." }
    require(eventID.isNotBlank()) { "Parameter `eventID` is required when calling `getEvent`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "runs", "$runID", "events", "$eventID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieve a single task run by its ID.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param runID Unique identifier of a task run.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getRun(runID: String, requestOptions: RequestOptions? = null): Run {
    require(runID.isNotBlank()) { "Parameter `runID` is required when calling `getRun`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "runs", "$runID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieve a source by its ID.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param sourceID Unique identifier of a source.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getSource(sourceID: String, requestOptions: RequestOptions? = null): Source {
    require(sourceID.isNotBlank()) { "Parameter `sourceID` is required when calling `getSource`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "sources", "$sourceID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a task by its ID.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskID Unique identifier of a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getTask(taskID: String, requestOptions: RequestOptions? = null): Task {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `getTask`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("2", "tasks", "$taskID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a task by its ID using the v1 endpoint, please use `getTask` instead.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskID Unique identifier of a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getTaskV1(taskID: String, requestOptions: RequestOptions? = null): TaskV1 {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `getTaskV1`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "tasks", "$taskID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a transformation by its ID.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param transformationID Unique identifier of a transformation.
   * @param requestOptions additional request configuration.
   */
  public suspend fun getTransformation(transformationID: String, requestOptions: RequestOptions? = null): Transformation {
    require(transformationID.isNotBlank()) { "Parameter `transformationID` is required when calling `getTransformation`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "transformations", "$transformationID"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a list of all authentication resources.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param itemsPerPage Number of items per page. (default to 10)
   * @param page Page number of the paginated API response.
   * @param type Type of authentication resource to retrieve.
   * @param platform Ecommerce platform for which to retrieve authentications.
   * @param sort Property by which to sort the list of authentications. (default to createdAt)
   * @param order Sort order of the response, ascending or descending. (default to desc)
   * @param requestOptions additional request configuration.
   */
  public suspend fun listAuthentications(itemsPerPage: Int? = null, page: Int? = null, type: List<AuthenticationType>? = null, platform: List<PlatformWithNone>? = null, sort: AuthenticationSortKeys? = null, order: OrderKeys? = null, requestOptions: RequestOptions? = null): ListAuthenticationsResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "authentications"),
      query = buildMap {
        itemsPerPage?.let { put("itemsPerPage", it) }
        page?.let { put("page", it) }
        type?.let { put("type", it.joinToString(",")) }
        platform?.let { put("platform", it.joinToString(",")) }
        sort?.let { put("sort", it) }
        order?.let { put("order", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a list of destinations.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param itemsPerPage Number of items per page. (default to 10)
   * @param page Page number of the paginated API response.
   * @param type Destination type.
   * @param authenticationID Authentication ID used by destinations.
   * @param transformationID Get the list of destinations used by a transformation.
   * @param sort Property by which to sort the destinations. (default to createdAt)
   * @param order Sort order of the response, ascending or descending. (default to desc)
   * @param requestOptions additional request configuration.
   */
  public suspend fun listDestinations(itemsPerPage: Int? = null, page: Int? = null, type: List<DestinationType>? = null, authenticationID: List<String>? = null, transformationID: String? = null, sort: DestinationSortKeys? = null, order: OrderKeys? = null, requestOptions: RequestOptions? = null): ListDestinationsResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "destinations"),
      query = buildMap {
        itemsPerPage?.let { put("itemsPerPage", it) }
        page?.let { put("page", it) }
        type?.let { put("type", it.joinToString(",")) }
        authenticationID?.let { put("authenticationID", it.joinToString(",")) }
        transformationID?.let { put("transformationID", it) }
        sort?.let { put("sort", it) }
        order?.let { put("order", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a list of events for a task run, identified by it's ID.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param runID Unique identifier of a task run.
   * @param itemsPerPage Number of items per page. (default to 10)
   * @param page Page number of the paginated API response.
   * @param status Event status for filtering the list of task runs.
   * @param type Event type for filtering the list of task runs.
   * @param sort Property by which to sort the list of task run events.
   * @param order Sort order of the response, ascending or descending. (default to desc)
   * @param startDate Date and time in RFC 3339 format for the earliest events to retrieve. By default, the current time minus three hours is used.
   * @param endDate Date and time in RFC 3339 format for the latest events to retrieve. By default, the current time is used.
   * @param requestOptions additional request configuration.
   */
  public suspend fun listEvents(runID: String, itemsPerPage: Int? = null, page: Int? = null, status: List<EventStatus>? = null, type: List<EventType>? = null, sort: EventSortKeys? = null, order: OrderKeys? = null, startDate: String? = null, endDate: String? = null, requestOptions: RequestOptions? = null): ListEventsResponse {
    require(runID.isNotBlank()) { "Parameter `runID` is required when calling `listEvents`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "runs", "$runID", "events"),
      query = buildMap {
        itemsPerPage?.let { put("itemsPerPage", it) }
        page?.let { put("page", it) }
        status?.let { put("status", it.joinToString(",")) }
        type?.let { put("type", it.joinToString(",")) }
        sort?.let { put("sort", it) }
        order?.let { put("order", it) }
        startDate?.let { put("startDate", it) }
        endDate?.let { put("endDate", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieve a list of task runs.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param itemsPerPage Number of items per page. (default to 10)
   * @param page Page number of the paginated API response.
   * @param status Run status for filtering the list of task runs.
   * @param type Run type for filtering the list of task runs.
   * @param taskID Task ID for filtering the list of task runs.
   * @param sort Property by which to sort the list of task runs. (default to createdAt)
   * @param order Sort order of the response, ascending or descending. (default to desc)
   * @param startDate Date in RFC 3339 format for the earliest run to retrieve. By default, the current day minus seven days is used.
   * @param endDate Date in RFC 3339 format for the latest run to retrieve. By default, the current day is used.
   * @param requestOptions additional request configuration.
   */
  public suspend fun listRuns(itemsPerPage: Int? = null, page: Int? = null, status: List<RunStatus>? = null, type: List<RunType>? = null, taskID: String? = null, sort: RunSortKeys? = null, order: OrderKeys? = null, startDate: String? = null, endDate: String? = null, requestOptions: RequestOptions? = null): RunListResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "runs"),
      query = buildMap {
        itemsPerPage?.let { put("itemsPerPage", it) }
        page?.let { put("page", it) }
        status?.let { put("status", it.joinToString(",")) }
        type?.let { put("type", it.joinToString(",")) }
        taskID?.let { put("taskID", it) }
        sort?.let { put("sort", it) }
        order?.let { put("order", it) }
        startDate?.let { put("startDate", it) }
        endDate?.let { put("endDate", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a list of sources.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param itemsPerPage Number of items per page. (default to 10)
   * @param page Page number of the paginated API response.
   * @param type Source type. Some sources require authentication.
   * @param authenticationID Authentication IDs of the sources to retrieve. 'none' returns sources that doesn't have an authentication.
   * @param sort Property by which to sort the list of sources. (default to createdAt)
   * @param order Sort order of the response, ascending or descending. (default to desc)
   * @param requestOptions additional request configuration.
   */
  public suspend fun listSources(itemsPerPage: Int? = null, page: Int? = null, type: List<SourceType>? = null, authenticationID: List<String>? = null, sort: SourceSortKeys? = null, order: OrderKeys? = null, requestOptions: RequestOptions? = null): ListSourcesResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "sources"),
      query = buildMap {
        itemsPerPage?.let { put("itemsPerPage", it) }
        page?.let { put("page", it) }
        type?.let { put("type", it.joinToString(",")) }
        authenticationID?.let { put("authenticationID", it.joinToString(",")) }
        sort?.let { put("sort", it) }
        order?.let { put("order", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a list of tasks.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param itemsPerPage Number of items per page. (default to 10)
   * @param page Page number of the paginated API response.
   * @param action Actions for filtering the list of tasks.
   * @param enabled Whether to filter the list of tasks by the `enabled` status.
   * @param sourceID Source IDs for filtering the list of tasks.
   * @param destinationID Destination IDs for filtering the list of tasks.
   * @param triggerType Type of task trigger for filtering the list of tasks.
   * @param sort Property by which to sort the list of tasks. (default to createdAt)
   * @param order Sort order of the response, ascending or descending. (default to desc)
   * @param requestOptions additional request configuration.
   */
  public suspend fun listTasks(itemsPerPage: Int? = null, page: Int? = null, action: List<ActionType>? = null, enabled: Boolean? = null, sourceID: List<String>? = null, destinationID: List<String>? = null, triggerType: List<TriggerType>? = null, sort: TaskSortKeys? = null, order: OrderKeys? = null, requestOptions: RequestOptions? = null): ListTasksResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("2", "tasks"),
      query = buildMap {
        itemsPerPage?.let { put("itemsPerPage", it) }
        page?.let { put("page", it) }
        action?.let { put("action", it.joinToString(",")) }
        enabled?.let { put("enabled", it) }
        sourceID?.let { put("sourceID", it.joinToString(",")) }
        destinationID?.let { put("destinationID", it.joinToString(",")) }
        triggerType?.let { put("triggerType", it.joinToString(",")) }
        sort?.let { put("sort", it) }
        order?.let { put("order", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a list of tasks using the v1 endpoint, please use `getTasks` instead.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param itemsPerPage Number of items per page. (default to 10)
   * @param page Page number of the paginated API response.
   * @param action Actions for filtering the list of tasks.
   * @param enabled Whether to filter the list of tasks by the `enabled` status.
   * @param sourceID Source IDs for filtering the list of tasks.
   * @param destinationID Destination IDs for filtering the list of tasks.
   * @param triggerType Type of task trigger for filtering the list of tasks.
   * @param sort Property by which to sort the list of tasks. (default to createdAt)
   * @param order Sort order of the response, ascending or descending. (default to desc)
   * @param requestOptions additional request configuration.
   */
  public suspend fun listTasksV1(itemsPerPage: Int? = null, page: Int? = null, action: List<ActionType>? = null, enabled: Boolean? = null, sourceID: List<String>? = null, destinationID: List<String>? = null, triggerType: List<TriggerType>? = null, sort: TaskSortKeys? = null, order: OrderKeys? = null, requestOptions: RequestOptions? = null): ListTasksResponseV1 {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "tasks"),
      query = buildMap {
        itemsPerPage?.let { put("itemsPerPage", it) }
        page?.let { put("page", it) }
        action?.let { put("action", it.joinToString(",")) }
        enabled?.let { put("enabled", it) }
        sourceID?.let { put("sourceID", it.joinToString(",")) }
        destinationID?.let { put("destinationID", it.joinToString(",")) }
        triggerType?.let { put("triggerType", it.joinToString(",")) }
        sort?.let { put("sort", it) }
        order?.let { put("order", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Retrieves a list of transformations.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param itemsPerPage Number of items per page. (default to 10)
   * @param page Page number of the paginated API response.
   * @param sort Property by which to sort the list of transformations. (default to createdAt)
   * @param order Sort order of the response, ascending or descending. (default to desc)
   * @param requestOptions additional request configuration.
   */
  public suspend fun listTransformations(itemsPerPage: Int? = null, page: Int? = null, sort: TransformationSortKeys? = null, order: OrderKeys? = null, requestOptions: RequestOptions? = null): ListTransformationsResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.GET,
      path = listOf("1", "transformations"),
      query = buildMap {
        itemsPerPage?.let { put("itemsPerPage", it) }
        page?.let { put("page", it) }
        sort?.let { put("sort", it) }
        order?.let { put("order", it) }
      },
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Push a `batch` request payload through the Pipeline. You can check the status of task pushes with the observability endpoints.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskID Unique identifier of a task.
   * @param pushTaskPayload Request body of a Search API `batch` request that will be pushed in the Connectors pipeline.
   * @param requestOptions additional request configuration.
   */
  public suspend fun pushTask(taskID: String, pushTaskPayload: PushTaskPayload, requestOptions: RequestOptions? = null): RunResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `pushTask`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("2", "tasks", "$taskID", "push"),
      body = pushTaskPayload,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Runs all tasks linked to a source, only available for Shopify sources. It will create 1 run per task.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param sourceID Unique identifier of a source.
   * @param runSourcePayload
   * @param requestOptions additional request configuration.
   */
  public suspend fun runSource(sourceID: String, runSourcePayload: RunSourcePayload? = null, requestOptions: RequestOptions? = null): RunSourceResponse {
    require(sourceID.isNotBlank()) { "Parameter `sourceID` is required when calling `runSource`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "sources", "$sourceID", "run"),
      body = runSourcePayload,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Runs a task. You can check the status of task runs with the observability endpoints.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskID Unique identifier of a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun runTask(taskID: String, requestOptions: RequestOptions? = null): RunResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `runTask`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("2", "tasks", "$taskID", "run"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Runs a task using the v1 endpoint, please use `runTask` instead. You can check the status of task runs with the observability endpoints.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskID Unique identifier of a task.
   * @param requestOptions additional request configuration.
   */
  public suspend fun runTaskV1(taskID: String, requestOptions: RequestOptions? = null): RunResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `runTaskV1`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "tasks", "$taskID", "run"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches for authentication resources.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param authenticationSearch
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchAuthentications(authenticationSearch: AuthenticationSearch, requestOptions: RequestOptions? = null): List<Authentication> {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "authentications", "search"),
      body = authenticationSearch,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches for destinations.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param destinationSearch
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchDestinations(destinationSearch: DestinationSearch, requestOptions: RequestOptions? = null): List<Destination> {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "destinations", "search"),
      body = destinationSearch,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches for sources.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param sourceSearch
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchSources(sourceSearch: SourceSearch, requestOptions: RequestOptions? = null): List<Source> {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "sources", "search"),
      body = sourceSearch,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches for tasks.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskSearch
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchTasks(taskSearch: TaskSearch, requestOptions: RequestOptions? = null): List<Task> {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("2", "tasks", "search"),
      body = taskSearch,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches for tasks using the v1 endpoint, please use `searchTasks` instead.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param taskSearch
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchTasksV1(taskSearch: TaskSearch, requestOptions: RequestOptions? = null): List<TaskV1> {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "tasks", "search"),
      body = taskSearch,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Searches for transformations.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param transformationSearch
   * @param requestOptions additional request configuration.
   */
  public suspend fun searchTransformations(transformationSearch: TransformationSearch, requestOptions: RequestOptions? = null): List<Transformation> {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "transformations", "search"),
      body = transformationSearch,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Triggers a stream-listing request for a source. Triggering stream-listing requests only works with sources with `type: docker` and `imageType: singer`.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param sourceID Unique identifier of a source.
   * @param requestOptions additional request configuration.
   */
  public suspend fun triggerDockerSourceDiscover(sourceID: String, requestOptions: RequestOptions? = null): SourceWatchResponse {
    require(sourceID.isNotBlank()) { "Parameter `sourceID` is required when calling `triggerDockerSourceDiscover`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "sources", "$sourceID", "discover"),
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Try a transformation before creating it.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param transformationTry
   * @param requestOptions additional request configuration.
   */
  public suspend fun tryTransformation(transformationTry: TransformationTry, requestOptions: RequestOptions? = null): TransformationTryResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "transformations", "try"),
      body = transformationTry,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Try a transformation before updating it.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param transformationID Unique identifier of a transformation.
   * @param transformationTry
   * @param requestOptions additional request configuration.
   */
  public suspend fun tryTransformationBeforeUpdate(transformationID: String, transformationTry: TransformationTry, requestOptions: RequestOptions? = null): TransformationTryResponse {
    require(transformationID.isNotBlank()) { "Parameter `transformationID` is required when calling `tryTransformationBeforeUpdate`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "transformations", "$transformationID", "try"),
      body = transformationTry,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Updates an authentication resource.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param authenticationID Unique identifier of an authentication resource.
   * @param authenticationUpdate
   * @param requestOptions additional request configuration.
   */
  public suspend fun updateAuthentication(authenticationID: String, authenticationUpdate: AuthenticationUpdate, requestOptions: RequestOptions? = null): AuthenticationUpdateResponse {
    require(authenticationID.isNotBlank()) { "Parameter `authenticationID` is required when calling `updateAuthentication`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PATCH,
      path = listOf("1", "authentications", "$authenticationID"),
      body = authenticationUpdate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Updates the destination by its ID.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param destinationID Unique identifier of a destination.
   * @param destinationUpdate
   * @param requestOptions additional request configuration.
   */
  public suspend fun updateDestination(destinationID: String, destinationUpdate: DestinationUpdate, requestOptions: RequestOptions? = null): DestinationUpdateResponse {
    require(destinationID.isNotBlank()) { "Parameter `destinationID` is required when calling `updateDestination`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PATCH,
      path = listOf("1", "destinations", "$destinationID"),
      body = destinationUpdate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Updates a source by its ID.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param sourceID Unique identifier of a source.
   * @param sourceUpdate
   * @param requestOptions additional request configuration.
   */
  public suspend fun updateSource(sourceID: String, sourceUpdate: SourceUpdate, requestOptions: RequestOptions? = null): SourceUpdateResponse {
    require(sourceID.isNotBlank()) { "Parameter `sourceID` is required when calling `updateSource`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PATCH,
      path = listOf("1", "sources", "$sourceID"),
      body = sourceUpdate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Updates a task by its ID.
   * @param taskID Unique identifier of a task.
   * @param taskUpdate
   * @param requestOptions additional request configuration.
   */
  public suspend fun updateTask(taskID: String, taskUpdate: TaskUpdate, requestOptions: RequestOptions? = null): TaskUpdateResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `updateTask`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PATCH,
      path = listOf("2", "tasks", "$taskID"),
      body = taskUpdate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Updates a task by its ID using the v1 endpoint, please use `updateTask` instead.
   * @param taskID Unique identifier of a task.
   * @param taskUpdate
   * @param requestOptions additional request configuration.
   */
  public suspend fun updateTaskV1(taskID: String, taskUpdate: TaskUpdateV1, requestOptions: RequestOptions? = null): TaskUpdateResponse {
    require(taskID.isNotBlank()) { "Parameter `taskID` is required when calling `updateTaskV1`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PATCH,
      path = listOf("1", "tasks", "$taskID"),
      body = taskUpdate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Updates a transformation by its ID.
   * @param transformationID Unique identifier of a transformation.
   * @param transformationCreate
   * @param requestOptions additional request configuration.
   */
  public suspend fun updateTransformation(transformationID: String, transformationCreate: TransformationCreate, requestOptions: RequestOptions? = null): TransformationUpdateResponse {
    require(transformationID.isNotBlank()) { "Parameter `transformationID` is required when calling `updateTransformation`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.PUT,
      path = listOf("1", "transformations", "$transformationID"),
      body = transformationCreate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Validates a source payload to ensure it can be created and that the data source can be reached by Algolia.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param sourceCreate
   * @param requestOptions additional request configuration.
   */
  public suspend fun validateSource(sourceCreate: SourceCreate? = null, requestOptions: RequestOptions? = null): SourceWatchResponse {
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "sources", "validate"),
      body = sourceCreate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }

  /**
   * Validates an update of a source payload to ensure it can be created and that the data source can be reached by Algolia.
   *
   * Required API Key ACLs:
   *   - addObject
   *   - deleteIndex
   *   - editSettings
   * @param sourceID Unique identifier of a source.
   * @param sourceUpdate
   * @param requestOptions additional request configuration.
   */
  public suspend fun validateSourceBeforeUpdate(sourceID: String, sourceUpdate: SourceUpdate, requestOptions: RequestOptions? = null): SourceWatchResponse {
    require(sourceID.isNotBlank()) { "Parameter `sourceID` is required when calling `validateSourceBeforeUpdate`." }
    val requestConfig = RequestConfig(
      method = RequestMethod.POST,
      path = listOf("1", "sources", "$sourceID", "validate"),
      body = sourceUpdate,
    )
    return requester.execute(
      requestConfig = requestConfig,
      requestOptions = requestOptions,
    )
  }
}
