/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;

public class ObjectModelAdaptor<T>
implements ModelAdaptor<T> {
    protected static final Member INVALID_MEMBER;
    protected static final Map<Class<?>, Map<String, Member>> membersCache;

    @Override
    public synchronized Object getProperty(Interpreter interp, ST self, T model, Object property2, String propertyName) throws STNoSuchPropertyException {
        if (model == null) {
            throw new NullPointerException("o");
        }
        Class<?> c = model.getClass();
        if (property2 == null) {
            return this.throwNoSuchProperty(c, propertyName, null);
        }
        Member member = ObjectModelAdaptor.findMember(c, propertyName);
        if (member != null) {
            try {
                if (member instanceof Method) {
                    return ((Method)member).invoke(model, new Object[0]);
                }
                if (member instanceof Field) {
                    return ((Field)member).get(model);
                }
            }
            catch (Exception e) {
                this.throwNoSuchProperty(c, propertyName, e);
            }
        }
        return this.throwNoSuchProperty(c, propertyName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Member findMember(Class<?> clazz, String memberName) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (memberName == null) {
            throw new NullPointerException("memberName");
        }
        Map<Class<?>, Map<String, Member>> map2 = membersCache;
        synchronized (map2) {
            Member member;
            Map<String, Member> members2 = membersCache.get(clazz);
            if (members2 != null) {
                member = members2.get(memberName);
                if (member != null) {
                    return member != INVALID_MEMBER ? member : null;
                }
            } else {
                members2 = new HashMap<String, Member>();
                membersCache.put(clazz, members2);
            }
            String methodSuffix = Character.toUpperCase(memberName.charAt(0)) + memberName.substring(1, memberName.length());
            member = ObjectModelAdaptor.tryGetMethod(clazz, "get" + methodSuffix);
            if (member == null && (member = ObjectModelAdaptor.tryGetMethod(clazz, "is" + methodSuffix)) == null) {
                member = ObjectModelAdaptor.tryGetMethod(clazz, "has" + methodSuffix);
            }
            if (member == null) {
                member = ObjectModelAdaptor.tryGetField(clazz, memberName);
            }
            members2.put(memberName, member != null ? member : INVALID_MEMBER);
            return member;
        }
    }

    protected static Method tryGetMethod(Class<?> clazz, String methodName) {
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            if (method != null) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static Field tryGetField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            if (field != null) {
                field.setAccessible(true);
            }
            return field;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Object throwNoSuchProperty(Class<?> clazz, String propertyName, Exception cause) {
        throw new STNoSuchPropertyException(cause, null, clazz.getName() + "." + propertyName);
    }

    static {
        Field invalidMember;
        try {
            invalidMember = ObjectModelAdaptor.class.getDeclaredField("INVALID_MEMBER");
        }
        catch (NoSuchFieldException ex) {
            invalidMember = null;
        }
        catch (SecurityException ex) {
            invalidMember = null;
        }
        INVALID_MEMBER = invalidMember;
        membersCache = new HashMap();
    }
}

