/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.compiler;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.compiler.CodeGenerator;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.compiler.STException;
import org.stringtemplate.v4.compiler.STLexer;
import org.stringtemplate.v4.compiler.STParser;
import org.stringtemplate.v4.misc.ErrorType;

public class Compiler {
    public static final String SUBTEMPLATE_PREFIX = "_sub";
    public static final int TEMPLATE_INITIAL_CODE_SIZE = 15;
    public static final Map<String, Interpreter.Option> supportedOptions;
    public static final int NUM_OPTIONS;
    public static final Map<String, String> defaultOptionValues;
    public static Map<String, Short> funcs;
    public static AtomicInteger subtemplateCount;
    public STGroup group;

    public Compiler() {
        this(STGroup.defaultGroup);
    }

    public Compiler(STGroup group) {
        this.group = group;
    }

    public CompiledST compile(String template) {
        CompiledST code = this.compile(null, null, null, template, null);
        code.hasFormalArgs = false;
        return code;
    }

    public CompiledST compile(String name, String template) {
        CompiledST code = this.compile(null, name, null, template, null);
        code.hasFormalArgs = false;
        return code;
    }

    public CompiledST compile(String srcName, String name, List<FormalArgument> args2, String template, Token templateToken) {
        STParser.templateAndEOF_return r;
        ANTLRStringStream is = new ANTLRStringStream(template);
        is.name = srcName != null ? srcName : name;
        STLexer lexer = templateToken != null && templateToken.getType() == 6 ? new STLexer(this.group.errMgr, is, templateToken, this.group.delimiterStartChar, this.group.delimiterStopChar){

            @Override
            public Token nextToken() {
                Token t = super.nextToken();
                while (t.getType() == 32 || t.getType() == 31) {
                    t = super.nextToken();
                }
                return t;
            }
        } : new STLexer(this.group.errMgr, is, templateToken, this.group.delimiterStartChar, this.group.delimiterStopChar);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        STParser p = new STParser(tokens, this.group.errMgr, templateToken);
        try {
            r = p.templateAndEOF();
        }
        catch (RecognitionException re) {
            this.reportMessageAndThrowSTException(tokens, templateToken, p, re);
            return null;
        }
        if (p.getNumberOfSyntaxErrors() > 0 || r.getTree() == null) {
            CompiledST impl = new CompiledST();
            impl.defineFormalArgs(args2);
            return impl;
        }
        CommonTreeNodeStream nodes = new CommonTreeNodeStream(r.getTree());
        nodes.setTokenStream(tokens);
        CodeGenerator gen = new CodeGenerator(nodes, this.group.errMgr, name, template, templateToken);
        CompiledST impl = null;
        try {
            impl = gen.template(name, args2);
            impl.nativeGroup = this.group;
            impl.template = template;
            impl.ast = r.getTree();
            impl.ast.setUnknownTokenBoundaries();
            impl.tokens = tokens;
        }
        catch (RecognitionException re) {
            this.group.errMgr.internalError(null, "bad tree structure", re);
        }
        return impl;
    }

    public static CompiledST defineBlankRegion(CompiledST outermostImpl, Token nameToken) {
        String outermostTemplateName = outermostImpl.name;
        String mangled = STGroup.getMangledRegionName(outermostTemplateName, nameToken.getText());
        CompiledST blank = new CompiledST();
        blank.isRegion = true;
        blank.templateDefStartToken = nameToken;
        blank.regionDefType = ST.RegionType.IMPLICIT;
        blank.name = mangled;
        outermostImpl.addImplicitlyDefinedTemplate(blank);
        return blank;
    }

    public static String getNewSubtemplateName() {
        int count2 = subtemplateCount.incrementAndGet();
        return SUBTEMPLATE_PREFIX + count2;
    }

    protected void reportMessageAndThrowSTException(TokenStream tokens, Token templateToken, Parser parser, RecognitionException re) {
        if (re.token.getType() == -1) {
            String msg = "premature EOF";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (re instanceof NoViableAltException) {
            String msg = "'" + re.token.getText() + "' came as a complete surprise to me";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (tokens.index() == 0) {
            String msg = "this doesn't look like a template: \"" + tokens + "\"";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (tokens.LA(1) == 23) {
            String msg = "doesn't look like an expression";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else {
            String msg = parser.getErrorMessage(re, parser.getTokenNames());
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        }
        throw new STException();
    }

    static {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("anchor", (Object)Interpreter.Option.ANCHOR);
        map2.put("format", (Object)Interpreter.Option.FORMAT);
        map2.put("null", (Object)Interpreter.Option.NULL);
        map2.put("separator", (Object)Interpreter.Option.SEPARATOR);
        map2.put("wrap", (Object)Interpreter.Option.WRAP);
        supportedOptions = Collections.unmodifiableMap(map2);
        NUM_OPTIONS = supportedOptions.size();
        map2 = new HashMap();
        map2.put("anchor", "true");
        map2.put("wrap", "\n");
        defaultOptionValues = Collections.unmodifiableMap(map2);
        map2 = new HashMap();
        map2.put("first", (short)27);
        map2.put("last", (short)28);
        map2.put("rest", (short)29);
        map2.put("trunc", (short)30);
        map2.put("strip", (short)31);
        map2.put("trim", (short)32);
        map2.put("length", (short)33);
        map2.put("strlen", (short)34);
        map2.put("reverse", (short)35);
        funcs = Collections.unmodifiableMap(map2);
        subtemplateCount = new AtomicInteger(0);
    }
}

