/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.TreeBuilder;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J \u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\fH\u0014J(\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/markdown/parser/InlineBuilder;", "Lorg/intellij/markdown/parser/TreeBuilder;", "nodeBuilder", "Lorg/intellij/markdown/ast/ASTNodeBuilder;", "tokensCache", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "(Lorg/intellij/markdown/ast/ASTNodeBuilder;Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;)V", "currentTokenPosition", "", "addRawTokens", "", "childrenWithWhitespaces", "", "Lorg/intellij/markdown/ast/ASTNode;", "from", "dx", "exitOffset", "createASTNodeOnClosingEvent", "Lorg/intellij/markdown/parser/TreeBuilder$MyASTNodeWrapper;", "event", "Lorg/intellij/markdown/parser/TreeBuilder$MyEvent;", "currentNodeChildren", "", "isTopmostNode", "", "flushEverythingBeforeEvent", "flushOneTokenToTree", "markdown"})
@SourceDebugExtension(value={"SMAP\nInlineBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineBuilder.kt\norg/intellij/markdown/parser/InlineBuilder\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,77:1\n106#2,3:78\n110#2:82\n106#3:81\n*S KotlinDebug\n*F\n+ 1 InlineBuilder.kt\norg/intellij/markdown/parser/InlineBuilder\n*L\n24#1:78,3\n24#1:82\n24#1:81\n*E\n"})
public final class InlineBuilder
extends TreeBuilder {
    @NotNull
    private final TokensCache tokensCache;
    private int currentTokenPosition;

    public InlineBuilder(@NotNull ASTNodeBuilder nodeBuilder, @NotNull TokensCache tokensCache) {
        Intrinsics.checkNotNullParameter(nodeBuilder, "nodeBuilder");
        Intrinsics.checkNotNullParameter(tokensCache, "tokensCache");
        super(nodeBuilder);
        this.tokensCache = tokensCache;
        this.currentTokenPosition = -1;
    }

    @Override
    protected void flushEverythingBeforeEvent(@NotNull TreeBuilder.MyEvent event, @Nullable List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.currentTokenPosition == -1) {
            this.currentTokenPosition = event.getPosition();
        }
        while (this.currentTokenPosition < event.getPosition()) {
            this.flushOneTokenToTree(this.tokensCache, currentNodeChildren, this.currentTokenPosition);
            int n = this.currentTokenPosition;
            this.currentTokenPosition = n + 1;
        }
    }

    private final void flushOneTokenToTree(TokensCache tokensCache, List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren, int currentTokenPosition) {
        TokensCache.Iterator iterator2 = new TokensCache.Iterator(tokensCache, currentTokenPosition);
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = iterator2.getType() != null;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        ASTNodeBuilder aSTNodeBuilder = this.getNodeBuilder();
        IElementType iElementType = iterator2.getType();
        Intrinsics.checkNotNull(iElementType);
        List<ASTNode> nodes = aSTNodeBuilder.createLeafNodes(iElementType, iterator2.getStart(), iterator2.getEnd());
        for (ASTNode node : nodes) {
            List<TreeBuilder.MyASTNodeWrapper> list = currentNodeChildren;
            if (list == null) continue;
            list.add(new TreeBuilder.MyASTNodeWrapper(node, iterator2.getIndex(), iterator2.getIndex() + 1));
        }
    }

    @Override
    @NotNull
    protected TreeBuilder.MyASTNodeWrapper createASTNodeOnClosingEvent(@NotNull TreeBuilder.MyEvent event, @NotNull List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren, boolean isTopmostNode) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(currentNodeChildren, "currentNodeChildren");
        ASTNode newNode = null;
        IElementType type2 = event.getInfo().getType();
        int startTokenId = event.getInfo().getRange().getFirst();
        int endTokenId = event.getInfo().getRange().getLast();
        ArrayList<ASTNode> childrenWithWhitespaces = new ArrayList<ASTNode>(currentNodeChildren.size());
        if (isTopmostNode) {
            this.addRawTokens(this.tokensCache, (List<ASTNode>)childrenWithWhitespaces, startTokenId, -1, -1);
        }
        int n = currentNodeChildren.size();
        for (int index = 1; index < n; ++index) {
            TreeBuilder.MyASTNodeWrapper prev = currentNodeChildren.get(index - 1);
            TreeBuilder.MyASTNodeWrapper next = currentNodeChildren.get(index);
            childrenWithWhitespaces.add(prev.getAstNode());
            this.addRawTokens(this.tokensCache, (List<ASTNode>)childrenWithWhitespaces, prev.getEndTokenIndex() - 1, 1, new TokensCache.Iterator(this.tokensCache, next.getStartTokenIndex()).getStart());
        }
        if (!((Collection)currentNodeChildren).isEmpty()) {
            childrenWithWhitespaces.add(CollectionsKt.last(currentNodeChildren).getAstNode());
        }
        if (isTopmostNode) {
            this.addRawTokens(this.tokensCache, (List<ASTNode>)childrenWithWhitespaces, endTokenId - 1, 1, new TokensCache.Iterator(this.tokensCache, endTokenId).getStart());
        }
        newNode = this.getNodeBuilder().createCompositeNode(type2, (List<? extends ASTNode>)childrenWithWhitespaces);
        return new TreeBuilder.MyASTNodeWrapper(newNode, startTokenId, endTokenId);
    }

    private final void addRawTokens(TokensCache tokensCache, List<ASTNode> childrenWithWhitespaces, int from, int dx, int exitOffset) {
        TokensCache.Iterator iterator2 = new TokensCache.Iterator(tokensCache, from);
        int rawIdx = 0;
        while (iterator2.rawLookup(rawIdx + dx) != null && iterator2.rawStart(rawIdx + dx) != exitOffset) {
            rawIdx += dx;
        }
        while (rawIdx != 0) {
            IElementType rawType;
            Intrinsics.checkNotNull(iterator2.rawLookup(rawIdx));
            childrenWithWhitespaces.addAll((Collection<ASTNode>)this.getNodeBuilder().createLeafNodes(rawType, iterator2.rawStart(rawIdx), iterator2.rawStart(rawIdx + 1)));
            rawIdx -= dx;
        }
    }
}

