/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.lexer.Compat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rR\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rR\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "()V", "getAlignmentInfo", "", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "populateRow", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "cellName", "alignmentInfo", "rowNumber", "", "processNode", "Alignment", "Companion", "markdown"})
@SourceDebugExtension(value={"SMAP\nGFMGeneratingProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GFMGeneratingProviders.kt\norg/intellij/markdown/flavours/gfm/TablesGeneratingProvider\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n106#2,3:216\n110#2:220\n106#3:219\n766#4:221\n857#4,2:222\n1774#4,4:224\n1#5:228\n*S KotlinDebug\n*F\n+ 1 GFMGeneratingProviders.kt\norg/intellij/markdown/flavours/gfm/TablesGeneratingProvider\n*L\n124#1:216,3\n124#1:220\n124#1:219\n157#1:221\n157#1:222,2\n170#1:224,4\n*E\n"})
public final class TablesGeneratingProvider
implements GeneratingProvider {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Alignment DEFAULT_ALIGNMENT;
    @NotNull
    private static final Regex SPLIT_REGEX;

    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(node, "node");
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = Intrinsics.areEqual(node.getType(), GFMElementTypes.TABLE);
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        List<Alignment> alignmentInfo = this.getAlignmentInfo(text, node);
        int rowsPopulated = 0;
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, "table", new CharSequence[0], false, 8, null);
        for (ASTNode child : node.getChildren()) {
            if (Intrinsics.areEqual(child.getType(), GFMElementTypes.HEADER)) {
                visitor2.consumeHtml("<thead>");
                this.populateRow(visitor2, child, "th", alignmentInfo, -1);
                visitor2.consumeHtml("</thead>");
                continue;
            }
            if (!Intrinsics.areEqual(child.getType(), GFMElementTypes.ROW)) continue;
            if (rowsPopulated == 0) {
                visitor2.consumeHtml("<tbody>");
            }
            this.populateRow(visitor2, child, "td", alignmentInfo, ++rowsPopulated);
        }
        if (rowsPopulated > 0) {
            visitor2.consumeHtml("</tbody>");
        }
        visitor2.consumeTagClose("table");
    }

    /*
     * WARNING - void declaration
     */
    private final void populateRow(HtmlGenerator.HtmlGeneratingVisitor visitor2, ASTNode node, String cellName, List<? extends Alignment> alignmentInfo, int rowNumber) {
        int n;
        void $this$filterTo$iv$iv;
        String parityAttribute = rowNumber > 0 && rowNumber % 2 == 0 ? "class=\"intellij-row-even\"" : null;
        CharSequence[] charSequenceArray = new CharSequence[]{parityAttribute};
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, "tr", charSequenceArray, false, 8, null);
        Iterable iterable = node.getChildren();
        boolean $i$f$filter = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getType(), GFMTokenTypes.CELL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IndexedValue indexedValue : CollectionsKt.withIndex((List)destination$iv$iv)) {
            if (indexedValue.getIndex() >= alignmentInfo.size()) {
                throw new IllegalStateException("Too many cells in a row! Should check parser.");
            }
            Alignment alignment = alignmentInfo.get(indexedValue.getIndex());
            String alignmentAttribute = alignment.isDefault() ? null : "align=\"" + alignment.getHtmlName() + '\"';
            CharSequence[] charSequenceArray2 = new CharSequence[]{alignmentAttribute};
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, (ASTNode)indexedValue.getValue(), cellName, charSequenceArray2, false, 8, null);
            visitor2.visitNode((ASTNode)indexedValue.getValue());
            visitor2.consumeTagClose(cellName);
        }
        Iterable iterable3 = node.getChildren();
        boolean $i$f$count = false;
        if (iterable3 instanceof Collection && ((Collection)iterable3).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : iterable3) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getType(), GFMTokenTypes.CELL) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n2 = alignmentInfo.size();
        for (int i = v1485758; i < n2; ++i) {
            visitor2.consumeHtml("<td></td>");
        }
        visitor2.consumeTagClose("tr");
    }

    private final List<Alignment> getAlignmentInfo(String text, ASTNode node) {
        ASTNode aSTNode = ASTUtilKt.findChildOfType(node, GFMTokenTypes.TABLE_SEPARATOR);
        if (aSTNode == null) {
            throw new IllegalStateException("Could not find table separator");
        }
        ASTNode separatorRow = aSTNode;
        ArrayList<Alignment> result2 = new ArrayList<Alignment>();
        List cells2 = Regex.split$default(SPLIT_REGEX, ASTUtilKt.getTextInNode(separatorRow, text), 0, 2, null);
        int n = cells2.size();
        for (int i = 0; i < n; ++i) {
            String cell2 = (String)cells2.get(i);
            if (StringsKt.isBlank(cell2)) {
                boolean bl = 1 <= i ? i <= CollectionsKt.getLastIndex(cells2) - 1 : false;
                if (!bl) continue;
            }
            String trimmed = ((Object)StringsKt.trim((CharSequence)cell2)).toString();
            boolean starts = StringsKt.startsWith$default((CharSequence)trimmed, ':', false, 2, null);
            boolean ends = StringsKt.endsWith$default((CharSequence)trimmed, ':', false, 2, null);
            result2.add(starts && ends ? Alignment.CENTER : (starts ? Alignment.LEFT : (ends ? Alignment.RIGHT : DEFAULT_ALIGNMENT)));
        }
        return result2;
    }

    static {
        Alignment alignment;
        block2: {
            Companion = new Companion(null);
            Alignment[] alignmentArray = Alignment.values();
            int n = alignmentArray.length;
            for (int i = 0; i < n; ++i) {
                Alignment alignment2;
                Alignment it = alignment2 = alignmentArray[i];
                boolean bl = false;
                if (!it.isDefault()) continue;
                alignment = alignment2;
                break block2;
            }
            alignment = null;
        }
        if (alignment == null) {
            throw new IllegalStateException("Must be default alignment");
        }
        DEFAULT_ALIGNMENT = alignment;
        SPLIT_REGEX = new Regex("\\|");
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "", "htmlName", "", "isDefault", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "getHtmlName", "()Ljava/lang/String;", "()Z", "LEFT", "CENTER", "RIGHT", "markdown"})
    public static final class Alignment
    extends Enum<Alignment> {
        @NotNull
        private final String htmlName;
        private final boolean isDefault;
        public static final /* enum */ Alignment LEFT = new Alignment("left", true);
        public static final /* enum */ Alignment CENTER = new Alignment("center", false);
        public static final /* enum */ Alignment RIGHT = new Alignment("right", false);
        private static final /* synthetic */ Alignment[] $VALUES;

        private Alignment(String htmlName, boolean isDefault) {
            this.htmlName = htmlName;
            this.isDefault = isDefault;
        }

        @NotNull
        public final String getHtmlName() {
            return this.htmlName;
        }

        public final boolean isDefault() {
            return this.isDefault;
        }

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }

        public static Alignment valueOf(String value) {
            return Enum.valueOf(Alignment.class, value);
        }

        static {
            $VALUES = alignmentArray = new Alignment[]{Alignment.LEFT, Alignment.CENTER, Alignment.RIGHT};
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Companion;", "", "()V", "DEFAULT_ALIGNMENT", "Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "getDEFAULT_ALIGNMENT", "()Lorg/intellij/markdown/flavours/gfm/TablesGeneratingProvider$Alignment;", "SPLIT_REGEX", "Lkotlin/text/Regex;", "getSPLIT_REGEX", "()Lkotlin/text/Regex;", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Alignment getDEFAULT_ALIGNMENT() {
            return DEFAULT_ALIGNMENT;
        }

        @NotNull
        public final Regex getSPLIT_REGEX() {
            return SPLIT_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

