/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.core.sourcecode;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FileWalkDirection;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.archguard.scanner.core.sourcecode.ModuleIdentify;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fJ\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/archguard/scanner/core/sourcecode/ModuleIdentify;", "", "()V", "ROOT", "", "SEPARATOR", "SETTINGS_FILES", "", "[Ljava/lang/String;", "containsFiles", "", "sourcePath", "Ljava/io/File;", "hasModule", "file", "isGradle", "it", "isMaven", "isRootModule", "path", "isSubModule", "lookupModuleName", "base", "scanner_core"})
public final class ModuleIdentify {
    @NotNull
    public static final ModuleIdentify INSTANCE = new ModuleIdentify();
    @NotNull
    private static final String SEPARATOR = ":";
    @NotNull
    private static final String ROOT = "root";
    @NotNull
    private static final String[] SETTINGS_FILES;

    private ModuleIdentify() {
    }

    @NotNull
    public final String lookupModuleName(@NotNull File file2, @NotNull File base) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(base, "base");
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "file.path");
        String[] stringArray = new String[]{"src" + File.separator};
        List srcSplit = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
        File srcPath = new File((String)srcSplit.get(0));
        if (this.isRootModule(srcPath)) {
            return ROOT;
        }
        if (Intrinsics.areEqual(file2.getAbsolutePath(), base.getAbsolutePath())) {
            return ROOT;
        }
        if (this.isSubModule(srcPath)) {
            File relativePath = FilesKt.relativeTo(srcPath, base);
            String string2 = relativePath.getPath();
            Intrinsics.checkNotNullExpressionValue(string2, "relativePath.path");
            CharSequence charSequence = string2;
            String[] stringArray2 = new String[1];
            Intrinsics.checkNotNullExpressionValue(File.separator, "separator");
            List split2 = StringsKt.split$default(charSequence, stringArray2, false, 0, 6, null);
            return "root:" + CollectionsKt.joinToString$default(split2, SEPARATOR, null, null, 0, null, null, 62, null);
        }
        return SEPARATOR;
    }

    private final boolean isGradle(File it) {
        return Intrinsics.areEqual(it.getName(), "build.gradle") || Intrinsics.areEqual(it.getName(), "build.gradle.kts");
    }

    private final boolean isMaven(File it) {
        return Intrinsics.areEqual(it.getName(), "pom.xml");
    }

    public final boolean isRootModule(@NotNull File path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        if (!path2.exists()) {
            return false;
        }
        if (!path2.isDirectory()) {
            return false;
        }
        for (String buildFileName : SETTINGS_FILES) {
            if (!new File(path2, buildFileName).exists()) continue;
            return true;
        }
        return new File(path2, "pom.xml").exists();
    }

    public final boolean isSubModule(@NotNull File path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        if (!path2.exists()) {
            return false;
        }
        if (!path2.isDirectory()) {
            return false;
        }
        return this.containsFiles(new File(path2, "src"));
    }

    private final boolean hasModule(File file2) {
        return this.isGradle(file2) || this.isMaven(file2);
    }

    private final boolean containsFiles(File sourcePath) {
        boolean bl;
        boolean isIncludeSource;
        boolean bl2 = isIncludeSource = sourcePath.exists() && sourcePath.isDirectory();
        if (isIncludeSource) {
            File file2 = sourcePath.getParentFile();
            Intrinsics.checkNotNullExpressionValue(file2, "sourcePath.parentFile");
            bl = !((Collection)SequencesKt.toList(SequencesKt.filter(FilesKt.walk(file2, FileWalkDirection.TOP_DOWN).maxDepth(1), containsFiles.1.INSTANCE))).isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasModule(ModuleIdentify $this, File file2) {
        return $this.hasModule(file2);
    }

    static {
        String[] stringArray = new String[]{"settings.gradle", "settings.gradle.kts"};
        SETTINGS_FILES = stringArray;
    }
}

