/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.ignore;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.archguard.scanner.analyser.ignore.IgnoreMatcher;
import org.archguard.scanner.analyser.ignore.IndexScanPatterns;
import org.archguard.scanner.analyser.ignore.ScanStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/archguard/scanner/analyser/ignore/Gitignore;", "Lorg/archguard/scanner/analyser/ignore/IgnoreMatcher;", "path", "", "(Ljava/lang/String;)V", "acceptPatterns", "Lorg/archguard/scanner/analyser/ignore/ScanStrategy;", "ignorePatterns", "getPath", "()Ljava/lang/String;", "match", "", "isDir", "matchText", "relativePath", "Companion", "analyser_estimate"})
public final class Gitignore
implements IgnoreMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    @NotNull
    private final ScanStrategy ignorePatterns;
    @NotNull
    private final ScanStrategy acceptPatterns;

    public Gitignore(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        this.path = path2;
        this.ignorePatterns = new IndexScanPatterns(null, null, 3, null);
        this.acceptPatterns = new IndexScanPatterns(null, null, 3, null);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean match(@NotNull String path2, boolean isDir) {
        Intrinsics.checkNotNullParameter(path2, "path");
        String relativePath = FilesKt.relativeTo(new File(path2), new File(this.path)).getPath();
        Intrinsics.checkNotNullExpressionValue(relativePath, "relativePath");
        if (this.acceptPatterns.match(relativePath, isDir)) {
            return false;
        }
        return this.ignorePatterns.match(relativePath, isDir);
    }

    public final boolean matchText(@NotNull String relativePath, boolean isDir) {
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        if (this.acceptPatterns.match(relativePath, isDir)) {
            return false;
        }
        return this.ignorePatterns.match(relativePath, isDir);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b\"\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r\u00a8\u0006\u000e"}, d2={"Lorg/archguard/scanner/analyser/ignore/Gitignore$Companion;", "", "()V", "create", "Lorg/archguard/scanner/analyser/ignore/Gitignore;", "gitignore", "", "base", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/archguard/scanner/analyser/ignore/Gitignore;", "fromLines", "path", "lines", "", "analyser_estimate"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Gitignore create(@NotNull String gitignore, String ... base) {
            String string;
            Intrinsics.checkNotNullParameter(gitignore, "gitignore");
            Intrinsics.checkNotNullParameter(base, "base");
            if (!(base.length == 0)) {
                string = base[0];
            } else {
                String string2 = new File(gitignore).getParent();
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "{\n                File(g\u2026ore).parent\n            }");
            }
            String path2 = string;
            File ignoreFile = new File(gitignore);
            if (!ignoreFile.exists()) {
                System.out.println((Object)("Ignore file " + gitignore + " does not exist"));
                return null;
            }
            return this.fromLines(path2, FilesKt.readLines$default(ignoreFile, null, 1, null));
        }

        @NotNull
        public final Gitignore fromLines(@NotNull String path2, @NotNull List<String> lines) {
            Intrinsics.checkNotNullParameter(path2, "path");
            Intrinsics.checkNotNullParameter(lines, "lines");
            Gitignore g = new Gitignore(path2);
            for (String line : lines) {
                String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (((CharSequence)trimmed).length() == 0 || StringsKt.startsWith$default(trimmed, "#", false, 2, null)) continue;
                if (StringsKt.startsWith$default(trimmed, "!", false, 2, null)) {
                    ScanStrategy scanStrategy = g.acceptPatterns;
                    String string = trimmed.substring(1);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                    scanStrategy.add(string);
                    continue;
                }
                g.ignorePatterns.add(trimmed);
            }
            return g;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

