/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.frontend.path;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.archguard.scanner.analyser.frontend.path.OS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\t"}, d2={"ecmaImportConvert", "", "workspace", "filepath", "importPath", "getOS", "Lorg/archguard/scanner/analyser/frontend/path/OS;", "importConvert", "relativeRoot", "feat_apicalls"})
public final class EcmaImportPathKt {
    @Nullable
    public static final OS getOS() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(\"os.name\")");
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase()");
        String os = string2;
        return StringsKt.contains$default((CharSequence)os, "win", false, 2, null) ? OS.WINDOWS : (StringsKt.contains$default((CharSequence)os, "nix", false, 2, null) || StringsKt.contains$default((CharSequence)os, "nux", false, 2, null) || StringsKt.contains$default((CharSequence)os, "aix", false, 2, null) ? OS.LINUX : (StringsKt.contains$default((CharSequence)os, "mac", false, 2, null) ? OS.MAC : (StringsKt.contains$default((CharSequence)os, "sunos", false, 2, null) ? OS.SOLARIS : null)));
    }

    @NotNull
    public static final String ecmaImportConvert(@NotNull String workspace, @NotNull String filepath, @NotNull String importPath) {
        Intrinsics.checkNotNullParameter(workspace, "workspace");
        Intrinsics.checkNotNullParameter(filepath, "filepath");
        Intrinsics.checkNotNullParameter(importPath, "importPath");
        String pathname = filepath;
        boolean isResolvePath = StringsKt.startsWith$default(pathname, "@/", false, 2, null);
        if (isResolvePath) {
            String string = pathname;
            int n = 0;
            int n2 = 2;
            pathname = ((Object)StringsKt.removeRange((CharSequence)string, n, n2)).toString();
            pathname = "src/" + pathname;
            if (EcmaImportPathKt.getOS() == OS.WINDOWS) {
                pathname = StringsKt.replace$default(pathname, "\\", "/", false, 4, null);
            }
            return pathname;
        }
        String relativePath = pathname;
        try {
            String string = FilesKt.relativeTo(new File(pathname), new File(workspace)).toString();
            Intrinsics.checkNotNullExpressionValue(string, "File(pathname).relativeT\u2026le(workspace)).toString()");
            relativePath = string;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        if (!StringsKt.startsWith$default(relativePath, "./", false, 2, null) || !StringsKt.startsWith$default(relativePath, "../", false, 2, null)) {
            relativePath = "./" + relativePath;
        }
        return EcmaImportPathKt.importConvert(relativePath, importPath);
    }

    @NotNull
    public static final String importConvert(@NotNull String filepath, @NotNull String importPath) {
        Intrinsics.checkNotNullParameter(filepath, "filepath");
        Intrinsics.checkNotNullParameter(importPath, "importPath");
        boolean isResolvePath = StringsKt.startsWith$default(importPath, "@/", false, 2, null);
        if (isResolvePath) {
            String string = importPath;
            int n = 0;
            int n2 = 2;
            String pathname = ((Object)StringsKt.removeRange((CharSequence)string, n, n2)).toString();
            pathname = "src/" + pathname;
            if (EcmaImportPathKt.getOS() == OS.WINDOWS) {
                pathname = StringsKt.replace$default(pathname, "\\", "/", false, 4, null);
            }
            return pathname;
        }
        if (StringsKt.startsWith$default(importPath, "./", false, 2, null) || StringsKt.startsWith$default(importPath, "../", false, 2, null)) {
            File file2 = new File(filepath);
            if (((CharSequence)FilesKt.getExtension(file2)).length() > 0 && file2.getParentFile() != null) {
                File file3 = file2.getParentFile();
                Intrinsics.checkNotNullExpressionValue(file3, "file.parentFile");
                file2 = file3;
            }
            File resolve2 = FilesKt.resolve(file2, new File(importPath));
            String string = FilesKt.normalize(resolve2).toString();
            Intrinsics.checkNotNullExpressionValue(string, "resolve.normalize().toString()");
            return string;
        }
        String finalPath = importPath;
        if (EcmaImportPathKt.getOS() == OS.WINDOWS) {
            finalPath = StringsKt.replace$default(finalPath, "\\", "/", false, 4, null);
        }
        return finalPath;
    }

    @NotNull
    public static final String relativeRoot(@NotNull String filepath, @NotNull String importPath) {
        Intrinsics.checkNotNullParameter(filepath, "filepath");
        Intrinsics.checkNotNullParameter(importPath, "importPath");
        String pathname = importPath;
        boolean isResolvePath = StringsKt.startsWith$default(pathname, "@/", false, 2, null);
        if (isResolvePath) {
            String string = pathname;
            int n = 0;
            int n2 = 2;
            pathname = ((Object)StringsKt.removeRange((CharSequence)string, n, n2)).toString();
            pathname = "src/" + pathname;
            if (EcmaImportPathKt.getOS() == OS.WINDOWS) {
                pathname = StringsKt.replace$default(pathname, "\\", "/", false, 4, null);
            }
            return pathname;
        }
        String relativePath = pathname;
        try {
            String string = FilesKt.relativeTo(new File(pathname), new File(filepath)).toString();
            Intrinsics.checkNotNullExpressionValue(string, "File(pathname).relativeT\u2026ile(filepath)).toString()");
            relativePath = string;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        if (EcmaImportPathKt.getOS() == OS.WINDOWS) {
            relativePath = StringsKt.replace$default(relativePath, "\\", "/", false, 4, null);
        }
        return relativePath;
    }
}

