/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.database;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000e\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"IN_REGEX", "Lkotlin/text/Regex;", "JDBI_VALUE_BIND", "KOTLIN_VARIABLE", "KOTLIN_VARIABLE_WITH_QUOTE", "RAW_STRING_REGEX", "VARIABLE_IN_LINE", "fillPagination", "", "text", "handleRawString", "processIn", "removeBeginEndQuotes", "value", "removeEndWithMultipleSingleQuote", "removeJdbiValueBind", "removeKotlinVariable", "removeNextLine", "removePlusSymbol", "removePlusWithVariable", "removeVariableInLine", "sqlify", "feat_datamap"})
public final class SqlifyKt {
    @NotNull
    private static final Regex RAW_STRING_REGEX = new Regex("\"\"\"(((.*?)|(\r\n|\n))+)\"\"\"");
    @NotNull
    private static final Regex VARIABLE_IN_LINE = new Regex("(\"\\\\\"\\+[a-zA-Z0-9_]+\\+\"\\\\\")");
    @NotNull
    private static final Regex IN_REGEX = new Regex("in\\s+\\((\\s+)?<([a-zA-Z0-9_]+)>(\\s+)?\\)");
    @NotNull
    private static final Regex JDBI_VALUE_BIND = new Regex(":([a-zA-Z0-9_]+)");
    @NotNull
    private static final Regex KOTLIN_VARIABLE_WITH_QUOTE = new Regex("'\\$([a-zA-Z0-9_]+)'");
    @NotNull
    private static final Regex KOTLIN_VARIABLE = new Regex("\\$([a-zA-Z0-9_]+)");

    @NotNull
    public static final String sqlify(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        String text = SqlifyKt.handleRawString(value);
        text = SqlifyKt.removeBeginEndQuotes(text);
        text = SqlifyKt.removeVariableInLine(text);
        text = SqlifyKt.removeKotlinVariable(text);
        text = SqlifyKt.removeJdbiValueBind(text);
        text = SqlifyKt.removeEndWithMultipleSingleQuote(text);
        text = SqlifyKt.removeNextLine(text);
        text = SqlifyKt.removePlusWithVariable(text);
        text = SqlifyKt.removePlusSymbol(text);
        text = SqlifyKt.processIn(text);
        text = SqlifyKt.fillPagination(text);
        return text;
    }

    private static final String fillPagination(String text) {
        String sqlText = text;
        sqlText = StringsKt.replace$default(StringsKt.replace$default(sqlText, "offset ''", "offset 10", false, 4, null), "OFFSET ''", "OFFSET 10", false, 4, null);
        sqlText = StringsKt.replace$default(StringsKt.replace$default(sqlText, "limit ''", "limit 10", false, 4, null), "LIMIT ''", "LIMIT 10", false, 4, null);
        return sqlText;
    }

    private static final String handleRawString(String text) {
        MatchResult matchResult = Regex.find$default(RAW_STRING_REGEX, text, 0, 2, null);
        if (matchResult == null) {
            return text;
        }
        MatchResult rawString = matchResult;
        MatchGroup matchGroup = rawString.getGroups().get(1);
        Intrinsics.checkNotNull(matchGroup);
        return matchGroup.getValue();
    }

    private static final String removeVariableInLine(String text) {
        MatchResult matchResult = Regex.find$default(VARIABLE_IN_LINE, text, 0, 2, null);
        if (matchResult == null) {
            return text;
        }
        MatchResult find2 = matchResult;
        CharSequence charSequence = text;
        Regex regex = VARIABLE_IN_LINE;
        String string = "*";
        return regex.replace(charSequence, string);
    }

    private static final String processIn(String text) {
        MatchResult matchResult = Regex.find$default(IN_REGEX, text, 0, 2, null);
        if (matchResult == null) {
            return text;
        }
        MatchResult find2 = matchResult;
        CharSequence charSequence = text;
        Regex regex = IN_REGEX;
        StringBuilder stringBuilder = new StringBuilder().append("in (:");
        MatchGroup matchGroup = find2.getGroups().get(2);
        Intrinsics.checkNotNull(matchGroup);
        String string = stringBuilder.append(matchGroup.getValue()).append(')').toString();
        return regex.replace(charSequence, string);
    }

    private static final String removeJdbiValueBind(String text) {
        MatchResult matchResult = Regex.find$default(JDBI_VALUE_BIND, text, 0, 2, null);
        if (matchResult == null) {
            return text;
        }
        MatchResult find2 = matchResult;
        CharSequence charSequence = text;
        Regex regex = JDBI_VALUE_BIND;
        String string = "''";
        return regex.replace(charSequence, string);
    }

    private static final String removeKotlinVariable(String text) {
        String string;
        Regex regex;
        CharSequence charSequence;
        String str = text;
        if (Regex.find$default(KOTLIN_VARIABLE_WITH_QUOTE, str, 0, 2, null) != null) {
            charSequence = str;
            regex = KOTLIN_VARIABLE_WITH_QUOTE;
            string = "''";
            str = regex.replace(charSequence, string);
        }
        if (Regex.find$default(KOTLIN_VARIABLE, str, 0, 2, null) != null) {
            charSequence = str;
            regex = KOTLIN_VARIABLE;
            string = "''";
            str = regex.replace(charSequence, string);
        }
        return str;
    }

    private static final String removeNextLine(String text) {
        return StringsKt.replace$default(StringsKt.replace$default(text, "\r\n", "", false, 4, null), "\n", "", false, 4, null);
    }

    private static final String removePlusSymbol(String text) {
        return StringsKt.replace$default(StringsKt.replace$default(text, "\"+\"", "", false, 4, null), "+\"", "", false, 4, null);
    }

    private static final String removePlusWithVariable(String text) {
        CharSequence charSequence = text;
        Regex regex = new Regex("\"\\+([a-zA-Z0-9_]+)");
        String string = "";
        return regex.replace(charSequence, string);
    }

    private static final String removeEndWithMultipleSingleQuote(String text) {
        CharSequence charSequence = text;
        Regex regex = new Regex("''\\s+''");
        String string = "''";
        return regex.replace(charSequence, string);
    }

    private static final String removeBeginEndQuotes(String value) {
        if (StringsKt.startsWith$default(value, "\"", false, 2, null) && StringsKt.endsWith$default(value, "\"", false, 2, null)) {
            return StringsKt.removePrefix(StringsKt.removeSuffix(value, (CharSequence)"\""), (CharSequence)"\"");
        }
        return value;
    }
}

