/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.count;

import java.io.File;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.archguard.scanner.analyser.count.CodeState;
import org.archguard.scanner.analyser.count.CodeStateTransition;
import org.archguard.scanner.analyser.count.FileJob;
import org.archguard.scanner.analyser.count.LanguageFeature;
import org.archguard.scanner.analyser.count.LanguageService;
import org.archguard.scanner.analyser.count.LanguageWorkerKt;
import org.archguard.scanner.analyser.count.Quote;
import org.archguard.scanner.analyser.count.TokenType;
import org.archguard.scanner.analyser.count.Trie;
import org.archguard.scanner.analyser.count.TrieMatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002JK\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016JS\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJK\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nJ8\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020#J\u0010\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J8\u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0004H\u0002J,\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/archguard/scanner/analyser/count/LanguageWorker;", "", "()V", "isDuplicates", "", "languageService", "Lorg/archguard/scanner/analyser/count/LanguageService;", "blankState", "Lorg/archguard/scanner/analyser/count/CodeStateTransition;", "fileJob", "Lorg/archguard/scanner/analyser/count/FileJob;", "index", "", "endPoint", "currentState", "Lorg/archguard/scanner/analyser/count/CodeState;", "endComments", "", "", "endString", "langFeatures", "Lorg/archguard/scanner/analyser/count/LanguageFeature;", "(Lorg/archguard/scanner/analyser/count/FileJob;IILorg/archguard/scanner/analyser/count/CodeState;[[B[BLorg/archguard/scanner/analyser/count/LanguageFeature;)Lorg/archguard/scanner/analyser/count/CodeStateTransition;", "codeState", "originIndex", "digest", "Ljava/security/MessageDigest;", "(Lorg/archguard/scanner/analyser/count/FileJob;IILorg/archguard/scanner/analyser/count/CodeState;[B[[BLorg/archguard/scanner/analyser/count/LanguageFeature;Ljava/security/MessageDigest;)Lorg/archguard/scanner/analyser/count/CodeStateTransition;", "commentState", "countStats", "docStringState", "stringTrie", "Lorg/archguard/scanner/analyser/count/Trie;", "processFile", "file", "Ljava/io/File;", "resetState", "shouldProcess", "currentByte", "", "processBytesMask", "stringState", "ignoreEscape", "verifyIgnoreEscape", "Lkotlin/Pair;", "Companion", "analyser_estimate"})
@SourceDebugExtension(value={"SMAP\nLanguageWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageWorker.kt\norg/archguard/scanner/analyser/count/LanguageWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,618:1\n1855#2,2:619\n*S KotlinDebug\n*F\n+ 1 LanguageWorker.kt\norg/archguard/scanner/analyser/count/LanguageWorker\n*L\n510#1:619,2\n*E\n"})
public final class LanguageWorker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageService languageService = new LanguageService();
    private boolean isDuplicates;

    @Nullable
    public final FileJob processFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        FileJob fileJob = Companion.createFileJob(file2);
        return this.processFile(fileJob);
    }

    @Nullable
    public final FileJob processFile(@NotNull FileJob fileJob) {
        Intrinsics.checkNotNullParameter(fileJob, "fileJob");
        fileJob.setPossibleLanguages(this.languageService.detectLanguages(fileJob.getFilename()));
        if (fileJob.getPossibleLanguages().isEmpty()) {
            return null;
        }
        fileJob.setLanguage(this.languageService.determineLanguage(fileJob.getPossibleLanguages().get(0), fileJob.getPossibleLanguages(), fileJob.getContent()));
        return this.countStats(fileJob);
    }

    @Nullable
    public final FileJob countStats(@NotNull FileJob fileJob) {
        int first2;
        Intrinsics.checkNotNullParameter(fileJob, "fileJob");
        LanguageFeature languageFeature = this.languageService.getLanguageFeature(fileJob.getLanguage());
        if (languageFeature == null) {
            return null;
        }
        LanguageFeature langFeatures = languageFeature;
        if (langFeatures.getComplexity() == null) {
            langFeatures.setComplexity(new Trie(null, null, null, 7, null));
        }
        if (langFeatures.getSingleLineComments() == null) {
            langFeatures.setSingleLineComments(new Trie(null, null, null, 7, null));
        }
        if (langFeatures.getMultiLineComments() == null) {
            langFeatures.setMultiLineComments(new Trie(null, null, null, 7, null));
        }
        if (langFeatures.getStrings() == null) {
            langFeatures.setStrings(new Trie(null, null, null, 7, null));
        }
        if (langFeatures.getTokens() == null) {
            langFeatures.setTokens(new Trie(null, null, null, 7, null));
        }
        int endPoint = (int)(fileJob.getBytes() - 1L);
        CodeState currentState = CodeState.BLANK;
        Object endComments = new byte[][]{};
        byte[] endString = new byte[]{};
        boolean ignoreEscape = false;
        int index = first2 = Companion.checkBomSkip(fileJob);
        int fileLen = (int)fileJob.getBytes();
        while (true) {
            boolean bl = first2 <= index ? index < fileLen : false;
            if (!bl) break;
            if (!LanguageService.Companion.isWhitespace(fileJob.getContent()[index])) {
                switch (WhenMappings.$EnumSwitchMapping$0[currentState.ordinal()]) {
                    case 1: {
                        CodeStateTransition codeStateTransition = this.codeState(fileJob, index, endPoint, currentState, endString, (byte[][])endComments, langFeatures, fileJob.getHash());
                        index = codeStateTransition.getIndex();
                        currentState = codeStateTransition.getState();
                        endString = codeStateTransition.getEndString();
                        endComments = codeStateTransition.getEndComments();
                        ignoreEscape = codeStateTransition.getIgnoreEscape();
                        break;
                    }
                    case 2: {
                        CodeStateTransition stringStateTransition = this.stringState(fileJob, index, endPoint, endString, currentState, ignoreEscape);
                        index = stringStateTransition.getIndex();
                        currentState = stringStateTransition.getState();
                        break;
                    }
                    case 3: {
                        Trie trie = langFeatures.getStrings();
                        Intrinsics.checkNotNull(trie);
                        CodeStateTransition docStringStateTransition = this.docStringState(fileJob, index, endPoint, endString, currentState, trie);
                        index = docStringStateTransition.getIndex();
                        currentState = docStringStateTransition.getState();
                        break;
                    }
                    case 4: 
                    case 5: {
                        CodeStateTransition commentStateTransition = this.commentState(fileJob, index, endPoint, currentState, (byte[][])endComments, endString, langFeatures);
                        index = commentStateTransition.getIndex();
                        currentState = commentStateTransition.getState();
                        endString = commentStateTransition.getEndString();
                        endComments = commentStateTransition.getEndComments();
                        break;
                    }
                    case 6: 
                    case 7: {
                        CodeStateTransition blankStateTransition = this.blankState(fileJob, index, endPoint, currentState, (byte[][])endComments, endString, langFeatures);
                        index = blankStateTransition.getIndex();
                        currentState = blankStateTransition.getState();
                        endString = blankStateTransition.getEndString();
                        endComments = blankStateTransition.getEndComments();
                        ignoreEscape = blankStateTransition.getIgnoreEscape();
                    }
                }
            }
            if (index >= fileLen) {
                return null;
            }
            if (index < 10000 && fileJob.getBinary()) {
                return null;
            }
            if (fileJob.getContent()[index] == 10 || index >= endPoint) {
                long l = fileJob.getLines();
                fileJob.setLines(l + 1L);
                switch (WhenMappings.$EnumSwitchMapping$0[currentState.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 9: {
                        long l2 = fileJob.getCode();
                        fileJob.setCode(l2 + 1L);
                        currentState = this.resetState(currentState);
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 8: {
                        long l3 = fileJob.getComment();
                        fileJob.setComment(l3 + 1L);
                        currentState = this.resetState(currentState);
                        break;
                    }
                    case 6: {
                        long l4 = fileJob.getBlank();
                        fileJob.setBlank(l4 + 1L);
                        break;
                    }
                    case 3: {
                        long l5 = fileJob.getComment();
                        fileJob.setComment(l5 + 1L);
                    }
                }
            }
            ++index;
        }
        if (this.isDuplicates) {
            fileJob.getHash().update(new byte[0]);
        }
        return fileJob;
    }

    private final CodeState resetState(CodeState currentState) {
        CodeState codeState;
        switch (WhenMappings.$EnumSwitchMapping$0[currentState.ordinal()]) {
            case 4: 
            case 5: {
                codeState = CodeState.MULTICOMMENT;
                break;
            }
            case 2: {
                codeState = CodeState.STRING;
                break;
            }
            default: {
                codeState = CodeState.BLANK;
            }
        }
        return codeState;
    }

    private final CodeStateTransition codeState(FileJob fileJob, int originIndex, int endPoint, CodeState currentState, byte[] endString, byte[][] endComments, LanguageFeature langFeatures, MessageDigest digest) {
        int point = endPoint;
        if (point > fileJob.getContent().length) {
            --point;
        }
        int id = originIndex;
        while (true) {
            boolean bl = originIndex <= id ? id < point : false;
            if (!bl) break;
            byte curByte = fileJob.getContent()[id];
            if (curByte == 10) {
                return new CodeStateTransition(id, currentState, endString, endComments, false);
            }
            if (LanguageService.Companion.isBinary(id, curByte)) {
                fileJob.setBinary(true);
                return new CodeStateTransition(id, currentState, endString, endComments, false);
            }
            Byte by = langFeatures.getProcessMask();
            Intrinsics.checkNotNull(by);
            if (this.shouldProcess(curByte, by)) {
                Object object;
                if (this.isDuplicates) {
                    object = new byte[]{fileJob.getContent()[id]};
                    byte[] digestible = object;
                    digest.update(digestible);
                }
                byte[] rangeContent = ArraysKt.sliceArray(fileJob.getContent(), RangesKt.until(id, fileJob.getContent().length));
                Trie trie = langFeatures.getTokens();
                TrieMatch trieMatch = trie != null ? trie.match(rangeContent) : null;
                Intrinsics.checkNotNull(trieMatch);
                object = trieMatch;
                TokenType tokenType = object.component1();
                int offsetJump = object.component2();
                byte[] matchEndString = object.component3();
                TokenType tokenType2 = tokenType;
                switch (tokenType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[tokenType2.ordinal()]) {
                    case 1: {
                        Pair<Integer, Boolean> pair2 = this.verifyIgnoreEscape(langFeatures, fileJob, id);
                        int i = ((Number)pair2.component1()).intValue();
                        boolean ignoreEscape = pair2.component2();
                        CodeState state = currentState;
                        if (fileJob.getContent()[i - 1] != 92) {
                            state = CodeState.STRING;
                        }
                        return new CodeStateTransition(i, state, matchEndString, endComments, ignoreEscape);
                    }
                    case 2: {
                        return new CodeStateTransition(id, CodeState.COMMENT_CODE, matchEndString, endComments, false);
                    }
                    case 3: {
                        if (!Intrinsics.areEqual(langFeatures.getNested(), true) && !(((Object[])endComments).length == 0)) break;
                        return new CodeStateTransition(id += offsetJump - 1, CodeState.MULTICOMMENT_CODE, matchEndString, ArraysKt.plus((Object[])endComments, matchEndString), false);
                    }
                    case 4: {
                        if (id != 0 && !LanguageService.Companion.isWhitespace(fileJob.getContent()[id - 1])) break;
                        long l = fileJob.getComplexity();
                        fileJob.setComplexity(l + 1L);
                    }
                }
            }
            ++id;
        }
        return new CodeStateTransition(id, currentState, endString, endComments, false);
    }

    private final boolean shouldProcess(byte currentByte, byte processBytesMask) {
        return (byte)(currentByte & processBytesMask) == currentByte;
    }

    private final CodeStateTransition commentState(FileJob fileJob, int originIndex, int endPoint, CodeState currentState, byte[][] endComments, byte[] endString, LanguageFeature langFeatures) {
        CodeState state = currentState;
        int id = originIndex;
        while (true) {
            boolean bl = originIndex <= id ? id < endPoint : false;
            if (!bl) break;
            byte curByte = fileJob.getContent()[id];
            if (curByte == 10) {
                return new CodeStateTransition(id, state, endString, endComments, false, 16, null);
            }
            if (Companion.checkForMatchSingle(curByte, id, endPoint, endComments[((Object[])endComments).length - 1], fileJob)) {
                int offsetJump = endComments[((Object[])endComments).length - 1].length;
                byte[][] newEndComments = (byte[][])ArraysKt.sliceArray((Object[])endComments, RangesKt.until(0, ((Object[])endComments).length - 1));
                if (((Object[])newEndComments).length == 0) {
                    state = state == CodeState.MULTICOMMENT_CODE ? CodeState.CODE : CodeState.MULTICOMMENT_BLANK;
                }
                return new CodeStateTransition(id += offsetJump - 1, state, endString, newEndComments, false, 16, null);
            }
            if (Intrinsics.areEqual(langFeatures.getNested(), true) || ((Object[])endComments).length == 0) {
                TrieMatch trieMatch;
                byte[] rangeContent = ArraysKt.sliceArray(fileJob.getContent(), RangesKt.until(id, fileJob.getContent().length));
                Trie trie = langFeatures.getMultiLineComments();
                Intrinsics.checkNotNull(trie != null ? trie.match(rangeContent) : null);
                trieMatch = trieMatch;
                TokenType ok = trieMatch.component1();
                int offsetJump = trieMatch.component2();
                byte[] matchEndString = trieMatch.component3();
                if (ok != null && ok != TokenType.TString) {
                    return new CodeStateTransition(id += offsetJump - 1, state, matchEndString, ArraysKt.plus((Object[])endComments, matchEndString), false, 16, null);
                }
            }
            ++id;
        }
        return new CodeStateTransition(id, state, endString, endComments, false, 16, null);
    }

    private final CodeStateTransition docStringState(FileJob fileJob, int originIndex, int endPoint, byte[] endString, CodeState currentState, Trie stringTrie) {
        int id = originIndex;
        int i = originIndex;
        while (i < endPoint) {
            id = i++;
            if (fileJob.getContent()[id] == 10) {
                return new CodeStateTransition(id, currentState, null, null, false, 28, null);
            }
            if (fileJob.getContent()[id - 1] == 92) continue;
            byte[] rangeContent = ArraysKt.sliceArray(fileJob.getContent(), RangesKt.until(id, endPoint));
            for (int j = id + endString.length; j < endPoint; ++j) {
                if (fileJob.getContent()[j] == 10) {
                    return new CodeStateTransition(id, CodeState.COMMENT, null, null, false, 28, null);
                }
                if (LanguageService.Companion.isWhitespace(fileJob.getContent()[j])) continue;
                return new CodeStateTransition(id, CodeState.CODE, null, null, false, 28, null);
            }
            return new CodeStateTransition(id, CodeState.CODE, null, null, false, 28, null);
        }
        return new CodeStateTransition(id, currentState, null, null, false, 28, null);
    }

    private final CodeStateTransition stringState(FileJob fileJob, int index, int endPoint, byte[] endString, CodeState currentState, boolean ignoreEscape) {
        int id = index;
        int i = index;
        if (i <= endPoint) {
            do {
                id = ++i;
                if (fileJob.getContent()[id] == 10) {
                    return new CodeStateTransition(id, currentState, null, null, false, 28, null);
                }
                if (!ignoreEscape && fileJob.getContent()[id - 1] == 92 || !Companion.checkForMatchSingle(fileJob.getContent()[i], id, endPoint, endString, fileJob)) continue;
                return new CodeStateTransition(id, CodeState.CODE, null, null, false, 28, null);
            } while (i != endPoint);
        }
        return new CodeStateTransition(id, currentState, null, null, false, 28, null);
    }

    private final CodeStateTransition blankState(FileJob fileJob, int index, int endPoint, CodeState currentState, byte[][] endComments, byte[] endString, LanguageFeature langFeatures) {
        CodeState state = currentState;
        byte[] rangeContent = ArraysKt.sliceArray(fileJob.getContent(), RangesKt.until(index, fileJob.getContent().length));
        Trie trie = langFeatures.getTokens();
        TrieMatch trieMatch = trie != null ? trie.match(rangeContent) : null;
        Intrinsics.checkNotNull(trieMatch);
        TrieMatch trieMatch2 = trieMatch;
        TokenType tokenType = trieMatch2.component1();
        int offsetJump = trieMatch2.component2();
        byte[] matchEndString = trieMatch2.component3();
        TokenType tokenType2 = tokenType;
        switch (tokenType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[tokenType2.ordinal()]) {
            case 3: {
                if (!Intrinsics.areEqual(langFeatures.getNested(), true) && !(((Object[])endComments).length == 0)) break;
                int newIndex = index + offsetJump - 1;
                return new CodeStateTransition(newIndex, CodeState.MULTICOMMENT, matchEndString, ArraysKt.plus((Object[])endComments, matchEndString), false);
            }
            case 2: {
                return new CodeStateTransition(index, CodeState.COMMENT, matchEndString, endComments, false);
            }
            case 1: {
                Pair<Integer, Boolean> pair2 = this.verifyIgnoreEscape(langFeatures, fileJob, index);
                int id = ((Number)pair2.component1()).intValue();
                boolean ignoreEscape = pair2.component2();
                List<Quote> list = langFeatures.getQuotes();
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Quote v = (Quote)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(v.getEnd(), matchEndString.toString()) || !v.getDocString()) continue;
                        return new CodeStateTransition(id, CodeState.DOC_STRING, matchEndString, endComments, ignoreEscape);
                    }
                }
                return new CodeStateTransition(id, CodeState.STRING, matchEndString, endComments, ignoreEscape);
            }
            case 4: {
                state = CodeState.CODE;
                if (index != 0 && !LanguageService.Companion.isWhitespace(fileJob.getContent()[index - 1])) break;
                long l = fileJob.getComplexity();
                fileJob.setComplexity(l + 1L);
                break;
            }
            default: {
                state = CodeState.CODE;
            }
        }
        return new CodeStateTransition(index, state, endString, endComments, false);
    }

    private final Pair<Integer, Boolean> verifyIgnoreEscape(LanguageFeature langFeatures, FileJob fileJob, int index) {
        boolean ignoreEscape = false;
        List<Quote> list = langFeatures.getQuotes();
        Intrinsics.checkNotNull(list);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!langFeatures.getQuotes().get(i).getDocString() && !langFeatures.getQuotes().get(i).getIgnoreEscape()) continue;
            boolean isMatch = true;
            int n2 = langFeatures.getQuotes().get(i).getStart().length();
            for (int j = 0; j < n2; ++j) {
                if (fileJob.getContent().length > index + j && fileJob.getContent()[index + j] == (byte)langFeatures.getQuotes().get(i).getStart().charAt(j)) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            ignoreEscape = true;
            int cfr_ignored_0 = index + langFeatures.getQuotes().get(i).getStart().length();
        }
        return new Pair<Integer, Boolean>(index, ignoreEscape);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/archguard/scanner/analyser/count/LanguageWorker$Companion;", "", "()V", "checkBomSkip", "", "fileJob", "Lorg/archguard/scanner/analyser/count/FileJob;", "checkForMatchSingle", "", "currentByte", "", "index", "endPoint", "matches", "", "createFileJob", "file", "Ljava/io/File;", "analyser_estimate"})
    public static final class Companion {
        private Companion() {
        }

        public final int checkBomSkip(@NotNull FileJob fileJob) {
            Intrinsics.checkNotNullParameter(fileJob, "fileJob");
            Object object = fileJob.getContent();
            byte[] byArray = new byte[]{-17, -69, -65};
            if (Arrays.equals(object, byArray)) {
                return 3;
            }
            object = LanguageWorkerKt.getByteOrderMarks();
            int n = ((Object[])object).length;
            for (int i = 0; i < n; ++i) {
                byte v = object[i];
                if (!Arrays.equals(fileJob.getContent(), (byte[])v)) continue;
                System.out.println((Object)("BOM found for file " + fileJob.getFilename() + " indicating it is not ASCII/UTF-8 and may be counted incorrectly or ignored as a binary file"));
            }
            return 0;
        }

        public final boolean checkForMatchSingle(byte currentByte, int index, int endPoint, @NotNull byte[] matches, @NotNull FileJob fileJob) {
            Intrinsics.checkNotNullParameter(matches, "matches");
            Intrinsics.checkNotNullParameter(fileJob, "fileJob");
            boolean potentialMatch = true;
            if (currentByte == matches[0]) {
                int n = matches.length;
                for (int j = 0; j < n; ++j) {
                    if (index + j < endPoint && matches[j] == fileJob.getContent()[index + j]) continue;
                    potentialMatch = false;
                    break;
                }
                if (potentialMatch) {
                    return true;
                }
            }
            return false;
        }

        @NotNull
        public final FileJob createFileJob(@NotNull File file2) {
            Intrinsics.checkNotNullParameter(file2, "file");
            byte[] fileContent = FilesKt.readBytes(file2);
            String string = file2.getName();
            long l = file2.length();
            String string2 = FilesKt.getExtension(file2);
            String string3 = file2.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue(string, "name");
            Intrinsics.checkNotNullExpressionValue(string3, "absolutePath");
            return new FileJob(null, null, string, string2, string3, null, fileContent, l, 0L, 0L, 0L, 0L, 0L, 0.0, null, false, false, false, 0, 524067, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CodeState.values().length];
            try {
                nArray[CodeState.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeState.STRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeState.DOC_STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeState.MULTICOMMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeState.MULTICOMMENT_CODE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeState.BLANK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeState.MULTICOMMENT_BLANK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeState.COMMENT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeState.COMMENT_CODE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TokenType.values().length];
            try {
                nArray[TokenType.TString.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.TSlcomment.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.TMlcomment.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.TComplexity.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

