/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.backend;

import chapi.domain.core.AnnotationKeyValue;
import chapi.domain.core.CodeAnnotation;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodeImport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.archguard.scanner.analyser.base.ApiAnalyser;
import org.archguard.scanner.core.sourcecode.ContainerDemand;
import org.archguard.scanner.core.sourcecode.ContainerService;
import org.archguard.scanner.core.sourcecode.ContainerSupply;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0004H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\t\u00a8\u0006\u001c"}, d2={"Lorg/archguard/scanner/analyser/backend/JavaApiAnalyser;", "Lorg/archguard/scanner/analyser/base/ApiAnalyser;", "()V", "demands", "", "Lorg/archguard/scanner/core/sourcecode/ContainerDemand;", "getDemands", "()Ljava/util/List;", "setDemands", "(Ljava/util/List;)V", "resources", "Lorg/archguard/scanner/core/sourcecode/ContainerSupply;", "getResources", "setResources", "analysisByNode", "", "node", "Lchapi/domain/core/CodeDataStruct;", "workspace", "", "createDemand", "it", "Lchapi/domain/core/CodeFunction;", "createResource", "func", "baseUrl", "toContainerServices", "Lorg/archguard/scanner/core/sourcecode/ContainerService;", "feat_apicalls"})
@SourceDebugExtension(value={"SMAP\nJavaApiAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaApiAnalyser.kt\norg/archguard/scanner/analyser/backend/JavaApiAnalyser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1855#2,2:154\n766#2:156\n857#2,2:157\n1855#2,2:159\n1855#2,2:161\n766#2:163\n857#2,2:164\n766#2:166\n857#2,2:167\n*S KotlinDebug\n*F\n+ 1 JavaApiAnalyser.kt\norg/archguard/scanner/analyser/backend/JavaApiAnalyser\n*L\n25#1:154,2\n29#1:156\n29#1:157,2\n31#1:159,2\n36#1:161,2\n105#1:163\n105#1:164,2\n106#1:166\n106#1:167,2\n*E\n"})
public final class JavaApiAnalyser
implements ApiAnalyser {
    @NotNull
    private List<ContainerSupply> resources = CollectionsKt.emptyList();
    @NotNull
    private List<ContainerDemand> demands = CollectionsKt.emptyList();

    @Override
    @NotNull
    public List<ContainerSupply> getResources() {
        return this.resources;
    }

    @Override
    public void setResources(@NotNull List<ContainerSupply> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.resources = list;
    }

    @NotNull
    public final List<ContainerDemand> getDemands() {
        return this.demands;
    }

    public final void setDemands(@NotNull List<ContainerDemand> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.demands = list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analysisByNode(@NotNull CodeDataStruct node, @NotNull String workspace) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(workspace, "workspace");
        String[] stringArray = new String[]{"RestController", "Controller", "RequestMapping"};
        List<CodeAnnotation> routeAnnotation = node.filterAnnotations(stringArray);
        if (!((Collection)routeAnnotation).isEmpty()) {
            String baseUrl = null;
            baseUrl = "";
            String[] stringArray2 = new String[]{"RequestMapping"};
            List<CodeAnnotation> mappingAnnotation = node.filterAnnotations(stringArray2);
            if (!((Collection)mappingAnnotation).isEmpty() && !((Collection)mappingAnnotation.get(0).getKeyValues()).isEmpty()) {
                String url2 = mappingAnnotation.get(0).getKeyValues().get(0).getValue();
                baseUrl = StringsKt.removeSuffix(StringsKt.removePrefix(url2, (CharSequence)"\""), (CharSequence)"\"");
            }
            Iterable $this$forEach$iv = node.getFunctions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CodeFunction it = (CodeFunction)element$iv;
                boolean bl = false;
                this.createResource(it, baseUrl, node);
            }
        }
        Iterable $this$filter$iv = node.getImports();
        boolean $i$f$filter = false;
        Iterable $i$f$forEach = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CodeImport it = (CodeImport)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default(it.getSource(), ".RestTemplate", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List useRestTemplate = (List)destination$iv$iv;
        if (!((Collection)useRestTemplate).isEmpty()) {
            Iterable $this$forEach$iv = node.getFunctions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                CodeFunction it = (CodeFunction)element$iv;
                boolean bl = false;
                this.createDemand(it, node);
            }
        }
    }

    private final void createDemand(CodeFunction it, CodeDataStruct node) {
        Iterable $this$forEach$iv = it.getFunctionCalls();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String lowercase;
            CodeCall call = (CodeCall)element$iv;
            boolean bl = false;
            String functionName = call.getFunctionName();
            if (StringsKt.contains$default((CharSequence)functionName, ".", false, 2, null)) {
                String[] stringArray = new String[]{"."};
                functionName = (String)CollectionsKt.last(StringsKt.split$default((CharSequence)functionName, stringArray, false, 0, 6, null));
            }
            if (!Intrinsics.areEqual(call.getNodeName(), "RestTemplate") || Intrinsics.areEqual(call.getFunctionName(), "<init>")) continue;
            String method = "";
            Intrinsics.checkNotNullExpressionValue(functionName.toLowerCase(Locale.ROOT), "this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (StringsKt.startsWith$default(lowercase, "get", false, 2, null)) {
                method = "Get";
            } else if (StringsKt.startsWith$default(lowercase, "post", false, 2, null)) {
                method = "Post";
            } else if (StringsKt.startsWith$default(lowercase, "delete", false, 2, null)) {
                method = "Delete";
            } else if (StringsKt.startsWith$default(lowercase, "put", false, 2, null)) {
                method = "Put";
            }
            String url2 = "";
            if (!((Collection)call.getParameters()).isEmpty() && ((CharSequence)call.getParameters().get(0).getTypeValue()).length() > 0) {
                url2 = StringsKt.removeSuffix(StringsKt.removePrefix(call.getParameters().get(0).getTypeValue(), (CharSequence)"\""), (CharSequence)"\"");
            }
            if (!(((CharSequence)method).length() > 0)) continue;
            this.demands = CollectionsKt.plus((Collection)this.demands, new ContainerDemand(node.getNodeName(), null, null, url2, method, null, 38, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createResource(CodeFunction func, String baseUrl, CodeDataStruct node) {
        String httpMethod = "";
        String route = baseUrl;
        for (CodeAnnotation annotation2 : func.getAnnotations()) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            boolean hasSubUrlMapping;
            boolean isHttpAnnotation = true;
            switch (annotation2.getName()) {
                case "GetMapping": {
                    httpMethod = "Get";
                    break;
                }
                case "PostMapping": {
                    httpMethod = "Post";
                    break;
                }
                case "DeleteMapping": {
                    httpMethod = "Delete";
                    break;
                }
                case "PutMapping": {
                    httpMethod = "Put";
                    break;
                }
                case "PatchMapping": {
                    httpMethod = "Patch";
                    break;
                }
                default: {
                    isHttpAnnotation = false;
                }
            }
            boolean bl = hasSubUrlMapping = !((Collection)annotation2.getKeyValues()).isEmpty();
            if (isHttpAnnotation && ((CharSequence)httpMethod).length() > 0 && hasSubUrlMapping) {
                String subUrl = annotation2.getKeyValues().get(0).getValue();
                String pureUrl = StringsKt.removeSuffix(StringsKt.removePrefix(subUrl, (CharSequence)"\""), (CharSequence)"\"");
                route = ((CharSequence)baseUrl).length() > 0 ? baseUrl + pureUrl : pureUrl;
            }
            if (!Intrinsics.areEqual(annotation2.getName(), "RequestMapping")) continue;
            Iterable $this$filter$iv = annotation2.getKeyValues();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                AnnotationKeyValue it = (AnnotationKeyValue)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getKey(), "value")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List optUrl = (List)destination$iv$iv;
            Object $this$filter$iv2 = annotation2.getKeyValues();
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AnnotationKeyValue it = (AnnotationKeyValue)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it.getKey(), "method")) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List optMethod = (List)destination$iv$iv2;
            if (!(!((Collection)optUrl).isEmpty()) || !(!((Collection)optMethod).isEmpty())) continue;
            switch (((AnnotationKeyValue)optMethod.get(0)).getValue()) {
                case "GET": 
                case "RequestMethod.GET": {
                    httpMethod = "Get";
                    break;
                }
                case "RequestMethod.POST": 
                case "POST": {
                    httpMethod = "Post";
                    break;
                }
                case "DELETE": 
                case "RequestMethod.DELETE": {
                    httpMethod = "Delete";
                    break;
                }
                case "RequestMethod.PUT": 
                case "PUT": {
                    httpMethod = "Put";
                    break;
                }
                case "RequestMethod.PATCH": 
                case "PATCH": {
                    httpMethod = "Patch";
                }
            }
            String pureUrl = StringsKt.removeSuffix(StringsKt.removePrefix(((AnnotationKeyValue)optUrl.get(0)).getValue(), (CharSequence)"\""), (CharSequence)"\"");
            if (((CharSequence)baseUrl).length() > 0) {
                route = baseUrl + pureUrl;
                continue;
            }
            route = pureUrl;
        }
        if (((CharSequence)httpMethod).length() > 0) {
            if (!StringsKt.startsWith$default(route, "/", false, 2, null)) {
                route = '/' + route;
            }
            StringsKt.replace$default(route, "//", "/", false, 4, null);
            this.setResources(CollectionsKt.plus((Collection)this.getResources(), new ContainerSupply(route, httpMethod, node.getPackage(), node.getNodeName(), func.getName())));
        }
    }

    @Override
    @NotNull
    public List<ContainerService> toContainerServices() {
        ContainerService[] containerServiceArray = new ContainerService[1];
        List<ContainerSupply> list = this.getResources();
        List<ContainerDemand> list2 = this.demands;
        containerServiceArray[0] = new ContainerService("", list2, list);
        return CollectionsKt.mutableListOf(containerServiceArray);
    }
}

