/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.backend;

import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.archguard.scanner.analyser.base.ApiAnalyser;
import org.archguard.scanner.core.sourcecode.ContainerService;
import org.archguard.scanner.core.sourcecode.ContainerSupply;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000bH\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/archguard/scanner/analyser/backend/GoApiAnalyser;", "Lorg/archguard/scanner/analyser/base/ApiAnalyser;", "()V", "apiGroupStack", "Lkotlin/collections/ArrayDeque;", "", "getApiGroupStack", "()Lkotlin/collections/ArrayDeque;", "setApiGroupStack", "(Lkotlin/collections/ArrayDeque;)V", "resources", "", "Lorg/archguard/scanner/core/sourcecode/ContainerSupply;", "getResources", "()Ljava/util/List;", "setResources", "(Ljava/util/List;)V", "analysisByNode", "", "node", "Lchapi/domain/core/CodeDataStruct;", "workspace", "analysisFunctionCall", "function", "Lchapi/domain/core/CodeFunction;", "isGin", "", "nodeName", "isGinNode", "toContainerServices", "Lorg/archguard/scanner/core/sourcecode/ContainerService;", "feat_apicalls"})
@SourceDebugExtension(value={"SMAP\nGoApiAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoApiAnalyser.kt\norg/archguard/scanner/analyser/backend/GoApiAnalyser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1855#2,2:86\n1855#2,2:88\n1855#2,2:90\n*S KotlinDebug\n*F\n+ 1 GoApiAnalyser.kt\norg/archguard/scanner/analyser/backend/GoApiAnalyser\n*L\n14#1:86,2\n21#1:88,2\n55#1:90,2\n*E\n"})
public final class GoApiAnalyser
implements ApiAnalyser {
    @NotNull
    private List<ContainerSupply> resources = CollectionsKt.emptyList();
    @NotNull
    private ArrayDeque<String> apiGroupStack = new ArrayDeque();

    @Override
    @NotNull
    public List<ContainerSupply> getResources() {
        return this.resources;
    }

    @Override
    public void setResources(@NotNull List<ContainerSupply> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.resources = list;
    }

    @NotNull
    public final ArrayDeque<String> getApiGroupStack() {
        return this.apiGroupStack;
    }

    public final void setApiGroupStack(@NotNull ArrayDeque<String> arrayDeque) {
        Intrinsics.checkNotNullParameter(arrayDeque, "<set-?>");
        this.apiGroupStack = arrayDeque;
    }

    @Override
    public void analysisByNode(@NotNull CodeDataStruct node, @NotNull String workspace) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(workspace, "workspace");
        Iterable $this$forEach$iv = node.getFunctions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeFunction it = (CodeFunction)element$iv;
            boolean bl = false;
            this.apiGroupStack = new ArrayDeque();
            this.analysisFunctionCall(it);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final String analysisFunctionCall(CodeFunction function) {
        $this$forEach$iv = function.getFunctionCalls();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            funcCall = (CodeCall)element$iv;
            $i$a$-forEach-GoApiAnalyser$analysisFunctionCall$1 = false;
            if (!this.isGin(funcCall.getNodeName()) || funcCall.getParameters().isEmpty()) continue;
            typeValue = funcCall.getParameters().get(0).getTypeValue();
            if (Intrinsics.areEqual(funcCall.getFunctionName(), "Group")) {
                this.apiGroupStack.add(typeValue);
            }
            var9_9 = funcCall.getFunctionName();
            switch (var9_9.hashCode()) {
                case 2012838315: {
                    if (!var9_9.equals("DELETE")) {
                        break;
                    }
                    ** GOTO lbl27
                }
                case 2461856: {
                    if (!var9_9.equals("POST")) {
                        break;
                    }
                    ** GOTO lbl27
                }
                case 70454: {
                    if (!var9_9.equals("GET")) {
                        break;
                    }
                    ** GOTO lbl27
                }
                case 79599: {
                    if (!var9_9.equals("PUT")) break;
lbl27:
                    // 4 sources

                    url = StringsKt.endsWith$default(based = CollectionsKt.joinToString$default(this.apiGroupStack, "", null, null, 0, null, null, 62, null), "/", false, 2, null) == false && StringsKt.startsWith$default(typeValue, "/", false, 2, null) == false ? based + '/' + typeValue : based + typeValue;
                    this.setResources(CollectionsKt.plus((Collection)this.getResources(), new ContainerSupply(url, funcCall.getFunctionName(), function.getPackage(), "", function.getName())));
                }
            }
        }
        if (((Collection)function.getInnerFunctions()).isEmpty() == false) {
            $this$forEach$iv = function.getInnerFunctions();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                innerFunc = (CodeFunction)element$iv;
                $i$a$-forEach-GoApiAnalyser$analysisFunctionCall$2 = false;
                this.analysisFunctionCall(innerFunc);
            }
        }
        return null;
    }

    private final boolean isGin(String nodeName) {
        String name = StringsKt.removePrefix(nodeName, (CharSequence)"*");
        return this.isGinNode(name);
    }

    private final boolean isGinNode(String nodeName) {
        return Intrinsics.areEqual(nodeName, "gin") || Intrinsics.areEqual(nodeName, "gin.Engine") || Intrinsics.areEqual(nodeName, "gin.RouterGroup") || Intrinsics.areEqual(nodeName, "gin.Default");
    }

    @Override
    @NotNull
    public List<ContainerService> toContainerServices() {
        ContainerService[] containerServiceArray = new ContainerService[1];
        List<ContainerSupply> list = this.getResources();
        ArrayList arrayList = new ArrayList();
        containerServiceArray[0] = new ContainerService("", arrayList, list);
        return CollectionsKt.mutableListOf(containerServiceArray);
    }
}

