/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.backend;

import chapi.domain.core.CodeAnnotation;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.archguard.scanner.analyser.base.ApiAnalyser;
import org.archguard.scanner.core.sourcecode.ContainerService;
import org.archguard.scanner.core.sourcecode.ContainerSupply;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/archguard/scanner/analyser/backend/CSharpApiAnalyser;", "Lorg/archguard/scanner/analyser/base/ApiAnalyser;", "()V", "resources", "", "Lorg/archguard/scanner/core/sourcecode/ContainerSupply;", "getResources", "()Ljava/util/List;", "setResources", "(Ljava/util/List;)V", "analysisByNode", "", "node", "Lchapi/domain/core/CodeDataStruct;", "workspace", "", "createResource", "func", "Lchapi/domain/core/CodeFunction;", "baseUrl", "toContainerServices", "Lorg/archguard/scanner/core/sourcecode/ContainerService;", "feat_apicalls"})
@SourceDebugExtension(value={"SMAP\nCSharpApiAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CSharpApiAnalyser.kt\norg/archguard/scanner/analyser/backend/CSharpApiAnalyser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1855#2,2:59\n*S KotlinDebug\n*F\n+ 1 CSharpApiAnalyser.kt\norg/archguard/scanner/analyser/backend/CSharpApiAnalyser\n*L\n19#1:59,2\n*E\n"})
public final class CSharpApiAnalyser
implements ApiAnalyser {
    @NotNull
    private List<ContainerSupply> resources = CollectionsKt.emptyList();

    @Override
    @NotNull
    public List<ContainerSupply> getResources() {
        return this.resources;
    }

    @Override
    public void setResources(@NotNull List<ContainerSupply> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.resources = list;
    }

    @Override
    public void analysisByNode(@NotNull CodeDataStruct node, @NotNull String workspace) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(workspace, "workspace");
        String[] stringArray = new String[]{"RoutePrefix", "Route"};
        List<CodeAnnotation> routeAnnotation = node.filterAnnotations(stringArray);
        if (!((Collection)routeAnnotation).isEmpty() || StringsKt.endsWith$default(node.getNodeName(), "Controller", false, 2, null)) {
            String baseUrl = null;
            baseUrl = "";
            if (!((Collection)routeAnnotation).isEmpty()) {
                baseUrl = routeAnnotation.get(0).getKeyValues().get(0).getValue();
            }
            Iterable $this$forEach$iv = node.getFunctions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CodeFunction it = (CodeFunction)element$iv;
                boolean bl = false;
                this.createResource(it, baseUrl, node);
            }
        }
    }

    private final void createResource(CodeFunction func, String baseUrl, CodeDataStruct node) {
        String httpMethod = "";
        String route = "";
        for (CodeAnnotation annotation2 : func.getAnnotations()) {
            switch (annotation2.getName()) {
                case "HttpGet": {
                    httpMethod = "Get";
                    break;
                }
                case "HttpPost": {
                    httpMethod = "Post";
                    break;
                }
                case "HttpDelete": {
                    httpMethod = "Delete";
                    break;
                }
                case "HttpPut": {
                    httpMethod = "Put";
                }
            }
            if (!Intrinsics.areEqual(annotation2.getName(), "Route")) continue;
            route = baseUrl + '/' + annotation2.getKeyValues().get(0).getValue();
        }
        if (((CharSequence)route).length() > 0 && ((CharSequence)httpMethod).length() > 0) {
            if (!StringsKt.startsWith$default(route, "/", false, 2, null)) {
                route = '/' + route;
            }
            this.setResources(CollectionsKt.plus((Collection)this.getResources(), new ContainerSupply(route, httpMethod, node.getPackage(), node.getNodeName(), func.getName())));
        }
    }

    @Override
    @NotNull
    public List<ContainerService> toContainerServices() {
        return CollectionsKt.listOf(new ContainerService("", null, this.getResources(), 2, null));
    }
}

