/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser;

import chapi.domain.core.CodeDataStruct;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.archguard.scanner.analyser.backend.CSharpApiAnalyser;
import org.archguard.scanner.analyser.backend.GoApiAnalyser;
import org.archguard.scanner.analyser.backend.JavaApiAnalyser;
import org.archguard.scanner.analyser.frontend.FrontendApiAnalyser;
import org.archguard.scanner.core.client.ArchGuardClient;
import org.archguard.scanner.core.sourcecode.ASTSourceCodeAnalyser;
import org.archguard.scanner.core.sourcecode.ContainerService;
import org.archguard.scanner.core.sourcecode.SourceCodeContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/archguard/scanner/analyser/ApiCallAnalyser;", "Lorg/archguard/scanner/core/sourcecode/ASTSourceCodeAnalyser;", "context", "Lorg/archguard/scanner/core/sourcecode/SourceCodeContext;", "(Lorg/archguard/scanner/core/sourcecode/SourceCodeContext;)V", "client", "Lorg/archguard/scanner/core/client/ArchGuardClient;", "getContext", "()Lorg/archguard/scanner/core/sourcecode/SourceCodeContext;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "analyse", "", "Lorg/archguard/scanner/core/sourcecode/ContainerService;", "input", "Lchapi/domain/core/CodeDataStruct;", "feat_apicalls"})
@SourceDebugExtension(value={"SMAP\nApiCallAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiCallAnalyser.kt\norg/archguard/scanner/analyser/ApiCallAnalyser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1855#2,2:74\n1855#2,2:76\n1855#2,2:78\n1855#2,2:80\n*S KotlinDebug\n*F\n+ 1 ApiCallAnalyser.kt\norg/archguard/scanner/analyser/ApiCallAnalyser\n*L\n26#1:74,2\n37#1:76,2\n48#1:78,2\n59#1:80,2\n*E\n"})
public final class ApiCallAnalyser
implements ASTSourceCodeAnalyser {
    @NotNull
    private final SourceCodeContext context;
    @NotNull
    private final ArchGuardClient client;
    private final Logger logger;

    public ApiCallAnalyser(@NotNull SourceCodeContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.client = this.getContext().getClient();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @NotNull
    public SourceCodeContext getContext() {
        return this.context;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public List<ContainerService> analyse(@NotNull List<CodeDataStruct> input) {
        block19: {
            block18: {
                block17: {
                    Intrinsics.checkNotNullParameter(input, "input");
                    v0 = this.getContext().getLanguage().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(v0, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    language = v0;
                    path = this.getContext().getPath();
                    var5_4 = language;
                    switch (var5_4.hashCode()) {
                        case 3104: {
                            if (var5_4.equals("c#")) break;
                            ** break;
                        }
                        case -1351281305: {
                            if (var5_4.equals("csharp")) break;
                            ** break;
                        }
                        case 3254818: {
                            if (!var5_4.equals("java")) {
                                ** break;
                            }
                            break block17;
                        }
                        case -1240339754: {
                            if (!var5_4.equals("golang")) {
                                ** break;
                            }
                            break block18;
                        }
                        case -1125574399: {
                            if (!var5_4.equals("kotlin")) {
                                ** break;
                            }
                            break block17;
                        }
                        case -522285947: {
                            if (!var5_4.equals("typescript")) {
                                ** break;
                            }
                            ** GOTO lbl32
                        }
                        case 188995949: {
                            if (!var5_4.equals("javascript")) ** break;
lbl32:
                            // 2 sources

                            this.logger.info("start analysis frontend api ---- " + language);
                            feApiAnalyser = new FrontendApiAnalyser();
                            $this$forEach$iv = input;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                data = (CodeDataStruct)element$iv;
                                $i$a$-forEach-ApiCallAnalyser$analyse$apiCalls$1 = false;
                                feApiAnalyser.analysisByNode(data, path);
                            }
                            v1 = feApiAnalyser.toContainerServices();
                            break block19;
                        }
                    }
                    this.logger.info("start analysis backend api ---- CSharp");
                    csharpApiAnalyser = new CSharpApiAnalyser();
                    $this$forEach$iv = input;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        data = (CodeDataStruct)element$iv;
                        $i$a$-forEach-ApiCallAnalyser$analyse$apiCalls$2 = false;
                        csharpApiAnalyser.analysisByNode(data, "");
                    }
                    v1 = csharpApiAnalyser.toContainerServices();
                    break block19;
                }
                this.logger.info("start analysis backend api ---- " + language);
                apiAnalyser = new JavaApiAnalyser();
                $this$forEach$iv = input;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    data = (CodeDataStruct)element$iv;
                    $i$a$-forEach-ApiCallAnalyser$analyse$apiCalls$3 = false;
                    apiAnalyser.analysisByNode(data, "");
                }
                v1 = apiAnalyser.toContainerServices();
                break block19;
            }
            this.logger.info("start analysis backend api ---- " + language);
            apiAnalyser = new GoApiAnalyser();
            $this$forEach$iv = input;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                data = (CodeDataStruct)element$iv;
                $i$a$-forEach-ApiCallAnalyser$analyse$apiCalls$4 = false;
                apiAnalyser.analysisByNode(data, "");
            }
            v1 = apiAnalyser.toContainerServices();
            break block19;
lbl86:
            // 8 sources

            throw new IllegalArgumentException("Unsupported language: " + language);
        }
        apiCalls = v1;
        this.client.saveApi(apiCalls);
        return apiCalls;
    }

    @Override
    @Nullable
    public List<Object> analyse(@Nullable Object input2) {
        return ASTSourceCodeAnalyser.DefaultImpls.analyse(this, input2);
    }
}

