/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.action.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import org.archguard.action.exec.ExecListeners;
import org.archguard.action.exec.ExecOptions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\u000e\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"Lorg/archguard/action/exec/Command;", "", "()V", "doExecute", "", "processBuilder", "Ljava/lang/ProcessBuilder;", "options", "Lorg/archguard/action/exec/ExecOptions;", "exec", "commandLine", "", "args", "", "execJar", "workdir", "Companion", "action-toolkit"})
@SourceDebugExtension(value={"SMAP\nCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Command.kt\norg/archguard/action/exec/Command\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,57:1\n37#2,2:58\n37#2,2:60\n*S KotlinDebug\n*F\n+ 1 Command.kt\norg/archguard/action/exec/Command\n*L\n12#1:58,2\n22#1:60,2\n*E\n"})
public final class Command {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public final int execJar(@NotNull List<String> args2, @NotNull String workdir, @NotNull ExecOptions options2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(workdir, "workdir");
        Intrinsics.checkNotNullParameter(options2, "options");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add("java");
        spreadBuilder.add("-jar");
        Collection $this$toTypedArray$iv = args2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread(thisCollection$iv.toArray(new String[0]));
        ProcessBuilder processBuilder = new ProcessBuilder((String[])spreadBuilder.toArray(new String[spreadBuilder.size()]));
        return this.doExecute(processBuilder, options2);
    }

    public static /* synthetic */ int execJar$default(Command command2, List list, String string, ExecOptions execOptions, int n, Object object) {
        if ((n & 4) != 0) {
            execOptions = new ExecOptions(string, null, false, false, null, 30, null);
        }
        return command2.execJar(list, string, execOptions);
    }

    public final int exec(@NotNull String commandLine, @NotNull List<String> args2, @NotNull ExecOptions options2) {
        Intrinsics.checkNotNullParameter(commandLine, "commandLine");
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(options2, "options");
        if (!options2.getSilent()) {
            logger.info("Executing: " + commandLine + ' ' + CollectionsKt.joinToString$default(args2, " ", null, null, 0, null, null, 62, null));
        }
        String[] stringArray = new String[]{"bash", "-c", commandLine + ' ' + CollectionsKt.joinToString$default(args2, " ", null, null, 0, null, null, 62, null)};
        List<String> commandWithArgs = CollectionsKt.mutableListOf(stringArray);
        Collection $this$toTypedArray$iv = commandWithArgs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        ProcessBuilder processBuilder = new ProcessBuilder(Arrays.copyOf(stringArray2, stringArray2.length));
        return this.doExecute(processBuilder, options2);
    }

    public static /* synthetic */ int exec$default(Command command2, String string, List list, ExecOptions execOptions, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return command2.exec(string, list, execOptions);
    }

    private final int doExecute(ProcessBuilder processBuilder, ExecOptions options2) {
        Process process2 = processBuilder.directory(new File(options2.getCwd())).start();
        int exitCode = process2.waitFor();
        InputStream inputStream2 = process2.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream2, "process.inputStream");
        InputStream inputStream3 = inputStream2;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream3, charset);
        int n = 8192;
        TextStreamsKt.forEachLine(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n), (Function1<? super String, Unit>)new Function1<String, Unit>((Object)options2.getListeners()){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((ExecListeners)this.receiver).stdout(p0);
            }
        });
        if (exitCode != 0 && !options2.getIgnoreReturnCode()) {
            InputStream inputStream4 = process2.getErrorStream();
            Intrinsics.checkNotNullExpressionValue(inputStream4, "process.errorStream");
            inputStream3 = inputStream4;
            charset = Charsets.UTF_8;
            reader = new InputStreamReader(inputStream3, charset);
            n = 8192;
            TextStreamsKt.forEachLine(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n), (Function1<? super String, Unit>)new Function1<String, Unit>((Object)options2.getListeners()){

                public final void invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    ((ExecListeners)this.receiver).stderr(p0);
                }
            });
        }
        return exitCode;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(Command.class);
        Intrinsics.checkNotNullExpressionValue(logger2, "getLogger(Command::class.java)");
        logger = logger2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\b\b\u0002\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/archguard/action/exec/Command$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "exec", "", "commandLine", "", "args", "", "options", "Lorg/archguard/action/exec/ExecOptions;", "action-toolkit"})
    public static final class Companion {
        private Companion() {
        }

        public final int exec(@NotNull String commandLine, @NotNull List<String> args2, @NotNull ExecOptions options2) {
            Intrinsics.checkNotNullParameter(commandLine, "commandLine");
            Intrinsics.checkNotNullParameter(args2, "args");
            Intrinsics.checkNotNullParameter(options2, "options");
            return new Command().exec(commandLine, args2, options2);
        }

        public static /* synthetic */ int exec$default(Companion companion, String string, List list, ExecOptions execOptions, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                execOptions = new ExecOptions(null, null, false, false, null, 31, null);
            }
            return companion.exec(string, list, execOptions);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

