/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.action.checkout;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.archguard.action.checkout.GitOutput;
import org.archguard.action.checkout.MainKt;
import org.archguard.action.checkout.helper.RefHelper;
import org.archguard.action.checkout.helper.RetryHelper;
import org.archguard.action.exec.Command;
import org.archguard.action.exec.ExecOptions;
import org.archguard.action.exec.StringListExecListeners;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0003J\u0016\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0003J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\u0018\u001a\u00020\u0005J\u001a\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00032\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0003J\u0006\u0010!\u001a\u00020\u0017J*\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020\u0005J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u0005J(\u0010(\u001a\u00020\u00172\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\b\b\u0002\u0010*\u001a\u00020\u00052\b\b\u0002\u0010+\u001a\u00020\u0005J%\u0010,\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003J\u0006\u00103\u001a\u00020\u0017J\u0012\u00104\u001a\u00020\u00172\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u0003J\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u0003072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dJ\u0010\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u00108\u001a\u00020\u0003J'\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/\u00a2\u0006\u0002\u0010<J\u0016\u0010=\u001a\u00020>2\u0006\u0010;\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u0003J\u000e\u0010@\u001a\u00020>2\u0006\u0010A\u001a\u00020\u0003J\u0016\u0010B\u001a\u00020>2\u0006\u0010A\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003J\u0016\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u0005J\u000e\u0010G\u001a\u00020\u00172\u0006\u0010F\u001a\u00020\u0005J\u0016\u0010H\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/2\u0006\u0010F\u001a\u00020\u0005J\u000e\u0010I\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0003J\u0018\u0010J\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u0005J\u0006\u0010K\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/archguard/action/checkout/GitCommandManager;", "", "workingDirectory", "", "lfs", "", "(Ljava/lang/String;Z)V", "exec", "Lorg/archguard/action/exec/Command;", "gitEnv", "", "gitPath", "getGitPath", "()Ljava/lang/String;", "setGitPath", "(Ljava/lang/String;)V", "refHelper", "Lorg/archguard/action/checkout/helper/RefHelper;", "retryHelper", "Lorg/archguard/action/checkout/helper/RetryHelper;", "getWorkingDirectory", "setWorkingDirectory", "branchDelete", "Lorg/archguard/action/checkout/GitOutput;", "remote", "branch", "branchExists", "pattern", "branchList", "", "checkout", "ref", "startPoint", "checkoutDetach", "config", "configKey", "configValue", "globalConfig", "add", "configExists", "execGit", "args", "allowAllExitCodes", "silent", "fetch", "refSpec", "fetchDepth", "", "(Ljava/util/List;Ljava/lang/Integer;)Lorg/archguard/action/checkout/GitOutput;", "getDefaultBranch", "repositoryUrl", "init", "log", "format", "parseBranchList", "", "lines", "parseDefaultBranch", "pullRemote", "remoteName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lorg/archguard/action/checkout/GitOutput;", "remoteAdd", "", "remoteUrl", "removeEnvironmentVariable", "name", "setEnvironmentVariable", "value", "submoduleForeach", "command", "recursive", "submoduleSync", "submoduleUpdate", "tagExists", "tryConfigUnset", "tryDisableAutomaticGarbageCollection"})
@SourceDebugExtension(value={"SMAP\nGitCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommandManager.kt\norg/archguard/action/checkout/GitCommandManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1747#2,3:285\n*S KotlinDebug\n*F\n+ 1 GitCommandManager.kt\norg/archguard/action/checkout/GitCommandManager\n*L\n122#1:285,3\n*E\n"})
public final class GitCommandManager {
    @NotNull
    private String workingDirectory;
    private boolean lfs;
    @NotNull
    private final Map<String, String> gitEnv;
    @NotNull
    private String gitPath;
    @NotNull
    private final Command exec;
    @NotNull
    private final RefHelper refHelper;
    @NotNull
    private final RetryHelper retryHelper;

    public GitCommandManager(@NotNull String workingDirectory, boolean lfs) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        this.workingDirectory = workingDirectory;
        this.lfs = lfs;
        Pair[] pairArray = new Pair[]{TuplesKt.to("GIT_TERMINAL_PROMPT", "0"), TuplesKt.to("GCM_INTERACTIVE", "Never")};
        this.gitEnv = MapsKt.mutableMapOf(pairArray);
        this.gitPath = "git";
        this.exec = new Command();
        this.refHelper = new RefHelper();
        this.retryHelper = new RetryHelper(0, 0, 0, 7, null);
    }

    public /* synthetic */ GitCommandManager(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".";
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.workingDirectory = string;
    }

    @NotNull
    public final String getGitPath() {
        return this.gitPath;
    }

    public final void setGitPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.gitPath = string;
    }

    @NotNull
    public final GitOutput init() {
        String[] stringArray = new String[]{"init", "."};
        return GitCommandManager.execGit$default(this, CollectionsKt.listOf(stringArray), false, false, 6, null);
    }

    public final void remoteAdd(@NotNull String remoteName, @NotNull String remoteUrl) {
        Intrinsics.checkNotNullParameter(remoteName, "remoteName");
        Intrinsics.checkNotNullParameter(remoteUrl, "remoteUrl");
        String[] stringArray = new String[]{"remote", "add", remoteName, remoteUrl};
        GitCommandManager.execGit$default(this, CollectionsKt.listOf(stringArray), false, false, 6, null);
    }

    @NotNull
    public final GitOutput branchDelete(boolean remote, @NotNull String branch) {
        Intrinsics.checkNotNullParameter(branch, "branch");
        String[] stringArray = new String[]{"branch", "--delete", "--force"};
        List<String> args2 = CollectionsKt.mutableListOf(stringArray);
        if (remote) {
            args2.add("--remote");
        }
        args2.add(branch);
        return GitCommandManager.execGit$default(this, args2, false, false, 6, null);
    }

    public final boolean branchExists(boolean remote, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        String[] stringArray = new String[]{"branch", "--list"};
        List<String> args2 = CollectionsKt.mutableListOf(stringArray);
        if (remote) {
            args2.add("--remote");
        }
        args2.add(pattern);
        GitOutput output2 = GitCommandManager.execGit$default(this, args2, false, false, 6, null);
        return ((CharSequence)((Object)StringsKt.trim((CharSequence)output2.getStdout())).toString()).length() > 0;
    }

    @NotNull
    public final List<String> branchList(boolean remote) {
        String[] stringArray = new String[]{"rev-parse", "--symbolic-full-name"};
        List<String> args2 = CollectionsKt.mutableListOf(stringArray);
        if (remote) {
            args2.add("--remotes=origin");
        } else {
            args2.add("--branches");
        }
        GitOutput output2 = GitCommandManager.execGit$default(this, args2, false, false, 6, null);
        return this.parseBranchList(StringsKt.lines(output2.getStdout()));
    }

    @NotNull
    public final List<String> parseBranchList(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        List result2 = new ArrayList();
        for (String branch : lines) {
            if (StringsKt.startsWith$default(branch, "refs/heads/", false, 2, null)) {
                String string = branch.substring(11);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                result2.add(string);
                continue;
            }
            if (!StringsKt.startsWith$default(branch, "refs/remotes/", false, 2, null)) continue;
            String string = branch.substring(13);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            result2.add(string);
        }
        return result2;
    }

    @NotNull
    public final GitOutput checkout(@NotNull String ref, @Nullable String startPoint) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        String[] stringArray = new String[]{"checkout", "--progress", "--force"};
        List<String> args2 = CollectionsKt.mutableListOf(stringArray);
        if (startPoint != null) {
            stringArray = new String[]{"-B", ref, startPoint};
            args2.addAll((Collection<String>)CollectionsKt.listOf(stringArray));
        } else {
            args2.add(ref);
        }
        return GitCommandManager.execGit$default(this, args2, false, false, 6, null);
    }

    public static /* synthetic */ GitOutput checkout$default(GitCommandManager gitCommandManager, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return gitCommandManager.checkout(string, string2);
    }

    @NotNull
    public final GitOutput checkoutDetach() {
        String[] stringArray = new String[]{"checkout", "--detach"};
        List<String> args2 = CollectionsKt.listOf(stringArray);
        return GitCommandManager.execGit$default(this, args2, false, false, 6, null);
    }

    @NotNull
    public final GitOutput config(@NotNull String configKey, @NotNull String configValue, boolean globalConfig, boolean add) {
        Intrinsics.checkNotNullParameter(configKey, "configKey");
        Intrinsics.checkNotNullParameter(configValue, "configValue");
        String[] stringArray = new String[]{"config", globalConfig ? "--global" : "--local"};
        List<String> args2 = CollectionsKt.mutableListOf(stringArray);
        if (add) {
            args2.add("--add");
        }
        stringArray = new String[]{configKey, configValue};
        args2.addAll((Collection<String>)CollectionsKt.listOf(stringArray));
        return GitCommandManager.execGit$default(this, args2, false, false, 6, null);
    }

    public static /* synthetic */ GitOutput config$default(GitCommandManager gitCommandManager, String string, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return gitCommandManager.config(string, string2, bl, bl2);
    }

    public final boolean tryDisableAutomaticGarbageCollection() {
        String[] stringArray = new String[]{"config", "--local", "gc.auto", "0"};
        GitOutput output2 = GitCommandManager.execGit$default(this, CollectionsKt.listOf(stringArray), true, false, 4, null);
        return output2.getExitCode() == 0;
    }

    public final boolean configExists(@NotNull String configKey, boolean globalConfig) {
        Intrinsics.checkNotNullParameter(configKey, "configKey");
        String pattern = Regex.Companion.escape(configKey);
        String scope2 = globalConfig ? "--global" : "--local";
        String[] stringArray = new String[]{"config", scope2, "--name-only", "--get-regexp", pattern};
        GitOutput output2 = GitCommandManager.execGit$default(this, CollectionsKt.listOf(stringArray), true, false, 4, null);
        return output2.getExitCode() == 0;
    }

    public static /* synthetic */ boolean configExists$default(GitCommandManager gitCommandManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return gitCommandManager.configExists(string, bl);
    }

    @NotNull
    public final GitOutput fetch(@NotNull List<String> refSpec, @Nullable Integer fetchDepth) {
        boolean bl;
        List<String> args2;
        String[] stringArray;
        block7: {
            Intrinsics.checkNotNullParameter(refSpec, "refSpec");
            stringArray = new String[]{"-c", "protocol.version=2", "fetch"};
            args2 = CollectionsKt.mutableListOf(stringArray);
            Iterable $this$any$iv = refSpec;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it, this.refHelper.getTagsRefSpec())) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (!bl) {
            args2.add("--no-tags");
        }
        stringArray = new String[]{"--prune", "--progress", "--no-recurse-submodules"};
        args2.addAll((Collection<String>)CollectionsKt.listOf(stringArray));
        if (fetchDepth != null && fetchDepth > 0) {
            args2.add("--depth=" + fetchDepth);
        } else if (new File(this.workingDirectory, ".git" + File.separator + "shallow").exists()) {
            args2.add("--unshallow");
        }
        args2.add("origin");
        args2.addAll((Collection<String>)refSpec);
        return (GitOutput)this.retryHelper.execute((Function0)new Function0<GitOutput>(this, args2){
            final /* synthetic */ GitCommandManager this$0;
            final /* synthetic */ List<String> $args;
            {
                this.this$0 = $receiver;
                this.$args = $args;
                super(0);
            }

            @NotNull
            public final GitOutput invoke() {
                return GitCommandManager.execGit$default(this.this$0, this.$args, false, false, 6, null);
            }
        });
    }

    public static /* synthetic */ GitOutput fetch$default(GitCommandManager gitCommandManager, List list, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return gitCommandManager.fetch(list, n);
    }

    @NotNull
    public final String getDefaultBranch(@NotNull String repositoryUrl) {
        Intrinsics.checkNotNullParameter(repositoryUrl, "repositoryUrl");
        Ref.ObjectRef<GitOutput> output2 = new Ref.ObjectRef<GitOutput>();
        this.retryHelper.execute((Function0)new Function0<Unit>(output2, this, repositoryUrl){
            final /* synthetic */ Ref.ObjectRef<GitOutput> $output;
            final /* synthetic */ GitCommandManager this$0;
            final /* synthetic */ String $repositoryUrl;
            {
                this.$output = $output;
                this.this$0 = $receiver;
                this.$repositoryUrl = $repositoryUrl;
                super(0);
            }

            public final void invoke() {
                String[] stringArray = new String[]{"ls-remote", "--quiet", "--exit-code", "--symref", this.$repositoryUrl, "HEAD"};
                this.$output.element = GitCommandManager.execGit$default(this.this$0, CollectionsKt.listOf(stringArray), false, false, 6, null);
            }
        });
        if (output2.element != null) {
            Object t = output2.element;
            Intrinsics.checkNotNull(t);
            String defaultBranch = this.parseDefaultBranch(((GitOutput)t).getStdout());
            if (defaultBranch != null) {
                return defaultBranch;
            }
        }
        Logger logger2 = MainKt.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("getDefaultBranch Output Code: ");
        Object t = output2.element;
        Intrinsics.checkNotNull(t);
        logger2.info(stringBuilder.append(((GitOutput)t).getStderr()).toString());
        throw new Error("Unexpected output when retrieving default branch");
    }

    @Nullable
    public final String parseDefaultBranch(@NotNull String lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        String[] stringArray = new String[]{"\n"};
        for (String splitLine : StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)lines)).toString(), stringArray, false, 0, 6, null)) {
            String line = ((Object)StringsKt.trim((CharSequence)splitLine)).toString();
            if (!StringsKt.startsWith$default(line, "ref:", false, 2, null) || !StringsKt.endsWith$default(line, "HEAD", false, 2, null)) continue;
            String string = line.substring(4, line.length() - 4);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            return ((Object)StringsKt.trim((CharSequence)string)).toString();
        }
        MainKt.getLogger().error("Output: " + lines);
        MainKt.getLogger().error("Unexpected output when retrieving default branch");
        return null;
    }

    @NotNull
    public final GitOutput submoduleForeach(@NotNull String command2, boolean recursive) {
        Intrinsics.checkNotNullParameter(command2, "command");
        String[] stringArray = new String[]{"submodule", "foreach"};
        List<String> args2 = CollectionsKt.mutableListOf(stringArray);
        if (recursive) {
            args2.add("--recursive");
        }
        args2.add(command2);
        return GitCommandManager.execGit$default(this, args2, false, false, 6, null);
    }

    @NotNull
    public final GitOutput submoduleSync(boolean recursive) {
        String[] stringArray = new String[]{"submodule", "sync"};
        List<String> args2 = CollectionsKt.mutableListOf(stringArray);
        if (recursive) {
            args2.add("--recursive");
        }
        return GitCommandManager.execGit$default(this, args2, false, false, 6, null);
    }

    @NotNull
    public final GitOutput submoduleUpdate(int fetchDepth, boolean recursive) {
        String[] stringArray = new String[]{"-c", "protocol.version=2"};
        List<String> args2 = CollectionsKt.mutableListOf(stringArray);
        stringArray = new String[]{"submodule", "update", "--init", "--force"};
        args2.addAll((Collection<String>)CollectionsKt.listOf(stringArray));
        if (fetchDepth > 0) {
            args2.add("--depth=" + fetchDepth);
        }
        if (recursive) {
            args2.add("--recursive");
        }
        return GitCommandManager.execGit$default(this, args2, false, false, 6, null);
    }

    @NotNull
    public final GitOutput log(@Nullable String format) {
        List<String> list;
        String[] stringArray;
        if (format != null) {
            stringArray = new String[]{"log", "-1", format};
            list = CollectionsKt.listOf(stringArray);
        } else {
            stringArray = new String[]{"log", "-1"};
            list = CollectionsKt.listOf(stringArray);
        }
        List<String> args2 = list;
        boolean silent = format != null;
        return this.execGit(args2, false, silent);
    }

    public static /* synthetic */ GitOutput log$default(GitCommandManager gitCommandManager, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return gitCommandManager.log(string);
    }

    @NotNull
    public final GitOutput execGit(@NotNull List<String> args2, boolean allowAllExitCodes, boolean silent) {
        String value;
        String key;
        Intrinsics.checkNotNullParameter(args2, "args");
        GitOutput result2 = new GitOutput(null, 0, null, 7, null);
        Map env = new LinkedHashMap();
        Map<String, String> map2 = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map2, "getenv()");
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(key, "key");
            Intrinsics.checkNotNullExpressionValue(value, "value");
            env.put(key, value);
        }
        for (Map.Entry<String, String> entry : this.gitEnv.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            env.put(key, value);
        }
        List stdout = new ArrayList();
        List stderr = new ArrayList();
        ExecOptions options2 = new ExecOptions(this.workingDirectory, env, silent, allowAllExitCodes, new StringListExecListeners(stdout, stderr));
        result2.setExitCode(this.exec.exec(this.gitPath, args2, options2));
        result2.setStdout(CollectionsKt.joinToString$default(stdout, "\n", null, null, 0, null, null, 62, null));
        result2.setStderr(CollectionsKt.joinToString$default(stderr, "\n", null, null, 0, null, null, 62, null));
        return result2;
    }

    public static /* synthetic */ GitOutput execGit$default(GitCommandManager gitCommandManager, List list, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return gitCommandManager.execGit(list, bl, bl2);
    }

    @NotNull
    public final GitOutput pullRemote(@NotNull String remoteName, @NotNull String refSpec, @Nullable Integer fetchDepth) {
        Intrinsics.checkNotNullParameter(remoteName, "remoteName");
        Intrinsics.checkNotNullParameter(refSpec, "refSpec");
        String[] stringArray = new String[]{"pull", "--progress", "--no-recurse-submodules", remoteName, refSpec};
        List<String> args2 = CollectionsKt.mutableListOf(stringArray);
        if (fetchDepth != null && fetchDepth > 0) {
            args2.add("--depth=" + fetchDepth);
        }
        return GitCommandManager.execGit$default(this, args2, false, false, 6, null);
    }

    public static /* synthetic */ GitOutput pullRemote$default(GitCommandManager gitCommandManager, String string, String string2, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return gitCommandManager.pullRemote(string, string2, n);
    }

    public final void setEnvironmentVariable(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        this.gitEnv.put(name, value);
    }

    public final boolean tryConfigUnset(@NotNull String configKey, boolean globalConfig) {
        Intrinsics.checkNotNullParameter(configKey, "configKey");
        String[] stringArray = new String[]{"config", globalConfig ? "--global" : "--local", "--unset-all", configKey};
        GitOutput output2 = GitCommandManager.execGit$default(this, CollectionsKt.listOf(stringArray), true, false, 4, null);
        return output2.getExitCode() == 0;
    }

    public static /* synthetic */ boolean tryConfigUnset$default(GitCommandManager gitCommandManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return gitCommandManager.tryConfigUnset(string, bl);
    }

    public final boolean tagExists(@NotNull String ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        String[] stringArray = new String[]{"tag", "--list", ref};
        GitOutput output2 = GitCommandManager.execGit$default(this, CollectionsKt.listOf(stringArray), false, false, 6, null);
        return ((CharSequence)((Object)StringsKt.trim((CharSequence)output2.getStdout())).toString()).length() > 0;
    }

    public final void removeEnvironmentVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.gitEnv.remove(name);
    }

    public GitCommandManager() {
        this(null, false, 3, null);
    }
}

