/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.action.checkout;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.action.checkout.GitCommandManager;
import org.archguard.action.checkout.GitSourceSettings;
import org.archguard.action.checkout.MainKt;
import org.archguard.action.checkout.helper.CheckoutInfo;
import org.archguard.action.checkout.helper.GitAuthHelper;
import org.archguard.action.checkout.helper.RefHelper;
import org.archguard.action.io.FileExt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"doCheckout", "", "git", "Lorg/archguard/action/checkout/GitCommandManager;", "settings", "Lorg/archguard/action/checkout/GitSourceSettings;", "executeGitCheckout", "checkout"})
public final class ExecuteGitCheckoutKt {
    public static final void executeGitCheckout(@NotNull GitSourceSettings settings) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        String workingDirectory = settings.getWorkdir() + File.separator + settings.getRepositoryPath();
        GitCommandManager git = new GitCommandManager(workingDirectory, false, 2, null);
        Logger logger2 = MainKt.getLogger();
        Path path2 = Paths.get(workingDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "get(path)");
        logger2.info("Working directory: {}", (Object)path2.toAbsolutePath());
        if (new File(workingDirectory).exists()) {
            FileExt.INSTANCE.rmdir(workingDirectory);
        }
        FileExt.INSTANCE.mkdir(workingDirectory);
        ExecuteGitCheckoutKt.doCheckout(git, settings);
    }

    public static final void doCheckout(@NotNull GitCommandManager git, @NotNull GitSourceSettings settings) {
        Intrinsics.checkNotNullParameter(git, "git");
        Intrinsics.checkNotNullParameter(settings, "settings");
        GitAuthHelper authHelper = new GitAuthHelper(git, settings);
        authHelper.configureTempGlobalConfig();
        git.config("safe.directory", git.getWorkingDirectory(), true, true);
        MainKt.getLogger().info("Initializing git repository");
        git.init();
        git.remoteAdd("origin", settings.getRepository());
        if (((CharSequence)settings.getAuthToken()).length() > 0) {
            MainKt.getLogger().info("Configuring auth");
            authHelper.configureAuth();
        }
        MainKt.getLogger().info("Disabling automatic garbage collection");
        git.tryDisableAutomaticGarbageCollection();
        settings.setRef(git.getDefaultBranch(settings.getRepository()));
        MainKt.getLogger().info("Determining default branch for repository: " + settings.getRepository() + ", default branch: " + settings.getRef());
        RefHelper refHelper = new RefHelper();
        List<String> refSpec = refHelper.getRefSpecForAllHistory(settings.getRef(), settings.getBranch());
        MainKt.getLogger().info("Fetching all history for {}", (Object)refSpec);
        GitCommandManager.fetch$default(git, refSpec, null, 2, null);
        CheckoutInfo checkoutInfo = refHelper.getCheckoutInfo(git, settings.getRef(), settings.getCommit());
        git.checkout(checkoutInfo.getRef(), checkoutInfo.getStartPoint());
        if (settings.getSubmodule()) {
            git.submoduleSync(settings.getNestedSubmodules());
            git.submoduleUpdate(settings.getFetchDepth(), settings.getNestedSubmodules());
            git.submoduleForeach("git config --local gc.auto 0", settings.getNestedSubmodules());
        }
        authHelper.removeGlobalConfig();
    }
}

