/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.ObjectTypeHandler;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class UnknownTypeHandler
extends BaseTypeHandler<Object> {
    private static final ObjectTypeHandler OBJECT_TYPE_HANDLER = new ObjectTypeHandler();
    private final Configuration config;
    private final Supplier<TypeHandlerRegistry> typeHandlerRegistrySupplier;

    public UnknownTypeHandler(Configuration configuration) {
        this.config = configuration;
        this.typeHandlerRegistrySupplier = configuration::getTypeHandlerRegistry;
    }

    @Deprecated
    public UnknownTypeHandler(TypeHandlerRegistry typeHandlerRegistry) {
        this.config = new Configuration();
        this.typeHandlerRegistrySupplier = () -> typeHandlerRegistry;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        TypeHandler<?> handler2 = this.resolveTypeHandler(parameter, jdbcType);
        handler2.setParameter(ps, i, parameter, jdbcType);
    }

    @Override
    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        TypeHandler<?> handler2 = this.resolveTypeHandler(rs, columnName);
        return handler2.getResult(rs, columnName);
    }

    @Override
    public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        ObjectTypeHandler handler2 = this.resolveTypeHandler(rs.getMetaData(), columnIndex);
        if (handler2 == null || handler2 instanceof UnknownTypeHandler) {
            handler2 = OBJECT_TYPE_HANDLER;
        }
        return handler2.getResult(rs, columnIndex);
    }

    @Override
    public Object getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return cs.getObject(columnIndex);
    }

    private TypeHandler<?> resolveTypeHandler(Object parameter, JdbcType jdbcType) {
        TypeHandler<Object> handler2;
        if (parameter == null) {
            handler2 = OBJECT_TYPE_HANDLER;
        } else {
            handler2 = this.typeHandlerRegistrySupplier.get().getTypeHandler(parameter.getClass(), jdbcType);
            if (handler2 == null || handler2 instanceof UnknownTypeHandler) {
                handler2 = OBJECT_TYPE_HANDLER;
            }
        }
        return handler2;
    }

    private TypeHandler<?> resolveTypeHandler(ResultSet rs, String column2) {
        try {
            HashMap<String, Integer> columnIndexLookup = new HashMap<String, Integer>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int count2 = rsmd.getColumnCount();
            boolean useColumnLabel = this.config.isUseColumnLabel();
            for (int i = 1; i <= count2; ++i) {
                String name = useColumnLabel ? rsmd.getColumnLabel(i) : rsmd.getColumnName(i);
                columnIndexLookup.put(name, i);
            }
            Integer columnIndex = (Integer)columnIndexLookup.get(column2);
            TypeHandler<Object> handler2 = null;
            if (columnIndex != null) {
                handler2 = this.resolveTypeHandler(rsmd, columnIndex);
            }
            if (handler2 == null || handler2 instanceof UnknownTypeHandler) {
                handler2 = OBJECT_TYPE_HANDLER;
            }
            return handler2;
        }
        catch (SQLException e) {
            throw new TypeException("Error determining JDBC type for column " + column2 + ".  Cause: " + e, e);
        }
    }

    private TypeHandler<?> resolveTypeHandler(ResultSetMetaData rsmd, Integer columnIndex) {
        TypeHandler<?> handler2 = null;
        JdbcType jdbcType = this.safeGetJdbcTypeForColumn(rsmd, columnIndex);
        Class<?> javaType = this.safeGetClassForColumn(rsmd, columnIndex);
        if (javaType != null && jdbcType != null) {
            handler2 = this.typeHandlerRegistrySupplier.get().getTypeHandler(javaType, jdbcType);
        } else if (javaType != null) {
            handler2 = this.typeHandlerRegistrySupplier.get().getTypeHandler(javaType);
        } else if (jdbcType != null) {
            handler2 = this.typeHandlerRegistrySupplier.get().getTypeHandler(jdbcType);
        }
        return handler2;
    }

    private JdbcType safeGetJdbcTypeForColumn(ResultSetMetaData rsmd, Integer columnIndex) {
        try {
            return JdbcType.forCode(rsmd.getColumnType(columnIndex));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Class<?> safeGetClassForColumn(ResultSetMetaData rsmd, Integer columnIndex) {
        try {
            return Resources.classForName(rsmd.getColumnClassName(columnIndex));
        }
        catch (Exception e) {
            return null;
        }
    }
}

