/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class FloatTypeHandler
extends BaseTypeHandler<Float> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Float parameter, JdbcType jdbcType) throws SQLException {
        ps.setFloat(i, parameter.floatValue());
    }

    @Override
    public Float getNullableResult(ResultSet rs, String columnName) throws SQLException {
        float result2 = rs.getFloat(columnName);
        return result2 == 0.0f && rs.wasNull() ? null : Float.valueOf(result2);
    }

    @Override
    public Float getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        float result2 = rs.getFloat(columnIndex);
        return result2 == 0.0f && rs.wasNull() ? null : Float.valueOf(result2);
    }

    @Override
    public Float getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        float result2 = cs.getFloat(columnIndex);
        return result2 == 0.0f && cs.wasNull() ? null : Float.valueOf(result2);
    }
}

