/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.session.defaults;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.result.DefaultMapResultHandler;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.ParamNameResolver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class DefaultSqlSession
implements SqlSession {
    private final Configuration configuration;
    private final Executor executor;
    private final boolean autoCommit;
    private boolean dirty;
    private List<Cursor<?>> cursorList;

    public DefaultSqlSession(Configuration configuration, Executor executor, boolean autoCommit) {
        this.configuration = configuration;
        this.executor = executor;
        this.dirty = false;
        this.autoCommit = autoCommit;
    }

    public DefaultSqlSession(Configuration configuration, Executor executor) {
        this(configuration, executor, false);
    }

    @Override
    public <T> T selectOne(String statement2) {
        return this.selectOne(statement2, null);
    }

    @Override
    public <T> T selectOne(String statement2, Object parameter) {
        List list = this.selectList(statement2, parameter);
        if (list.size() == 1) {
            return (T)list.get(0);
        }
        if (list.size() > 1) {
            throw new TooManyResultsException("Expected one result (or null) to be returned by selectOne(), but found: " + list.size());
        }
        return null;
    }

    @Override
    public <K, V> Map<K, V> selectMap(String statement2, String mapKey) {
        return this.selectMap(statement2, null, mapKey, RowBounds.DEFAULT);
    }

    @Override
    public <K, V> Map<K, V> selectMap(String statement2, Object parameter, String mapKey) {
        return this.selectMap(statement2, parameter, mapKey, RowBounds.DEFAULT);
    }

    @Override
    public <K, V> Map<K, V> selectMap(String statement2, Object parameter, String mapKey, RowBounds rowBounds) {
        List list = this.selectList(statement2, parameter, rowBounds);
        DefaultMapResultHandler mapResultHandler = new DefaultMapResultHandler(mapKey, this.configuration.getObjectFactory(), this.configuration.getObjectWrapperFactory(), this.configuration.getReflectorFactory());
        DefaultResultContext context2 = new DefaultResultContext();
        for (Object o : list) {
            context2.nextResultObject(o);
            mapResultHandler.handleResult(context2);
        }
        return mapResultHandler.getMappedResults();
    }

    @Override
    public <T> Cursor<T> selectCursor(String statement2) {
        return this.selectCursor(statement2, null);
    }

    @Override
    public <T> Cursor<T> selectCursor(String statement2, Object parameter) {
        return this.selectCursor(statement2, parameter, RowBounds.DEFAULT);
    }

    @Override
    public <T> Cursor<T> selectCursor(String statement2, Object parameter, RowBounds rowBounds) {
        try {
            MappedStatement ms = this.configuration.getMappedStatement(statement2);
            Cursor cursor = this.executor.queryCursor(ms, this.wrapCollection(parameter), rowBounds);
            this.registerCursor(cursor);
            Cursor cursor2 = cursor;
            return cursor2;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException("Error querying database.  Cause: " + e, e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    @Override
    public <E> List<E> selectList(String statement2) {
        return this.selectList(statement2, null);
    }

    @Override
    public <E> List<E> selectList(String statement2, Object parameter) {
        return this.selectList(statement2, parameter, RowBounds.DEFAULT);
    }

    @Override
    public <E> List<E> selectList(String statement2, Object parameter, RowBounds rowBounds) {
        return this.selectList(statement2, parameter, rowBounds, Executor.NO_RESULT_HANDLER);
    }

    private <E> List<E> selectList(String statement2, Object parameter, RowBounds rowBounds, ResultHandler handler2) {
        try {
            MappedStatement ms = this.configuration.getMappedStatement(statement2);
            List list = this.executor.query(ms, this.wrapCollection(parameter), rowBounds, handler2);
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException("Error querying database.  Cause: " + e, e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    @Override
    public void select(String statement2, Object parameter, ResultHandler handler2) {
        this.select(statement2, parameter, RowBounds.DEFAULT, handler2);
    }

    @Override
    public void select(String statement2, ResultHandler handler2) {
        this.select(statement2, null, RowBounds.DEFAULT, handler2);
    }

    @Override
    public void select(String statement2, Object parameter, RowBounds rowBounds, ResultHandler handler2) {
        this.selectList(statement2, parameter, rowBounds, handler2);
    }

    @Override
    public int insert(String statement2) {
        return this.insert(statement2, null);
    }

    @Override
    public int insert(String statement2, Object parameter) {
        return this.update(statement2, parameter);
    }

    @Override
    public int update(String statement2) {
        return this.update(statement2, null);
    }

    @Override
    public int update(String statement2, Object parameter) {
        try {
            this.dirty = true;
            MappedStatement ms = this.configuration.getMappedStatement(statement2);
            int n = this.executor.update(ms, this.wrapCollection(parameter));
            return n;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException("Error updating database.  Cause: " + e, e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    @Override
    public int delete(String statement2) {
        return this.update(statement2, null);
    }

    @Override
    public int delete(String statement2, Object parameter) {
        return this.update(statement2, parameter);
    }

    @Override
    public void commit() {
        this.commit(false);
    }

    @Override
    public void commit(boolean force) {
        try {
            this.executor.commit(this.isCommitOrRollbackRequired(force));
            this.dirty = false;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException("Error committing transaction.  Cause: " + e, e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    @Override
    public void rollback() {
        this.rollback(false);
    }

    @Override
    public void rollback(boolean force) {
        try {
            this.executor.rollback(this.isCommitOrRollbackRequired(force));
            this.dirty = false;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException("Error rolling back transaction.  Cause: " + e, e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    @Override
    public List<BatchResult> flushStatements() {
        try {
            List<BatchResult> list = this.executor.flushStatements();
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException("Error flushing statements.  Cause: " + e, e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    @Override
    public void close() {
        try {
            this.executor.close(this.isCommitOrRollbackRequired(false));
            this.closeCursors();
            this.dirty = false;
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    private void closeCursors() {
        if (this.cursorList != null && !this.cursorList.isEmpty()) {
            for (Cursor<?> cursor : this.cursorList) {
                try {
                    cursor.close();
                }
                catch (IOException e) {
                    throw ExceptionFactory.wrapException("Error closing cursor.  Cause: " + e, e);
                }
            }
            this.cursorList.clear();
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public <T> T getMapper(Class<T> type2) {
        return this.configuration.getMapper(type2, this);
    }

    @Override
    public Connection getConnection() {
        try {
            return this.executor.getTransaction().getConnection();
        }
        catch (SQLException e) {
            throw ExceptionFactory.wrapException("Error getting a new connection.  Cause: " + e, e);
        }
    }

    @Override
    public void clearCache() {
        this.executor.clearLocalCache();
    }

    private <T> void registerCursor(Cursor<T> cursor) {
        if (this.cursorList == null) {
            this.cursorList = new ArrayList();
        }
        this.cursorList.add(cursor);
    }

    private boolean isCommitOrRollbackRequired(boolean force) {
        return !this.autoCommit && this.dirty || force;
    }

    private Object wrapCollection(Object object) {
        return ParamNameResolver.wrapToMapIfCollection(object, null);
    }

    @Deprecated
    public static class StrictMap<V>
    extends HashMap<String, V> {
        private static final long serialVersionUID = -5741767162221585340L;

        @Override
        public V get(Object key) {
            if (!super.containsKey(key)) {
                throw new BindingException("Parameter '" + key + "' not found. Available parameters are " + this.keySet());
            }
            return super.get(key);
        }
    }
}

