/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;

public class SqlSessionFactoryBuilder {
    public SqlSessionFactory build(Reader reader) {
        return this.build(reader, null, null);
    }

    public SqlSessionFactory build(Reader reader, String environment) {
        return this.build(reader, environment, null);
    }

    public SqlSessionFactory build(Reader reader, Properties properties2) {
        return this.build(reader, null, properties2);
    }

    public SqlSessionFactory build(Reader reader, String environment, Properties properties2) {
        try {
            XMLConfigBuilder parser = new XMLConfigBuilder(reader, environment, properties2);
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException("Error building SqlSession.", e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public SqlSessionFactory build(InputStream inputStream2) {
        return this.build(inputStream2, null, null);
    }

    public SqlSessionFactory build(InputStream inputStream2, String environment) {
        return this.build(inputStream2, environment, null);
    }

    public SqlSessionFactory build(InputStream inputStream2, Properties properties2) {
        return this.build(inputStream2, null, properties2);
    }

    public SqlSessionFactory build(InputStream inputStream2, String environment, Properties properties2) {
        try {
            XMLConfigBuilder parser = new XMLConfigBuilder(inputStream2, environment, properties2);
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException("Error building SqlSession.", e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {}
        }
    }

    public SqlSessionFactory build(Configuration config2) {
        return new DefaultSqlSessionFactory(config2);
    }
}

