/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.xmltags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.ChooseSqlNode;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.ForEachSqlNode;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SetSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.scripting.xmltags.VarDeclSqlNode;
import org.apache.ibatis.scripting.xmltags.WhereSqlNode;
import org.apache.ibatis.session.Configuration;
import org.w3c.dom.NodeList;

public class XMLScriptBuilder
extends BaseBuilder {
    private final XNode context;
    private boolean isDynamic;
    private final Class<?> parameterType;
    private final Map<String, NodeHandler> nodeHandlerMap = new HashMap<String, NodeHandler>();

    public XMLScriptBuilder(Configuration configuration, XNode context2) {
        this(configuration, context2, null);
    }

    public XMLScriptBuilder(Configuration configuration, XNode context2, Class<?> parameterType) {
        super(configuration);
        this.context = context2;
        this.parameterType = parameterType;
        this.initNodeHandlerMap();
    }

    private void initNodeHandlerMap() {
        this.nodeHandlerMap.put("trim", new TrimHandler());
        this.nodeHandlerMap.put("where", new WhereHandler());
        this.nodeHandlerMap.put("set", new SetHandler());
        this.nodeHandlerMap.put("foreach", new ForEachHandler());
        this.nodeHandlerMap.put("if", new IfHandler());
        this.nodeHandlerMap.put("choose", new ChooseHandler());
        this.nodeHandlerMap.put("when", new IfHandler());
        this.nodeHandlerMap.put("otherwise", new OtherwiseHandler());
        this.nodeHandlerMap.put("bind", new BindHandler());
    }

    public SqlSource parseScriptNode() {
        MixedSqlNode rootSqlNode = this.parseDynamicTags(this.context);
        SqlSource sqlSource = this.isDynamic ? new DynamicSqlSource(this.configuration, rootSqlNode) : new RawSqlSource(this.configuration, rootSqlNode, this.parameterType);
        return sqlSource;
    }

    protected MixedSqlNode parseDynamicTags(XNode node) {
        ArrayList<SqlNode> contents = new ArrayList<SqlNode>();
        NodeList children2 = node.getNode().getChildNodes();
        for (int i = 0; i < children2.getLength(); ++i) {
            XNode child = node.newXNode(children2.item(i));
            if (child.getNode().getNodeType() == 4 || child.getNode().getNodeType() == 3) {
                String data2 = child.getStringBody("");
                TextSqlNode textSqlNode = new TextSqlNode(data2);
                if (textSqlNode.isDynamic()) {
                    contents.add(textSqlNode);
                    this.isDynamic = true;
                    continue;
                }
                contents.add(new StaticTextSqlNode(data2));
                continue;
            }
            if (child.getNode().getNodeType() != 1) continue;
            String nodeName = child.getNode().getNodeName();
            NodeHandler handler2 = this.nodeHandlerMap.get(nodeName);
            if (handler2 == null) {
                throw new BuilderException("Unknown element <" + nodeName + "> in SQL statement.");
            }
            handler2.handleNode(child, contents);
            this.isDynamic = true;
        }
        return new MixedSqlNode(contents);
    }

    private class ChooseHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            ArrayList<SqlNode> whenSqlNodes = new ArrayList<SqlNode>();
            ArrayList<SqlNode> otherwiseSqlNodes = new ArrayList<SqlNode>();
            this.handleWhenOtherwiseNodes(nodeToHandle, whenSqlNodes, otherwiseSqlNodes);
            SqlNode defaultSqlNode = this.getDefaultSqlNode(otherwiseSqlNodes);
            ChooseSqlNode chooseSqlNode = new ChooseSqlNode(whenSqlNodes, defaultSqlNode);
            targetContents.add(chooseSqlNode);
        }

        private void handleWhenOtherwiseNodes(XNode chooseSqlNode, List<SqlNode> ifSqlNodes, List<SqlNode> defaultSqlNodes) {
            List<XNode> children2 = chooseSqlNode.getChildren();
            for (XNode child : children2) {
                String nodeName = child.getNode().getNodeName();
                NodeHandler handler2 = (NodeHandler)XMLScriptBuilder.this.nodeHandlerMap.get(nodeName);
                if (handler2 instanceof IfHandler) {
                    handler2.handleNode(child, ifSqlNodes);
                    continue;
                }
                if (!(handler2 instanceof OtherwiseHandler)) continue;
                handler2.handleNode(child, defaultSqlNodes);
            }
        }

        private SqlNode getDefaultSqlNode(List<SqlNode> defaultSqlNodes) {
            SqlNode defaultSqlNode = null;
            if (defaultSqlNodes.size() == 1) {
                defaultSqlNode = defaultSqlNodes.get(0);
            } else if (defaultSqlNodes.size() > 1) {
                throw new BuilderException("Too many default (otherwise) elements in choose statement.");
            }
            return defaultSqlNode;
        }
    }

    private class OtherwiseHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            targetContents.add(mixedSqlNode);
        }
    }

    private class IfHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String test2 = nodeToHandle.getStringAttribute("test");
            IfSqlNode ifSqlNode = new IfSqlNode(mixedSqlNode, test2);
            targetContents.add(ifSqlNode);
        }
    }

    private class ForEachHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String collection = nodeToHandle.getStringAttribute("collection");
            Boolean nullable = nodeToHandle.getBooleanAttribute("nullable");
            String item = nodeToHandle.getStringAttribute("item");
            String index = nodeToHandle.getStringAttribute("index");
            String open = nodeToHandle.getStringAttribute("open");
            String close2 = nodeToHandle.getStringAttribute("close");
            String separator = nodeToHandle.getStringAttribute("separator");
            ForEachSqlNode forEachSqlNode = new ForEachSqlNode(XMLScriptBuilder.this.configuration, mixedSqlNode, collection, nullable, index, item, open, close2, separator);
            targetContents.add(forEachSqlNode);
        }
    }

    private class SetHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            SetSqlNode set2 = new SetSqlNode(XMLScriptBuilder.this.configuration, mixedSqlNode);
            targetContents.add(set2);
        }
    }

    private class WhereHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            WhereSqlNode where = new WhereSqlNode(XMLScriptBuilder.this.configuration, mixedSqlNode);
            targetContents.add(where);
        }
    }

    private class TrimHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            MixedSqlNode mixedSqlNode = XMLScriptBuilder.this.parseDynamicTags(nodeToHandle);
            String prefix = nodeToHandle.getStringAttribute("prefix");
            String prefixOverrides = nodeToHandle.getStringAttribute("prefixOverrides");
            String suffix = nodeToHandle.getStringAttribute("suffix");
            String suffixOverrides = nodeToHandle.getStringAttribute("suffixOverrides");
            TrimSqlNode trim = new TrimSqlNode(XMLScriptBuilder.this.configuration, (SqlNode)mixedSqlNode, prefix, prefixOverrides, suffix, suffixOverrides);
            targetContents.add(trim);
        }
    }

    private class BindHandler
    implements NodeHandler {
        @Override
        public void handleNode(XNode nodeToHandle, List<SqlNode> targetContents) {
            String name = nodeToHandle.getStringAttribute("name");
            String expression = nodeToHandle.getStringAttribute("value");
            VarDeclSqlNode node = new VarDeclSqlNode(name, expression);
            targetContents.add(node);
        }
    }

    private static interface NodeHandler {
        public void handleNode(XNode var1, List<SqlNode> var2);
    }
}

