/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.xmltags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class TrimSqlNode
implements SqlNode {
    private final SqlNode contents;
    private final String prefix;
    private final String suffix;
    private final List<String> prefixesToOverride;
    private final List<String> suffixesToOverride;
    private final Configuration configuration;

    public TrimSqlNode(Configuration configuration, SqlNode contents, String prefix, String prefixesToOverride, String suffix, String suffixesToOverride) {
        this(configuration, contents, prefix, TrimSqlNode.parseOverrides(prefixesToOverride), suffix, TrimSqlNode.parseOverrides(suffixesToOverride));
    }

    protected TrimSqlNode(Configuration configuration, SqlNode contents, String prefix, List<String> prefixesToOverride, String suffix, List<String> suffixesToOverride) {
        this.contents = contents;
        this.prefix = prefix;
        this.prefixesToOverride = prefixesToOverride;
        this.suffix = suffix;
        this.suffixesToOverride = suffixesToOverride;
        this.configuration = configuration;
    }

    @Override
    public boolean apply(DynamicContext context2) {
        FilteredDynamicContext filteredDynamicContext = new FilteredDynamicContext(context2);
        boolean result2 = this.contents.apply(filteredDynamicContext);
        filteredDynamicContext.applyAll();
        return result2;
    }

    private static List<String> parseOverrides(String overrides) {
        if (overrides != null) {
            StringTokenizer parser = new StringTokenizer(overrides, "|", false);
            ArrayList<String> list = new ArrayList<String>(parser.countTokens());
            while (parser.hasMoreTokens()) {
                list.add(parser.nextToken().toUpperCase(Locale.ENGLISH));
            }
            return list;
        }
        return Collections.emptyList();
    }

    private class FilteredDynamicContext
    extends DynamicContext {
        private DynamicContext delegate;
        private boolean prefixApplied;
        private boolean suffixApplied;
        private StringBuilder sqlBuffer;

        public FilteredDynamicContext(DynamicContext delegate2) {
            super(TrimSqlNode.this.configuration, null);
            this.delegate = delegate2;
            this.prefixApplied = false;
            this.suffixApplied = false;
            this.sqlBuffer = new StringBuilder();
        }

        public void applyAll() {
            this.sqlBuffer = new StringBuilder(this.sqlBuffer.toString().trim());
            String trimmedUppercaseSql = this.sqlBuffer.toString().toUpperCase(Locale.ENGLISH);
            if (trimmedUppercaseSql.length() > 0) {
                this.applyPrefix(this.sqlBuffer, trimmedUppercaseSql);
                this.applySuffix(this.sqlBuffer, trimmedUppercaseSql);
            }
            this.delegate.appendSql(this.sqlBuffer.toString());
        }

        @Override
        public Map<String, Object> getBindings() {
            return this.delegate.getBindings();
        }

        @Override
        public void bind(String name, Object value) {
            this.delegate.bind(name, value);
        }

        @Override
        public int getUniqueNumber() {
            return this.delegate.getUniqueNumber();
        }

        @Override
        public void appendSql(String sql) {
            this.sqlBuffer.append(sql);
        }

        @Override
        public String getSql() {
            return this.delegate.getSql();
        }

        private void applyPrefix(StringBuilder sql, String trimmedUppercaseSql) {
            if (!this.prefixApplied) {
                this.prefixApplied = true;
                if (TrimSqlNode.this.prefixesToOverride != null) {
                    for (String toRemove : TrimSqlNode.this.prefixesToOverride) {
                        if (!trimmedUppercaseSql.startsWith(toRemove)) continue;
                        sql.delete(0, toRemove.trim().length());
                        break;
                    }
                }
                if (TrimSqlNode.this.prefix != null) {
                    sql.insert(0, " ");
                    sql.insert(0, TrimSqlNode.this.prefix);
                }
            }
        }

        private void applySuffix(StringBuilder sql, String trimmedUppercaseSql) {
            if (!this.suffixApplied) {
                this.suffixApplied = true;
                if (TrimSqlNode.this.suffixesToOverride != null) {
                    for (String toRemove : TrimSqlNode.this.suffixesToOverride) {
                        if (!trimmedUppercaseSql.endsWith(toRemove) && !trimmedUppercaseSql.endsWith(toRemove.trim())) continue;
                        int start2 = sql.length() - toRemove.trim().length();
                        int end2 = sql.length();
                        sql.delete(start2, end2);
                        break;
                    }
                }
                if (TrimSqlNode.this.suffix != null) {
                    sql.append(" ");
                    sql.append(TrimSqlNode.this.suffix);
                }
            }
        }
    }
}

