/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.xmltags;

import java.util.regex.Pattern;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.scripting.ScriptingException;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.OgnlCache;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.type.SimpleTypeRegistry;

public class TextSqlNode
implements SqlNode {
    private final String text;
    private final Pattern injectionFilter;

    public TextSqlNode(String text) {
        this(text, null);
    }

    public TextSqlNode(String text, Pattern injectionFilter) {
        this.text = text;
        this.injectionFilter = injectionFilter;
    }

    public boolean isDynamic() {
        DynamicCheckerTokenParser checker = new DynamicCheckerTokenParser();
        GenericTokenParser parser = this.createParser(checker);
        parser.parse(this.text);
        return checker.isDynamic();
    }

    @Override
    public boolean apply(DynamicContext context2) {
        GenericTokenParser parser = this.createParser(new BindingTokenParser(context2, this.injectionFilter));
        context2.appendSql(parser.parse(this.text));
        return true;
    }

    private GenericTokenParser createParser(TokenHandler handler2) {
        return new GenericTokenParser("${", "}", handler2);
    }

    private static class DynamicCheckerTokenParser
    implements TokenHandler {
        private boolean isDynamic;

        public boolean isDynamic() {
            return this.isDynamic;
        }

        @Override
        public String handleToken(String content2) {
            this.isDynamic = true;
            return null;
        }
    }

    private static class BindingTokenParser
    implements TokenHandler {
        private DynamicContext context;
        private Pattern injectionFilter;

        public BindingTokenParser(DynamicContext context2, Pattern injectionFilter) {
            this.context = context2;
            this.injectionFilter = injectionFilter;
        }

        @Override
        public String handleToken(String content2) {
            Object parameter = this.context.getBindings().get("_parameter");
            if (parameter == null) {
                this.context.getBindings().put("value", null);
            } else if (SimpleTypeRegistry.isSimpleType(parameter.getClass())) {
                this.context.getBindings().put("value", parameter);
            }
            Object value = OgnlCache.getValue(content2, this.context.getBindings());
            String srtValue = value == null ? "" : String.valueOf(value);
            this.checkInjection(srtValue);
            return srtValue;
        }

        private void checkInjection(String value) {
            if (this.injectionFilter != null && !this.injectionFilter.matcher(value).matches()) {
                throw new ScriptingException("Invalid input. Please conform to regex" + this.injectionFilter.pattern());
            }
        }
    }
}

