/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.xmltags;

import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.ExpressionEvaluator;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class ForEachSqlNode
implements SqlNode {
    public static final String ITEM_PREFIX = "__frch_";
    private final ExpressionEvaluator evaluator = new ExpressionEvaluator();
    private final String collectionExpression;
    private final Boolean nullable;
    private final SqlNode contents;
    private final String open;
    private final String close;
    private final String separator;
    private final String item;
    private final String index;
    private final Configuration configuration;

    @Deprecated
    public ForEachSqlNode(Configuration configuration, SqlNode contents, String collectionExpression, String index, String item, String open, String close2, String separator) {
        this(configuration, contents, collectionExpression, null, index, item, open, close2, separator);
    }

    public ForEachSqlNode(Configuration configuration, SqlNode contents, String collectionExpression, Boolean nullable, String index, String item, String open, String close2, String separator) {
        this.collectionExpression = collectionExpression;
        this.nullable = nullable;
        this.contents = contents;
        this.open = open;
        this.close = close2;
        this.separator = separator;
        this.index = index;
        this.item = item;
        this.configuration = configuration;
    }

    @Override
    public boolean apply(DynamicContext context2) {
        Map<String, Object> bindings = context2.getBindings();
        Iterable<?> iterable = this.evaluator.evaluateIterable(this.collectionExpression, bindings, Optional.ofNullable(this.nullable).orElseGet(this.configuration::isNullableOnForEach));
        if (iterable == null || !iterable.iterator().hasNext()) {
            return true;
        }
        boolean first2 = true;
        this.applyOpen(context2);
        int i = 0;
        for (Object o : iterable) {
            DynamicContext oldContext = context2;
            context2 = first2 || this.separator == null ? new PrefixedContext(context2, "") : new PrefixedContext(context2, this.separator);
            int uniqueNumber = context2.getUniqueNumber();
            if (o instanceof Map.Entry) {
                Map.Entry mapEntry = (Map.Entry)o;
                this.applyIndex(context2, mapEntry.getKey(), uniqueNumber);
                this.applyItem(context2, mapEntry.getValue(), uniqueNumber);
            } else {
                this.applyIndex(context2, i, uniqueNumber);
                this.applyItem(context2, o, uniqueNumber);
            }
            this.contents.apply(new FilteredDynamicContext(this.configuration, context2, this.index, this.item, uniqueNumber));
            if (first2) {
                first2 = !((PrefixedContext)context2).isPrefixApplied();
            }
            context2 = oldContext;
            ++i;
        }
        this.applyClose(context2);
        context2.getBindings().remove(this.item);
        context2.getBindings().remove(this.index);
        return true;
    }

    private void applyIndex(DynamicContext context2, Object o, int i) {
        if (this.index != null) {
            context2.bind(this.index, o);
            context2.bind(ForEachSqlNode.itemizeItem(this.index, i), o);
        }
    }

    private void applyItem(DynamicContext context2, Object o, int i) {
        if (this.item != null) {
            context2.bind(this.item, o);
            context2.bind(ForEachSqlNode.itemizeItem(this.item, i), o);
        }
    }

    private void applyOpen(DynamicContext context2) {
        if (this.open != null) {
            context2.appendSql(this.open);
        }
    }

    private void applyClose(DynamicContext context2) {
        if (this.close != null) {
            context2.appendSql(this.close);
        }
    }

    private static String itemizeItem(String item, int i) {
        return ITEM_PREFIX + item + "_" + i;
    }

    private class PrefixedContext
    extends DynamicContext {
        private final DynamicContext delegate;
        private final String prefix;
        private boolean prefixApplied;

        public PrefixedContext(DynamicContext delegate2, String prefix) {
            super(ForEachSqlNode.this.configuration, null);
            this.delegate = delegate2;
            this.prefix = prefix;
            this.prefixApplied = false;
        }

        public boolean isPrefixApplied() {
            return this.prefixApplied;
        }

        @Override
        public Map<String, Object> getBindings() {
            return this.delegate.getBindings();
        }

        @Override
        public void bind(String name, Object value) {
            this.delegate.bind(name, value);
        }

        @Override
        public void appendSql(String sql) {
            if (!this.prefixApplied && sql != null && sql.trim().length() > 0) {
                this.delegate.appendSql(this.prefix);
                this.prefixApplied = true;
            }
            this.delegate.appendSql(sql);
        }

        @Override
        public String getSql() {
            return this.delegate.getSql();
        }

        @Override
        public int getUniqueNumber() {
            return this.delegate.getUniqueNumber();
        }
    }

    private static class FilteredDynamicContext
    extends DynamicContext {
        private final DynamicContext delegate;
        private final int index;
        private final String itemIndex;
        private final String item;

        public FilteredDynamicContext(Configuration configuration, DynamicContext delegate2, String itemIndex, String item, int i) {
            super(configuration, null);
            this.delegate = delegate2;
            this.index = i;
            this.itemIndex = itemIndex;
            this.item = item;
        }

        @Override
        public Map<String, Object> getBindings() {
            return this.delegate.getBindings();
        }

        @Override
        public void bind(String name, Object value) {
            this.delegate.bind(name, value);
        }

        @Override
        public String getSql() {
            return this.delegate.getSql();
        }

        @Override
        public void appendSql(String sql) {
            GenericTokenParser parser = new GenericTokenParser("#{", "}", content2 -> {
                String newContent = content2.replaceFirst("^\\s*" + this.item + "(?![^.,:\\s])", ForEachSqlNode.itemizeItem(this.item, this.index));
                if (this.itemIndex != null && newContent.equals(content2)) {
                    newContent = content2.replaceFirst("^\\s*" + this.itemIndex + "(?![^.,:\\s])", ForEachSqlNode.itemizeItem(this.itemIndex, this.index));
                }
                return "#{" + newContent + "}";
            });
            this.delegate.appendSql(parser.parse(sql));
        }

        @Override
        public int getUniqueNumber() {
            return this.delegate.getUniqueNumber();
        }
    }
}

