/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.reflection.invoker.Invoker;

public class MethodInvoker
implements Invoker {
    private final Class<?> type;
    private final Method method;

    public MethodInvoker(Method method) {
        this.method = method;
        this.type = method.getParameterTypes().length == 1 ? method.getParameterTypes()[0] : method.getReturnType();
    }

    @Override
    public Object invoke(Object target, Object[] args2) throws IllegalAccessException, InvocationTargetException {
        try {
            return this.method.invoke(target, args2);
        }
        catch (IllegalAccessException e) {
            if (Reflector.canControlMemberAccessible()) {
                this.method.setAccessible(true);
                return this.method.invoke(target, args2);
            }
            throw e;
        }
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }
}

