/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection.factory;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.ReflectionException;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.reflection.factory.ObjectFactory;

public class DefaultObjectFactory
implements ObjectFactory,
Serializable {
    private static final long serialVersionUID = -8855120656740914948L;

    @Override
    public <T> T create(Class<T> type2) {
        return this.create(type2, null, null);
    }

    @Override
    public <T> T create(Class<T> type2, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
        Class<?> classToCreate = this.resolveInterface(type2);
        return (T)this.instantiateClass(classToCreate, constructorArgTypes, constructorArgs);
    }

    private <T> T instantiateClass(Class<T> type2, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
        try {
            if (constructorArgTypes == null || constructorArgs == null) {
                Constructor<T> constructor = type2.getDeclaredConstructor(new Class[0]);
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException e) {
                    if (Reflector.canControlMemberAccessible()) {
                        constructor.setAccessible(true);
                        return constructor.newInstance(new Object[0]);
                    }
                    throw e;
                }
            }
            Constructor<T> constructor = type2.getDeclaredConstructor(constructorArgTypes.toArray(new Class[0]));
            try {
                return constructor.newInstance(constructorArgs.toArray(new Object[0]));
            }
            catch (IllegalAccessException e) {
                if (Reflector.canControlMemberAccessible()) {
                    constructor.setAccessible(true);
                    return constructor.newInstance(constructorArgs.toArray(new Object[0]));
                }
                throw e;
            }
        }
        catch (Exception e) {
            String argTypes = Optional.ofNullable(constructorArgTypes).orElseGet(Collections::emptyList).stream().map(Class::getSimpleName).collect(Collectors.joining(","));
            String argValues = Optional.ofNullable(constructorArgs).orElseGet(Collections::emptyList).stream().map(String::valueOf).collect(Collectors.joining(","));
            throw new ReflectionException("Error instantiating " + type2 + " with invalid types (" + argTypes + ") or values (" + argValues + "). Cause: " + e, e);
        }
    }

    protected Class<?> resolveInterface(Class<?> type2) {
        Class classToCreate = type2 == List.class || type2 == Collection.class || type2 == Iterable.class ? ArrayList.class : (type2 == Map.class ? HashMap.class : (type2 == SortedSet.class ? TreeSet.class : (type2 == Set.class ? HashSet.class : type2)));
        return classToCreate;
    }

    @Override
    public <T> boolean isCollection(Class<T> type2) {
        return Collection.class.isAssignableFrom(type2);
    }
}

