/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.plugin;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.PluginException;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.util.MapUtil;

public class Plugin
implements InvocationHandler {
    private final Object target;
    private final Interceptor interceptor;
    private final Map<Class<?>, Set<Method>> signatureMap;

    private Plugin(Object target, Interceptor interceptor, Map<Class<?>, Set<Method>> signatureMap) {
        this.target = target;
        this.interceptor = interceptor;
        this.signatureMap = signatureMap;
    }

    public static Object wrap(Object target, Interceptor interceptor) {
        Map<Class<?>, Set<Method>> signatureMap = Plugin.getSignatureMap(interceptor);
        Class<?> type2 = target.getClass();
        Class<?>[] interfaces = Plugin.getAllInterfaces(type2, signatureMap);
        if (interfaces.length > 0) {
            return Proxy.newProxyInstance(type2.getClassLoader(), interfaces, (InvocationHandler)new Plugin(target, interceptor, signatureMap));
        }
        return target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        try {
            Set<Method> methods2 = this.signatureMap.get(method.getDeclaringClass());
            if (methods2 != null && methods2.contains(method)) {
                return this.interceptor.intercept(new Invocation(this.target, method, args2));
            }
            return method.invoke(this.target, args2);
        }
        catch (Exception e) {
            throw ExceptionUtil.unwrapThrowable(e);
        }
    }

    private static Map<Class<?>, Set<Method>> getSignatureMap(Interceptor interceptor) {
        Intercepts interceptsAnnotation = interceptor.getClass().getAnnotation(Intercepts.class);
        if (interceptsAnnotation == null) {
            throw new PluginException("No @Intercepts annotation was found in interceptor " + interceptor.getClass().getName());
        }
        Signature[] sigs = interceptsAnnotation.value();
        HashMap signatureMap = new HashMap();
        for (Signature sig : sigs) {
            Set methods2 = MapUtil.computeIfAbsent(signatureMap, sig.type(), k -> new HashSet());
            try {
                Method method = sig.type().getMethod(sig.method(), sig.args());
                methods2.add(method);
            }
            catch (NoSuchMethodException e) {
                throw new PluginException("Could not find method on " + sig.type() + " named " + sig.method() + ". Cause: " + e, e);
            }
        }
        return signatureMap;
    }

    private static Class<?>[] getAllInterfaces(Class<?> type2, Map<Class<?>, Set<Method>> signatureMap) {
        HashSet interfaces = new HashSet();
        while (type2 != null) {
            for (Class<?> c : type2.getInterfaces()) {
                if (!signatureMap.containsKey(c)) continue;
                interfaces.add(c);
            }
            type2 = type2.getSuperclass();
        }
        return interfaces.toArray(new Class[0]);
    }
}

