/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.parsing.XPathParser;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XNode {
    private final Node node;
    private final String name;
    private final String body;
    private final Properties attributes;
    private final Properties variables;
    private final XPathParser xpathParser;

    public XNode(XPathParser xpathParser, Node node, Properties variables) {
        this.xpathParser = xpathParser;
        this.node = node;
        this.name = node.getNodeName();
        this.variables = variables;
        this.attributes = this.parseAttributes(node);
        this.body = this.parseBody(node);
    }

    public XNode newXNode(Node node) {
        return new XNode(this.xpathParser, node, this.variables);
    }

    public XNode getParent() {
        Node parent = this.node.getParentNode();
        if (!(parent instanceof Element)) {
            return null;
        }
        return new XNode(this.xpathParser, parent, this.variables);
    }

    public String getPath() {
        StringBuilder builder2 = new StringBuilder();
        Node current = this.node;
        while (current instanceof Element) {
            if (current != this.node) {
                builder2.insert(0, "/");
            }
            builder2.insert(0, current.getNodeName());
            current = current.getParentNode();
        }
        return builder2.toString();
    }

    public String getValueBasedIdentifier() {
        StringBuilder builder2 = new StringBuilder();
        for (XNode current = this; current != null; current = current.getParent()) {
            String value;
            if (current != this) {
                builder2.insert(0, "_");
            }
            if ((value = current.getStringAttribute("id", current.getStringAttribute("value", current.getStringAttribute("property", (String)null)))) != null) {
                value = value.replace('.', '_');
                builder2.insert(0, "]");
                builder2.insert(0, value);
                builder2.insert(0, "[");
            }
            builder2.insert(0, current.getName());
        }
        return builder2.toString();
    }

    public String evalString(String expression) {
        return this.xpathParser.evalString(this.node, expression);
    }

    public Boolean evalBoolean(String expression) {
        return this.xpathParser.evalBoolean(this.node, expression);
    }

    public Double evalDouble(String expression) {
        return this.xpathParser.evalDouble(this.node, expression);
    }

    public List<XNode> evalNodes(String expression) {
        return this.xpathParser.evalNodes(this.node, expression);
    }

    public XNode evalNode(String expression) {
        return this.xpathParser.evalNode(this.node, expression);
    }

    public Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.name;
    }

    public String getStringBody() {
        return this.getStringBody(null);
    }

    public String getStringBody(String def) {
        return this.body == null ? def : this.body;
    }

    public Boolean getBooleanBody() {
        return this.getBooleanBody(null);
    }

    public Boolean getBooleanBody(Boolean def) {
        return this.body == null ? def : Boolean.valueOf(this.body);
    }

    public Integer getIntBody() {
        return this.getIntBody(null);
    }

    public Integer getIntBody(Integer def) {
        return this.body == null ? def : Integer.valueOf(this.body);
    }

    public Long getLongBody() {
        return this.getLongBody(null);
    }

    public Long getLongBody(Long def) {
        return this.body == null ? def : Long.valueOf(this.body);
    }

    public Double getDoubleBody() {
        return this.getDoubleBody(null);
    }

    public Double getDoubleBody(Double def) {
        return this.body == null ? def : Double.valueOf(this.body);
    }

    public Float getFloatBody() {
        return this.getFloatBody(null);
    }

    public Float getFloatBody(Float def) {
        return this.body == null ? def : Float.valueOf(this.body);
    }

    public <T extends Enum<T>> T getEnumAttribute(Class<T> enumType, String name) {
        return this.getEnumAttribute(enumType, name, null);
    }

    public <T extends Enum<T>> T getEnumAttribute(Class<T> enumType, String name, T def) {
        String value = this.getStringAttribute(name);
        return value == null ? def : Enum.valueOf(enumType, value);
    }

    public String getStringAttribute(String name, Supplier<String> defSupplier) {
        String value = this.attributes.getProperty(name);
        return value == null ? defSupplier.get() : value;
    }

    public String getStringAttribute(String name) {
        return this.getStringAttribute(name, (String)null);
    }

    public String getStringAttribute(String name, String def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : value;
    }

    public Boolean getBooleanAttribute(String name) {
        return this.getBooleanAttribute(name, null);
    }

    public Boolean getBooleanAttribute(String name, Boolean def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : Boolean.valueOf(value);
    }

    public Integer getIntAttribute(String name) {
        return this.getIntAttribute(name, null);
    }

    public Integer getIntAttribute(String name, Integer def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : Integer.valueOf(value);
    }

    public Long getLongAttribute(String name) {
        return this.getLongAttribute(name, null);
    }

    public Long getLongAttribute(String name, Long def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : Long.valueOf(value);
    }

    public Double getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, null);
    }

    public Double getDoubleAttribute(String name, Double def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : Double.valueOf(value);
    }

    public Float getFloatAttribute(String name) {
        return this.getFloatAttribute(name, null);
    }

    public Float getFloatAttribute(String name, Float def) {
        String value = this.attributes.getProperty(name);
        return value == null ? def : Float.valueOf(value);
    }

    public List<XNode> getChildren() {
        ArrayList<XNode> children2 = new ArrayList<XNode>();
        NodeList nodeList = this.node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                children2.add(new XNode(this.xpathParser, node, this.variables));
            }
        }
        return children2;
    }

    public Properties getChildrenAsProperties() {
        Properties properties2 = new Properties();
        for (XNode child : this.getChildren()) {
            String name = child.getStringAttribute("name");
            String value = child.getStringAttribute("value");
            if (name == null || value == null) continue;
            properties2.setProperty(name, value);
        }
        return properties2;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        this.toString(builder2, 0);
        return builder2.toString();
    }

    private void toString(StringBuilder builder2, int level) {
        builder2.append("<");
        builder2.append(this.name);
        for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
            builder2.append(" ");
            builder2.append(entry.getKey());
            builder2.append("=\"");
            builder2.append(entry.getValue());
            builder2.append("\"");
        }
        List<XNode> children2 = this.getChildren();
        if (!children2.isEmpty()) {
            builder2.append(">\n");
            for (XNode child : children2) {
                this.indent(builder2, level + 1);
                child.toString(builder2, level + 1);
            }
            this.indent(builder2, level);
            builder2.append("</");
            builder2.append(this.name);
            builder2.append(">");
        } else if (this.body != null) {
            builder2.append(">");
            builder2.append(this.body);
            builder2.append("</");
            builder2.append(this.name);
            builder2.append(">");
        } else {
            builder2.append("/>");
            this.indent(builder2, level);
        }
        builder2.append("\n");
    }

    private void indent(StringBuilder builder2, int level) {
        for (int i = 0; i < level; ++i) {
            builder2.append("    ");
        }
    }

    private Properties parseAttributes(Node n) {
        Properties attributes2 = new Properties();
        NamedNodeMap attributeNodes = n.getAttributes();
        if (attributeNodes != null) {
            for (int i = 0; i < attributeNodes.getLength(); ++i) {
                Node attribute = attributeNodes.item(i);
                String value = PropertyParser.parse(attribute.getNodeValue(), this.variables);
                attributes2.put(attribute.getNodeName(), value);
            }
        }
        return attributes2;
    }

    private String parseBody(Node node) {
        String data2 = this.getBodyData(node);
        if (data2 == null) {
            Node child;
            NodeList children2 = node.getChildNodes();
            for (int i = 0; i < children2.getLength() && (data2 = this.getBodyData(child = children2.item(i))) == null; ++i) {
            }
        }
        return data2;
    }

    private String getBodyData(Node child) {
        if (child.getNodeType() == 4 || child.getNodeType() == 3) {
            String data2 = ((CharacterData)child).getData();
            data2 = PropertyParser.parse(data2, this.variables);
            return data2;
        }
        return null;
    }
}

