/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.parsing;

import org.apache.ibatis.parsing.TokenHandler;

public class GenericTokenParser {
    private final String openToken;
    private final String closeToken;
    private final TokenHandler handler;

    public GenericTokenParser(String openToken, String closeToken, TokenHandler handler2) {
        this.openToken = openToken;
        this.closeToken = closeToken;
        this.handler = handler2;
    }

    public String parse(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        int start2 = text.indexOf(this.openToken);
        if (start2 == -1) {
            return text;
        }
        char[] src = text.toCharArray();
        int offset = 0;
        StringBuilder builder2 = new StringBuilder();
        StringBuilder expression = null;
        do {
            if (start2 > 0 && src[start2 - 1] == '\\') {
                builder2.append(src, offset, start2 - offset - 1).append(this.openToken);
                offset = start2 + this.openToken.length();
                continue;
            }
            if (expression == null) {
                expression = new StringBuilder();
            } else {
                expression.setLength(0);
            }
            builder2.append(src, offset, start2 - offset);
            offset = start2 + this.openToken.length();
            int end2 = text.indexOf(this.closeToken, offset);
            while (end2 > -1) {
                if (end2 > offset && src[end2 - 1] == '\\') {
                    expression.append(src, offset, end2 - offset - 1).append(this.closeToken);
                    offset = end2 + this.closeToken.length();
                    end2 = text.indexOf(this.closeToken, offset);
                    continue;
                }
                expression.append(src, offset, end2 - offset);
                break;
            }
            if (end2 == -1) {
                builder2.append(src, start2, src.length - start2);
                offset = src.length;
                continue;
            }
            builder2.append(this.handler.handleToken(expression.toString()));
            offset = end2 + this.closeToken.length();
        } while ((start2 = text.indexOf(this.openToken, offset)) > -1);
        if (offset < src.length) {
            builder2.append(src, offset, src.length - offset);
        }
        return builder2.toString();
    }
}

