/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.ibatis.ognl.Evaluation;
import org.apache.ibatis.ognl.EvaluationPool;
import org.apache.ibatis.ognl.InappropriateExpressionException;
import org.apache.ibatis.ognl.Node;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlParserTreeConstants;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.enhance.ExpressionAccessor;

public abstract class SimpleNode
implements Node,
Serializable {
    protected Node _parent;
    protected Node[] _children;
    protected int _id;
    protected OgnlParser _parser;
    private boolean _constantValueCalculated;
    private volatile boolean _hasConstantValue;
    private Object _constantValue;
    private ExpressionAccessor _accessor;

    public SimpleNode(int i) {
        this._id = i;
    }

    public SimpleNode(OgnlParser p, int i) {
        this(i);
        this._parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this._parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this._parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this._children == null) {
            this._children = new Node[i + 1];
        } else if (i >= this._children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this._children, 0, c, 0, this._children.length);
            this._children = c;
        }
        this._children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this._children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this._children == null ? 0 : this._children.length;
    }

    public String toString() {
        return OgnlParserTreeConstants.jjtNodeName[this._id];
    }

    public String toString(String prefix) {
        return prefix + OgnlParserTreeConstants.jjtNodeName[this._id] + " " + this.toString();
    }

    @Override
    public String toGetSourceString(OgnlContext context2, Object target) {
        return this.toString();
    }

    @Override
    public String toSetSourceString(OgnlContext context2, Object target) {
        return this.toString();
    }

    public void dump(PrintWriter writer2, String prefix) {
        writer2.println(this.toString(prefix));
        if (this._children != null) {
            for (int i = 0; i < this._children.length; ++i) {
                SimpleNode n = (SimpleNode)this._children[i];
                if (n == null) continue;
                n.dump(writer2, prefix + "  ");
            }
        }
    }

    public int getIndexInParent() {
        int result2 = -1;
        if (this._parent != null) {
            int icount = this._parent.jjtGetNumChildren();
            for (int i = 0; i < icount; ++i) {
                if (this._parent.jjtGetChild(i) != this) continue;
                result2 = i;
                break;
            }
        }
        return result2;
    }

    public Node getNextSibling() {
        int icount;
        Node result2 = null;
        int i = this.getIndexInParent();
        if (i >= 0 && i < (icount = this._parent.jjtGetNumChildren())) {
            result2 = this._parent.jjtGetChild(i + 1);
        }
        return result2;
    }

    protected Object evaluateGetValueBody(OgnlContext context2, Object source) throws OgnlException {
        context2.setCurrentObject(source);
        context2.setCurrentNode(this);
        if (!this._constantValueCalculated) {
            this._constantValueCalculated = true;
            boolean constant = this.isConstant(context2);
            if (constant) {
                this._constantValue = this.getValueBody(context2, source);
            }
            this._hasConstantValue = constant;
        }
        return this._hasConstantValue ? this._constantValue : this.getValueBody(context2, source);
    }

    protected void evaluateSetValueBody(OgnlContext context2, Object target, Object value) throws OgnlException {
        context2.setCurrentObject(target);
        context2.setCurrentNode(this);
        this.setValueBody(context2, target, value);
    }

    @Override
    public final Object getValue(OgnlContext context2, Object source) throws OgnlException {
        Object result2 = null;
        if (context2.getTraceEvaluations()) {
            EvaluationPool pool = OgnlRuntime.getEvaluationPool();
            Exception evalException = null;
            Evaluation evaluation = pool.create(this, source);
            context2.pushEvaluation(evaluation);
            try {
                result2 = this.evaluateGetValueBody(context2, source);
            }
            catch (OgnlException ex) {
                evalException = ex;
                throw ex;
            }
            catch (RuntimeException ex) {
                evalException = ex;
                throw ex;
            }
            finally {
                Evaluation eval = context2.popEvaluation();
                eval.setResult(result2);
                if (evalException != null) {
                    eval.setException(evalException);
                }
                if (evalException == null && context2.getRootEvaluation() == null && !context2.getKeepLastEvaluation()) {
                    pool.recycleAll(eval);
                }
            }
        } else {
            result2 = this.evaluateGetValueBody(context2, source);
        }
        return result2;
    }

    protected abstract Object getValueBody(OgnlContext var1, Object var2) throws OgnlException;

    @Override
    public final void setValue(OgnlContext context2, Object target, Object value) throws OgnlException {
        if (context2.getTraceEvaluations()) {
            EvaluationPool pool = OgnlRuntime.getEvaluationPool();
            Exception evalException = null;
            Evaluation evaluation = pool.create(this, target, true);
            context2.pushEvaluation(evaluation);
            try {
                this.evaluateSetValueBody(context2, target, value);
            }
            catch (OgnlException ex) {
                evalException = ex;
                ex.setEvaluation(evaluation);
                throw ex;
            }
            catch (RuntimeException ex) {
                evalException = ex;
                throw ex;
            }
            finally {
                Evaluation eval = context2.popEvaluation();
                if (evalException != null) {
                    eval.setException(evalException);
                }
                if (evalException == null && context2.getRootEvaluation() == null && !context2.getKeepLastEvaluation()) {
                    pool.recycleAll(eval);
                }
            }
        } else {
            this.evaluateSetValueBody(context2, target, value);
        }
    }

    protected void setValueBody(OgnlContext context2, Object target, Object value) throws OgnlException {
        throw new InappropriateExpressionException(this);
    }

    public boolean isNodeConstant(OgnlContext context2) throws OgnlException {
        return false;
    }

    public boolean isConstant(OgnlContext context2) throws OgnlException {
        return this.isNodeConstant(context2);
    }

    public boolean isNodeSimpleProperty(OgnlContext context2) throws OgnlException {
        return false;
    }

    public boolean isSimpleProperty(OgnlContext context2) throws OgnlException {
        return this.isNodeSimpleProperty(context2);
    }

    public boolean isSimpleNavigationChain(OgnlContext context2) throws OgnlException {
        return this.isSimpleProperty(context2);
    }

    public boolean isEvalChain(OgnlContext context2) throws OgnlException {
        if (this._children == null) {
            return false;
        }
        for (Node child : this._children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isEvalChain(context2)) continue;
            return true;
        }
        return false;
    }

    public boolean isSequence(OgnlContext context2) throws OgnlException {
        if (this._children == null) {
            return false;
        }
        for (Node child : this._children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isSequence(context2)) continue;
            return true;
        }
        return false;
    }

    public boolean isOperation(OgnlContext context2) throws OgnlException {
        if (this._children == null) {
            return false;
        }
        for (Node child : this._children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isOperation(context2)) continue;
            return true;
        }
        return false;
    }

    public boolean isChain(OgnlContext context2) throws OgnlException {
        if (this._children == null) {
            return false;
        }
        for (Node child : this._children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isChain(context2)) continue;
            return true;
        }
        return false;
    }

    public boolean isSimpleMethod(OgnlContext context2) throws OgnlException {
        return false;
    }

    protected boolean lastChild(OgnlContext context2) {
        return this._parent == null || context2.get("_lastChild") != null;
    }

    protected void flattenTree() {
        boolean shouldFlatten = false;
        int newSize = 0;
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i].getClass() == this.getClass()) {
                shouldFlatten = true;
                newSize += this._children[i].jjtGetNumChildren();
                continue;
            }
            ++newSize;
        }
        if (shouldFlatten) {
            Node[] newChildren = new Node[newSize];
            int j = 0;
            for (int i = 0; i < this._children.length; ++i) {
                Node c = this._children[i];
                if (c.getClass() == this.getClass()) {
                    for (int k = 0; k < c.jjtGetNumChildren(); ++k) {
                        newChildren[j++] = c.jjtGetChild(k);
                    }
                    continue;
                }
                newChildren[j++] = c;
            }
            if (j != newSize) {
                throw new Error("Assertion error: " + j + " != " + newSize);
            }
            this._children = newChildren;
        }
    }

    @Override
    public ExpressionAccessor getAccessor() {
        return this._accessor;
    }

    @Override
    public void setAccessor(ExpressionAccessor accessor) {
        this._accessor = accessor;
    }
}

